/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.io.storage.Storage;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FSRecords
implements Disposable,
Forceable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.vfs.persistent.FSRecords");
    private static final int VERSION = 9;
    private static final int PARENT_OFFSET = 0;
    private static final int PARENT_SIZE = 4;
    private static final int NAME_OFFSET = 4;
    private static final int NAME_SIZE = 4;
    private static final int FLAGS_OFFSET = 8;
    private static final int FLAGS_SIZE = 4;
    private static final int ATTREF_OFFSET = 12;
    private static final int ATTREF_SIZE = 4;
    private static final int CONTENT_OFFSET = 16;
    private static final int CONTENT_SIZE = 4;
    private static final int TIMESTAMP_OFFSET = 20;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int MODCOUNT_OFFSET = 28;
    private static final int MODCOUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 32;
    private static final int LENGTH_SIZE = 8;
    private static final int RECORD_SIZE = 40;
    private static final byte[] ZEROES = new byte[40];
    private static final int HEADER_VERSION_OFFSET = 0;
    private static final int HEADER_RESERVED_4BYTES_OFFSET = 4;
    private static final int HEADER_GLOBAL_MODCOUNT_OFFSET = 8;
    private static final int HEADER_CONNECTION_STATUS_OFFSET = 12;
    private static final int HEADER_SIZE = 16;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private static final int CORRUPTED_MAGIC = -1412464769;
    private static final String CHILDREN_ATT = "FsRecords.DIRECTORY_CHILDREN";
    private static final Object lock = new Object();
    private DbConnection myConnection;
    private static volatile int ourLocalModificationCount = 0;
    private static final int FREE_RECORD_FLAG = 256;
    private static final int ALL_VALID_FLAGS = 271;

    public void connect() {
        this.myConnection = DbConnection.connect();
    }

    private static ResizeableMappedFile getRecords() {
        return DbConnection.getRecords();
    }

    private static Storage getAttributes(int attId) {
        return DbConnection.getAttributes(attId);
    }

    public static PersistentStringEnumerator getNames() {
        return DbConnection.getNames();
    }

    public static int createRecord() {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                int free = DbConnection.getFreeRecord();
                if (free == 0) {
                    int filelength = (int)FSRecords.getRecords().length();
                    LOG.assertTrue(filelength % 40 == 0);
                    int newrecord = filelength / 40;
                    DbConnection.cleanRecord(newrecord);
                    assert ((long)(filelength + 40) == FSRecords.getRecords().length());
                    return newrecord;
                }
                DbConnection.cleanRecord(free);
                return free;
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecordRecursively(int id) {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                FSRecords.incModCount(id);
                this.doDeleteRecursively(id);
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    private void doDeleteRecursively(int id) {
        for (int subrecord : this.list(id)) {
            this.doDeleteRecursively(subrecord);
        }
        this.deleteRecord(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRecord(int id) {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                this.deleteAttribute(id, -1);
                this.deleteAttribute(id, DbConnection.CONTENT_ID);
                DbConnection.cleanRecord(id);
                this.addToFreeRecordsList(id);
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    private void deleteAttribute(int id, int isContent) throws IOException {
        int att_page = FSRecords.getAttributeRecordId(id, isContent);
        if (att_page != 0) {
            DataInputStream attStream = FSRecords.getAttributes(isContent).readStream(att_page);
            while (attStream.available() > 0) {
                attStream.readInt();
                int attAddress = attStream.readInt();
                FSRecords.getAttributes(isContent).deleteRecord(attAddress);
            }
            attStream.close();
            FSRecords.getAttributes(isContent).deleteRecord(att_page);
        }
    }

    private void addToFreeRecordsList(int id) throws IOException {
        DbConnection.addFreeRecord(id);
        this.setFlags(id, 256, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] listRoots() throws IOException {
        Object object = lock;
        synchronized (object) {
            int[] result;
            DbConnection.markDirty();
            DataInputStream input = this.readAttribute(1, CHILDREN_ATT);
            if (input == null) {
                return ArrayUtil.EMPTY_INT_ARRAY;
            }
            try {
                int count = input.readInt();
                result = ArrayUtil.newIntArray((int)count);
                for (int i = 0; i < count; ++i) {
                    input.readInt();
                    result[i] = input.readInt();
                }
            }
            finally {
                input.close();
            }
            return result;
        }
    }

    public void force() {
        DbConnection.force();
    }

    public boolean isDirty() {
        return DbConnection.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findRootRecord(String rootUrl) throws IOException {
        Object object = lock;
        synchronized (object) {
            int id;
            DbConnection.markDirty();
            int root = FSRecords.getNames().enumerate((Object)rootUrl);
            DataInputStream input = this.readAttribute(1, CHILDREN_ATT);
            int[] names = ArrayUtil.EMPTY_INT_ARRAY;
            int[] ids = ArrayUtil.EMPTY_INT_ARRAY;
            if (input != null) {
                try {
                    int count = input.readInt();
                    names = ArrayUtil.newIntArray((int)count);
                    ids = ArrayUtil.newIntArray((int)count);
                    for (int i = 0; i < count; ++i) {
                        int name = input.readInt();
                        int id2 = input.readInt();
                        if (name == root) {
                            int n = id2;
                            return n;
                        }
                        names[i] = name;
                        ids[i] = id2;
                    }
                }
                finally {
                    input.close();
                }
            }
            DataOutputStream output = this.writeAttribute(1, CHILDREN_ATT);
            try {
                id = FSRecords.createRecord();
                output.writeInt(names.length + 1);
                for (int i = 0; i < names.length; ++i) {
                    output.writeInt(names[i]);
                    output.writeInt(ids[i]);
                }
                output.writeInt(root);
                output.writeInt(id);
            }
            finally {
                output.close();
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRootRecord(int id) throws IOException {
        Object object = lock;
        synchronized (object) {
            int[] ids;
            int[] names;
            int count;
            DbConnection.markDirty();
            DataInputStream input = this.readAttribute(1, CHILDREN_ATT);
            assert (input != null);
            try {
                count = input.readInt();
                names = ArrayUtil.newIntArray((int)count);
                ids = ArrayUtil.newIntArray((int)count);
                for (int i = 0; i < count; ++i) {
                    names[i] = input.readInt();
                    ids[i] = input.readInt();
                }
            }
            finally {
                input.close();
            }
            int index = ArrayUtil.find((int[])ids, (int)id);
            assert (index >= 0);
            names = ArrayUtil.remove((int[])names, (int)index);
            ids = ArrayUtil.remove((int[])ids, (int)index);
            DataOutputStream output = this.writeAttribute(1, CHILDREN_ATT);
            try {
                output.writeInt(count - 1);
                for (int i = 0; i < names.length; ++i) {
                    output.writeInt(names[i]);
                    output.writeInt(ids[i]);
                }
            }
            finally {
                output.close();
            }
        }
    }

    public int[] list(int id) {
        Object object = lock;
        synchronized (object) {
            try {
                DataInputStream input = this.readAttribute(id, CHILDREN_ATT);
                if (input == null) {
                    return ArrayUtil.EMPTY_INT_ARRAY;
                }
                int count = input.readInt();
                int[] result = ArrayUtil.newIntArray((int)count);
                for (int i = 0; i < count; ++i) {
                    result[i] = input.readInt();
                }
                input.close();
                return result;
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wereChildrenAccessed(int id) {
        try {
            Object object = lock;
            synchronized (object) {
                int encodedAttId = DbConnection.getAttributeId(CHILDREN_ATT);
                int att = this.findAttributePage(id, encodedAttId, false);
                return att != 0;
            }
        }
        catch (Throwable e) {
            throw DbConnection.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateList(int id, int[] children) {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                DataOutputStream record = this.writeAttribute(id, CHILDREN_ATT);
                record.writeInt(children.length);
                for (int child : children) {
                    if (child == id) {
                        LOG.error("Cyclic parent child relations");
                        continue;
                    }
                    record.writeInt(child);
                }
                record.close();
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    private static void incModCount(int id) throws IOException {
        ++ourLocalModificationCount;
        int count = FSRecords.getModCount() + 1;
        FSRecords.getRecords().putInt(8, count);
        int parent = id;
        while (parent != 0) {
            FSRecords.setModCount(parent, count);
            parent = FSRecords.getParent(parent);
        }
    }

    public static int getLocalModCount() {
        return ourLocalModificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModCount() {
        Object object = lock;
        synchronized (object) {
            return FSRecords.getRecords().getInt(8);
        }
    }

    public static int getParent(int id) {
        Object object = lock;
        synchronized (object) {
            try {
                int parentId = FSRecords.getRecords().getInt(id * 40 + 0);
                if (parentId == id) {
                    LOG.error("Cyclic parent child relations in the database. id = " + id);
                    return 0;
                }
                return parentId;
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(int id, int parent) {
        if (id == parent) {
            LOG.error("Cyclic parent/child relations");
            return;
        }
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                FSRecords.incModCount(id);
                FSRecords.getRecords().putInt(id * 40 + 0, parent);
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    public static String getName(int id) {
        Object object = lock;
        synchronized (object) {
            try {
                int nameId = FSRecords.getRecords().getInt(id * 40 + 4);
                return nameId != 0 ? (String)FSRecords.getNames().valueOf(nameId) : "";
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(int id, String name) {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                FSRecords.incModCount(id);
                FSRecords.getRecords().putInt(id * 40 + 4, FSRecords.getNames().enumerate((Object)name));
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFlags(int id) {
        Object object = lock;
        synchronized (object) {
            return FSRecords.getRecords().getInt(id * 40 + 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlags(int id, int flags, boolean markAsChange) {
        Object object = lock;
        synchronized (object) {
            try {
                if (markAsChange) {
                    DbConnection.markDirty();
                    FSRecords.incModCount(id);
                }
                FSRecords.getRecords().putInt(id * 40 + 8, flags);
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLength(int id) {
        Object object = lock;
        synchronized (object) {
            return FSRecords.getRecords().getLong(id * 40 + 32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLength(int id, long len) {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                FSRecords.incModCount(id);
                FSRecords.getRecords().putLong(id * 40 + 32, len);
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestamp(int id) {
        Object object = lock;
        synchronized (object) {
            return FSRecords.getRecords().getLong(id * 40 + 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int id, long value) {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.markDirty();
                FSRecords.incModCount(id);
                FSRecords.getRecords().putLong(id * 40 + 20, value);
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModCount(int id) {
        Object object = lock;
        synchronized (object) {
            return FSRecords.getRecords().getInt(id * 40 + 28);
        }
    }

    private static void setModCount(int id, int value) throws IOException {
        FSRecords.getRecords().putInt(id * 40 + 28, value);
    }

    private static int getAttributeRecordId(int id, int attributeId) throws IOException {
        return FSRecords.getRecords().getInt(FSRecords.getAttrOffset(id, attributeId));
    }

    private static int getAttrOffset(int id, int attributeId) {
        return id * 40 + (DbConnection.CONTENT_ID == attributeId ? 16 : 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataInputStream readAttribute(int id, String attId) {
        try {
            String string = attId;
            synchronized (string) {
                int page;
                int encodedAttId;
                Object object = lock;
                synchronized (object) {
                    encodedAttId = DbConnection.getAttributeId(attId);
                    page = this.findAttributePage(id, encodedAttId, false);
                    if (page == 0) {
                        return null;
                    }
                }
                return FSRecords.getAttributes(encodedAttId).readStream(page);
            }
        }
        catch (Throwable e) {
            throw DbConnection.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findAttributePage(int fileId, int attributeId, boolean createIfNotFound) throws IOException {
        if (fileId <= 0) {
            throw DbConnection.handleError((Throwable)((Object)new AssertionError((Object)"assert fileId > 0 failed")));
        }
        if ((FSRecords.getFlags(fileId) & 0x100) != 0) {
            throw DbConnection.handleError((Throwable)((Object)new AssertionError((Object)"Trying to find an attribute of deleted page")));
        }
        int attrsRecord = FSRecords.getAttributeRecordId(fileId, attributeId);
        if (attrsRecord == 0) {
            if (!createIfNotFound) {
                return 0;
            }
            attrsRecord = FSRecords.getAttributes(attributeId).createNewRecord();
            FSRecords.getRecords().putInt(FSRecords.getAttrOffset(fileId, attributeId), attrsRecord);
        } else {
            DataInputStream attrRefs = FSRecords.getAttributes(attributeId).readStream(attrsRecord);
            try {
                while (attrRefs.available() > 0) {
                    int attIdOnPage = attrRefs.readInt();
                    int attAddress = attrRefs.readInt();
                    if (attIdOnPage != attributeId) continue;
                    int n = attAddress;
                    return n;
                }
            }
            finally {
                attrRefs.close();
            }
        }
        if (createIfNotFound) {
            Storage.AppenderStream appender = FSRecords.getAttributes(attributeId).appendStream(attrsRecord);
            appender.writeInt(attributeId);
            int attAddress = FSRecords.getAttributes(attributeId).createNewRecord();
            appender.writeInt(attAddress);
            appender.close();
            return attAddress;
        }
        return 0;
    }

    @NotNull
    public DataOutputStream writeAttribute(int id, String attId) {
        AttributeOutputStream attributeOutputStream = new AttributeOutputStream(id, attId);
        if (attributeOutputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/FSRecords.writeAttribute must not return null");
        }
        return attributeOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = lock;
        synchronized (object) {
            try {
                DbConnection.force();
                DbConnection.closeFiles();
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    public static void invalidateCaches() {
        DbConnection.createBrokenMarkerFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSanity() {
        long startTime = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            int fileLength = (int)FSRecords.getRecords().length();
            assert (fileLength % 40 == 0);
            int recordCount = fileLength / 40;
            IntArrayList usedAttributeRecordIds = new IntArrayList();
            IntArrayList validAttributeIds = new IntArrayList();
            for (int id = 2; id < recordCount; ++id) {
                int flags = FSRecords.getFlags(id);
                assert ((flags & 0xFFFFFEF0) == 0);
                if ((flags & 0x100) != 0) {
                    LOG.assertTrue(DbConnection.myFreeRecords.contains(id), (Object)("Record, marked free, not in free list: " + id));
                    continue;
                }
                LOG.assertTrue(!DbConnection.myFreeRecords.contains(id), (Object)("Record, not marked free, in free list: " + id));
                FSRecords.checkRecordSanity(id, recordCount, usedAttributeRecordIds, validAttributeIds);
            }
        }
        long endTime = System.currentTimeMillis();
    }

    private static void checkRecordSanity(int id, int recordCount, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) {
        int parentId = FSRecords.getParent(id);
        assert (parentId >= 0 && parentId < recordCount);
        if (parentId > 0) {
            int parentFlags = FSRecords.getFlags(parentId);
            assert ((parentFlags & 0x100) == 0);
            assert ((parentFlags & 2) != 0);
        }
        String name = FSRecords.getName(id);
        LOG.assertTrue(parentId == 0 || name.length() > 0, (Object)("File with empty name found under " + FSRecords.getName(parentId) + ", id=" + id));
        FSRecords.checkStorageSanity(id, usedAttributeRecordIds, validAttributeIds, -1);
        FSRecords.checkStorageSanity(id, usedAttributeRecordIds, validAttributeIds, DbConnection.CONTENT_ID);
        long length = FSRecords.getLength(id);
        assert (length >= -1L) : "Invalid file length found for " + name + ": " + length;
    }

    private static void checkStorageSanity(int id, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds, int attId) {
        int attributeRecordId;
        try {
            attributeRecordId = FSRecords.getAttributeRecordId(id, attId);
        }
        catch (IOException ex) {
            throw DbConnection.handleError(ex);
        }
        assert (attributeRecordId >= 0);
        if (attributeRecordId > 0) {
            try {
                FSRecords.checkAttributesSanity(attributeRecordId, usedAttributeRecordIds, validAttributeIds, attId);
            }
            catch (IOException ex) {
                throw DbConnection.handleError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAttributesSanity(int attributeRecordId, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds, int attrId) throws IOException {
        assert (!usedAttributeRecordIds.contains(attributeRecordId));
        usedAttributeRecordIds.add(attributeRecordId);
        DataInputStream dataInputStream = FSRecords.getAttributes(attrId).readStream(attributeRecordId);
        try {
            int streamSize = dataInputStream.available();
            assert (streamSize % 8 == 0);
            for (int i = 0; i < streamSize / 8; ++i) {
                int attId = dataInputStream.readInt();
                int attDataRecordId = dataInputStream.readInt();
                assert (!usedAttributeRecordIds.contains(attDataRecordId));
                usedAttributeRecordIds.add(attDataRecordId);
                if (!validAttributeIds.contains(attId)) {
                    assert (((String)FSRecords.getNames().valueOf(attId)).length() > 0);
                    validAttributeIds.add(attId);
                }
                FSRecords.getAttributes(attId).checkSanity(attDataRecordId);
            }
        }
        finally {
            dataInputStream.close();
        }
    }

    private class AttributeOutputStream
    extends DataOutputStream {
        private final String myAttributeId;
        private final int myFileId;

        private AttributeOutputStream(int fileId, String attributeId) {
            super(new ByteArrayOutputStream());
            this.myFileId = fileId;
            this.myAttributeId = attributeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            super.close();
            try {
                String string = this.myAttributeId;
                synchronized (string) {
                    int page;
                    int encodedAttId;
                    Object object = lock;
                    synchronized (object) {
                        DbConnection.markDirty();
                        FSRecords.incModCount(this.myFileId);
                        encodedAttId = DbConnection.getAttributeId(this.myAttributeId);
                        page = FSRecords.this.findAttributePage(this.myFileId, encodedAttId, true);
                    }
                    Storage.StorageDataOutput sinkStream = FSRecords.getAttributes(encodedAttId).writeStream(page);
                    sinkStream.write(((ByteArrayOutputStream)this.out).toByteArray());
                    sinkStream.close();
                }
            }
            catch (Throwable e) {
                throw DbConnection.handleError(e);
            }
        }
    }

    private static class DbConnection {
        private static int refCount = 0;
        private static final Object LOCK = new Object();
        private static final TObjectIntHashMap<String> myAttributeIds = new TObjectIntHashMap();
        private static int CONTENT_ID;
        private static PersistentStringEnumerator myNames;
        private static Storage myAttributes;
        private static Storage myContents;
        private static ResizeableMappedFile myRecords;
        private static final TIntArrayList myFreeRecords;
        private static boolean myDirty;
        private static ScheduledFuture<?> myFlushingFuture;
        private static boolean myCorrupted;

        private DbConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DbConnection connect() {
            Object object = LOCK;
            synchronized (object) {
                if (refCount == 0) {
                    DbConnection.init();
                    DbConnection.scanFreeRecords();
                    DbConnection.setupFlushing();
                }
                ++refCount;
            }
            return new DbConnection();
        }

        private static void scanFreeRecords() {
            int filelength = (int)DbConnection.getRecords().length();
            LOG.assertTrue(filelength % 40 == 0);
            int count = filelength / 40;
            for (int n = 2; n < count; ++n) {
                if ((FSRecords.getFlags(n) & 0x100) == 0) continue;
                DbConnection.addFreeRecord(n);
            }
        }

        public static int getFreeRecord() {
            if (myFreeRecords.isEmpty()) {
                return 0;
            }
            return myFreeRecords.remove(myFreeRecords.size() - 1);
        }

        private static void createBrokenMarkerFile() {
            File brokenMarker = DbConnection.getCorruptionMarkerFile();
            try {
                FileWriter writer = new FileWriter(brokenMarker);
                writer.write("These files are corrupted and must be rebuilt from the scratch on next startup");
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static File getCorruptionMarkerFile() {
            return new File(DbConnection.basePath(), "corruption.marker");
        }

        private static void init() {
            final File basePath = DbConnection.basePath();
            basePath.mkdirs();
            File namesFile = new File(basePath, "names.dat");
            File attributesFile = new File(basePath, "attrib.dat");
            File contentsFile = new File(basePath, "content.dat");
            File recordsFile = new File(basePath, "records.dat");
            if (!namesFile.exists()) {
                DbConnection.invalidateIndex();
            }
            try {
                if (DbConnection.getCorruptionMarkerFile().exists()) {
                    DbConnection.invalidateIndex();
                    throw new IOException("Corruption marker file found");
                }
                myNames = new PersistentStringEnumerator(namesFile);
                myAttributes = Storage.create((String)attributesFile.getCanonicalPath());
                myContents = Storage.create((String)contentsFile.getCanonicalPath());
                myRecords = new ResizeableMappedFile(recordsFile, 20480, new PagedFileStorage.StorageLock(false));
                if (myRecords.length() == 0L) {
                    DbConnection.cleanRecord(0);
                    DbConnection.cleanRecord(1);
                    DbConnection.setCurrentVersion();
                }
                if (DbConnection.getVersion() != 9) {
                    throw new IOException("FS repository version mismatch");
                }
                if (myRecords.getInt(12) != 523190095) {
                    throw new IOException("FS repository wasn't safely shut down");
                }
                DbConnection.markDirty();
            }
            catch (IOException e) {
                LOG.info("Filesystem storage is corrupted or does not exist. [Re]Building. Reason: " + e.getMessage());
                try {
                    DbConnection.closeFiles();
                    boolean deleted = true;
                    deleted &= FileUtil.delete((File)DbConnection.getCorruptionMarkerFile());
                    deleted &= DbConnection.deleteWithSubordinates(namesFile);
                    deleted &= Storage.deleteFiles((String)attributesFile.getCanonicalPath());
                    deleted &= Storage.deleteFiles((String)contentsFile.getCanonicalPath());
                    if (!(deleted &= DbConnection.deleteWithSubordinates(recordsFile))) {
                        throw new IOException("Cannot delete filesystem storage files");
                    }
                }
                catch (IOException e1) {
                    Runnable warnAndShutdown = new Runnable(){

                        @Override
                        public void run() {
                            boolean unitTest = ApplicationManager.getApplication().isUnitTestMode();
                            if (!unitTest && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Files in " + basePath.getPath() + " are locked. IntelliJ IDEA will not be able to start up", "Fatal Error", 0);
                            }
                            if (unitTest) {
                                e1.printStackTrace();
                            }
                            Runtime.getRuntime().halt(1);
                        }
                    };
                    if (EventQueue.isDispatchThread()) {
                        warnAndShutdown.run();
                    } else {
                        SwingUtilities.invokeLater(warnAndShutdown);
                    }
                    throw new RuntimeException("Can't rebuild filesystem storage ", e1);
                }
                DbConnection.init();
            }
        }

        private static void invalidateIndex() {
            LOG.info("Marking VFS as corrupted");
            FileUtil.createIfDoesntExist((File)new File(PathManager.getIndexRoot(), "corruption.marker"));
        }

        private static File basePath() {
            return new File(PathManager.getSystemPath() + "/caches/");
        }

        private static boolean deleteWithSubordinates(File file) {
            final String baseName = file.getName();
            File[] files = file.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(baseName);
                }
            });
            boolean ok = true;
            if (files != null) {
                for (File f : files) {
                    ok &= FileUtil.delete((File)f);
                }
            }
            return ok;
        }

        private static void markDirty() throws IOException {
            if (!myDirty) {
                myDirty = true;
                myRecords.putInt(12, 313341156);
            }
        }

        private static void setupFlushing() {
            myFlushingFuture = JobScheduler.getScheduler().scheduleAtFixedRate(new Runnable(){
                int lastModCount = 0;

                @Override
                public void run() {
                    if (this.lastModCount == ourLocalModificationCount && !HeavyProcessLatch.INSTANCE.isRunning()) {
                        DbConnection.flushSome();
                    }
                    this.lastModCount = ourLocalModificationCount;
                }
            }, 5000L, 5000L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void force() {
            Object object = lock;
            synchronized (object) {
                try {
                    DbConnection.markClean();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (myNames != null) {
                    myNames.force();
                    myAttributes.force();
                    myContents.force();
                    myRecords.force();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void flushSome() {
            Object object = lock;
            synchronized (object) {
                myNames.force();
                boolean attribsFlushed = myAttributes.flushSome();
                boolean contentsFlushed = myContents.flushSome();
                if (attribsFlushed && contentsFlushed) {
                    try {
                        DbConnection.markClean();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    myRecords.force();
                }
            }
        }

        public static boolean isDirty() {
            return myDirty || myNames.isDirty() || myAttributes.isDirty() || myContents.isDirty() || myRecords.isDirty();
        }

        private static int getVersion() throws IOException {
            int recordsVersion = myRecords.getInt(0);
            if (myAttributes.getVersion() != recordsVersion || myContents.getVersion() != recordsVersion) {
                return -1;
            }
            return recordsVersion;
        }

        private static void setCurrentVersion() throws IOException {
            myRecords.putInt(0, 9);
            myAttributes.setVersion(9);
            myContents.setVersion(9);
            myRecords.putInt(12, 523190095);
        }

        public static void cleanRecord(int id) throws IOException {
            myRecords.put(id * 40, ZEROES, 0, 40);
        }

        public static PersistentStringEnumerator getNames() {
            return myNames;
        }

        public static Storage getAttributes(int attId) {
            return attId == CONTENT_ID ? myContents : myAttributes;
        }

        public static ResizeableMappedFile getRecords() {
            return myRecords;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() throws IOException {
            Object object = LOCK;
            synchronized (object) {
                if (--refCount == 0) {
                    DbConnection.closeFiles();
                }
            }
        }

        private static void closeFiles() throws IOException {
            if (myFlushingFuture != null) {
                myFlushingFuture.cancel(false);
                myFlushingFuture = null;
            }
            if (myNames != null) {
                myNames.close();
                myNames = null;
            }
            if (myAttributes != null) {
                myAttributes.dispose();
                myAttributes = null;
            }
            if (myContents != null) {
                myContents.dispose();
                myContents = null;
            }
            if (myRecords != null) {
                DbConnection.markClean();
                myRecords.close();
                myRecords = null;
            }
        }

        private static void markClean() throws IOException {
            if (myDirty) {
                myDirty = false;
                myRecords.putInt(12, myCorrupted ? -1412464769 : 523190095);
            }
        }

        private static int getAttributeId(String attId) throws IOException {
            if (myAttributeIds.containsKey((Object)attId)) {
                return myAttributeIds.get((Object)attId);
            }
            int id = myNames.enumerate((Object)attId);
            myAttributeIds.put((Object)attId, id);
            if (PersistentFS.FILE_CONTENT.getId().equals(attId)) {
                CONTENT_ID = id;
            }
            return id;
        }

        private static RuntimeException handleError(Throwable e) {
            if (!myCorrupted) {
                DbConnection.createBrokenMarkerFile();
                myCorrupted = true;
                DbConnection.force();
            }
            return new RuntimeException(e);
        }

        public static void addFreeRecord(int id) {
            myFreeRecords.add(id);
        }

        static {
            myFreeRecords = new TIntArrayList();
            myDirty = false;
            myCorrupted = false;
        }
    }
}

