/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AnalyzeDependenciesHandler {
    private final Project myProject;
    private final List<AnalysisScope> myScopes;
    private final int myTransitiveBorder;
    private final Set<PsiFile> myExcluded;

    public AnalyzeDependenciesHandler(Project project, List<AnalysisScope> scopes, int transitiveBorder, Set<PsiFile> excluded) {
        this.myProject = project;
        this.myScopes = scopes;
        this.myTransitiveBorder = transitiveBorder;
        this.myExcluded = excluded;
    }

    public AnalyzeDependenciesHandler(Project project, AnalysisScope scope, int transitiveBorder) {
        this(project, Collections.singletonList(scope), transitiveBorder, new HashSet<PsiFile>());
    }

    public void analyze() {
        final ArrayList<ForwardDependenciesBuilder> builders = new ArrayList<ForwardDependenciesBuilder>();
        for (AnalysisScope scope : this.myScopes) {
            builders.add(new ForwardDependenciesBuilder(this.myProject, scope, this.myTransitiveBorder));
        }
        Runnable process = new Runnable(){

            @Override
            public void run() {
                for (DependenciesBuilder builder : builders) {
                    builder.analyze();
                }
            }
        };
        Runnable successRunnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DependenciesPanel panel = new DependenciesPanel(AnalyzeDependenciesHandler.this.myProject, builders, AnalyzeDependenciesHandler.this.myExcluded);
                        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, AnalysisScopeBundle.message((String)"package.dependencies.toolwindow.title", (Object[])new Object[]{((DependenciesBuilder)builders.get(0)).getScope().getDisplayName()}), false);
                        content.setDisposer((Disposable)panel);
                        panel.setContent(content);
                        ((DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)AnalyzeDependenciesHandler.this.myProject)).addContent(content);
                    }
                });
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(this.myProject, AnalysisScopeBundle.message((String)"package.dependencies.progress.title", (Object[])new Object[0]), process, successRunnable, null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(this.myProject));
    }
}

