/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionCache;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiClassImplUtil");
    private static final Key<Boolean> NAME_MAPS_BUILT_FLAG = Key.create((String)"NAME_MAPS_BUILT_FLAG");
    private static final Key<CachedValue<Map>> MAP_IN_CLASS_KEY = Key.create((String)"MAP_KEY");
    @NonNls
    private static final String ALL = "Intellij-IDEA-ALL";
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = new Function<ClassIconRequest, Icon>(){

        public Icon fun(ClassIconRequest r) {
            if (!r.psiClass.isValid() || r.psiClass.getProject().isDisposed()) {
                return null;
            }
            boolean isLocked = (r.flags & 2) != 0 && !r.psiClass.isWritable();
            Icon symbolIcon = ElementPresentationUtil.getClassIconOfKind(r.psiClass, ElementPresentationUtil.getClassKind(r.psiClass));
            RowIcon baseIcon = ElementBase.createLayeredIcon((Icon)symbolIcon, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)r.psiClass, isLocked));
            return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)r.psiClass, r.flags, baseIcon);
        }
    };

    @NotNull
    public static PsiField[] getAllFields(PsiClass aClass) {
        List<PsiField> map = PsiClassImplUtil.getAllByMap(aClass, PsiField.class);
        PsiField[] psiFieldArray = map.toArray(new PsiField[map.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getAllMethods(PsiClass aClass) {
        List<PsiMethod> methods = PsiClassImplUtil.getAllByMap(aClass, PsiMethod.class);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiClass[] getAllInnerClasses(PsiClass aClass) {
        List<PsiClass> classes = PsiClassImplUtil.getAllByMap(aClass, PsiClass.class);
        PsiClass[] psiClassArray = classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Nullable
    public static PsiField findFieldByName(PsiClass aClass, String name, boolean checkBases) {
        List<PsiField> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, PsiField.class);
        return byMap.isEmpty() ? null : byMap.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(PsiClass aClass, String name, boolean checkBases) {
        List<PsiMethod> methods = PsiClassImplUtil.findByMap(aClass, name, checkBases, PsiMethod.class);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(PsiClass aClass, PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> result = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, true);
        return result.isEmpty() ? null : result.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(PsiClass aClass, PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> methods = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiMethod> findMethodsBySignature(PsiClass aClass, PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        SmartList smartList;
        PsiMethod[] methodsByName = aClass.findMethodsByName(patternMethod.getName(), checkBases);
        if (methodsByName.length == 0) {
            smartList = Collections.emptyList();
            if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
            return smartList;
        }
        SmartList methods = new SmartList();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor = checkBases && !aClass.equals(superClass) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature = method.getSignature(substitutor);
            if (!signature.equals(patternSignature)) continue;
            methods.add(method);
            if (stopOnFirst) break;
        }
        if ((smartList = methods) != null) return smartList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
    }

    @Nullable
    public static PsiClass findInnerByName(PsiClass aClass, String name, boolean checkBases) {
        List<PsiClass> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, PsiClass.class);
        return byMap.isEmpty() ? null : byMap.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static <T extends PsiMember> List<T> findByMap(PsiClass aClass, String name, boolean checkBases, Class<T> type) {
        List list;
        if (name == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
            return list;
        }
        if (!checkBases) {
            PsiMember[] members = null;
            if (ReflectionCache.isAssignable(type, PsiMethod.class)) {
                members = (PsiMember[])aClass.getMethods();
            } else if (ReflectionCache.isAssignable(type, PsiClass.class)) {
                members = (PsiMember[])aClass.getInnerClasses();
            } else if (ReflectionCache.isAssignable(type, PsiField.class)) {
                members = (PsiMember[])aClass.getFields();
            }
            if (members == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
                return list;
            } else {
                ArrayList list2 = new ArrayList();
                for (PsiMember member : members) {
                    if (!name.equals(member.getName())) continue;
                    list2.add(member);
                }
                list = list2;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
                return list;
            }
        }
        Map<String, List<Pair<T, PsiSubstitutor>>> allMethodsMap = PsiClassImplUtil.getMap(aClass, type);
        List<Pair<T, PsiSubstitutor>> list3 = allMethodsMap.get(name);
        if (list3 == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
            return list;
        }
        ArrayList ret = new ArrayList();
        for (Pair<T, PsiSubstitutor> info : list3) {
            ret.add(info.getFirst());
        }
        list = ret;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
    }

    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(PsiClass aClass, Class<T> type) {
        Map<String, List<Pair<T, PsiSubstitutor>>> allMap = PsiClassImplUtil.getMap(aClass, type);
        return allMap.get(ALL);
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(PsiClass aClass, Class<T> type) {
        List<Pair<T, PsiSubstitutor>> pairs = PsiClassImplUtil.getAllWithSubstitutorsByMap(aClass, type);
        assert (pairs != null) : "pairs should be already computed. Wrong allMap: " + PsiClassImplUtil.getMap(aClass, type);
        ArrayList<PsiMember> ret = new ArrayList<PsiMember>(pairs.size());
        for (Pair<T, PsiSubstitutor> pair : pairs) {
            PsiMember t = (PsiMember)pair.getFirst();
            LOG.assertTrue(t != null, (Object)aClass);
            ret.add(t);
        }
        ArrayList<PsiMember> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllByMap must not return null");
        }
        return arrayList;
    }

    private static Map<Class<? extends PsiMember>, Map<String, List<Pair<PsiMember, PsiSubstitutor>>>> buildAllMaps(PsiClass psiClass) {
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> classes = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> fields = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> methods = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        FilterScopeProcessor<MethodCandidateInfo> processor = new FilterScopeProcessor<MethodCandidateInfo>((ElementFilter)new OrFilter(ElementClassFilter.METHOD, ElementClassFilter.FIELD, ElementClassFilter.CLASS)){

            @Override
            protected void add(PsiElement element, PsiSubstitutor substitutor) {
                if (element instanceof PsiMethod) {
                    methods.add(new Pair((Object)((PsiMethod)element), (Object)substitutor));
                } else if (element instanceof PsiField) {
                    fields.add(new Pair((Object)((PsiField)element), (Object)substitutor));
                } else if (element instanceof PsiClass) {
                    classes.add(new Pair((Object)((PsiClass)element), (Object)substitutor));
                }
            }
        };
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
        PsiClassImplUtil.processDeclarationsInClassNotCached(psiClass, processor, ResolveState.initial(), (Set<PsiClass>)new THashSet(), null, (PsiElement)psiClass, false, factory);
        HashMap result = new HashMap(3);
        result.put(PsiClass.class, PsiClassImplUtil.generateMapByList(classes));
        result.put(PsiMethod.class, PsiClassImplUtil.generateMapByList(methods));
        result.put(PsiField.class, PsiClassImplUtil.generateMapByList(fields));
        psiClass.putUserData(NAME_MAPS_BUILT_FLAG, (Object)Boolean.TRUE);
        return result;
    }

    private static Map<String, List<Pair<PsiMember, PsiSubstitutor>>> generateMapByList(@NotNull List<Pair<PsiMember, PsiSubstitutor>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.generateMapByList must not be null");
        }
        HashMap map = new HashMap();
        map.put(ALL, list);
        for (Pair<PsiMember, PsiSubstitutor> info : list) {
            PsiMember element = (PsiMember)info.getFirst();
            String currentName = element.getName();
            ArrayList<Pair<PsiMember, PsiSubstitutor>> listByName = (ArrayList<Pair<PsiMember, PsiSubstitutor>>)map.get(currentName);
            if (listByName == null) {
                listByName = new ArrayList<Pair<PsiMember, PsiSubstitutor>>(1);
                map.put(currentName, listByName);
            }
            listByName.add(info);
        }
        return map;
    }

    private static <T extends PsiMember> Map<String, List<Pair<T, PsiSubstitutor>>> getMap(PsiClass aClass, Class<T> memberClazz) {
        CachedValue value = (CachedValue)aClass.getUserData(MAP_IN_CLASS_KEY);
        if (value == null) {
            ByNameCachedValueProvider provider = new ByNameCachedValueProvider(aClass);
            value = CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue((CachedValueProvider)provider, false);
            if (aClass.isPhysical()) {
                value = (CachedValue)((UserDataHolderEx)aClass).putUserDataIfAbsent(MAP_IN_CLASS_KEY, (Object)value);
            }
        }
        return (Map)((Map)value.getValue()).get(memberClazz);
    }

    public static Icon getClassIcon(int flags, PsiClass aClass) {
        Icon symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass, ElementPresentationUtil.getBasicClassKind(aClass));
        RowIcon baseIcon = ElementBase.createLayeredIcon((Icon)symbolIcon, (int)0);
        return IconDeferrer.getInstance().defer(ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)aClass, flags, baseIcon), (Object)new ClassIconRequest(aClass, flags), FULL_ICON_EVALUATOR);
    }

    public static SearchScope getClassUseScope(PsiClass aClass) {
        PsiDirectory dir;
        GlobalSearchScope maximalUseScope = ((PsiManagerEx)aClass.getManager()).getFileManager().getUseScope((PsiElement)aClass);
        if (aClass instanceof PsiAnonymousClass) {
            return new LocalSearchScope((PsiElement)aClass);
        }
        PsiFile file = aClass.getContainingFile();
        if (JspPsiUtil.isInJspFile((PsiElement)file)) {
            return maximalUseScope;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (aClass.hasModifierProperty("public")) {
            return containingClass != null ? containingClass.getUseScope() : maximalUseScope;
        }
        if (aClass.hasModifierProperty("protected")) {
            return containingClass != null ? containingClass.getUseScope() : maximalUseScope;
        }
        if (aClass.hasModifierProperty("private") || aClass instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass((PsiElement)aClass);
            return new LocalSearchScope((PsiElement)(topClass == null ? aClass.getContainingFile() : topClass));
        }
        PsiPackage aPackage = null;
        if (file instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance((Project)aClass.getProject()).findPackage(((PsiJavaFile)file).getPackageName());
        }
        if (aPackage == null && (dir = file.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        }
        if (aPackage != null) {
            GlobalSearchScope scope = PackageScope.packageScope(aPackage, (boolean)false);
            scope = scope.intersectWith((SearchScope)maximalUseScope);
            return scope;
        }
        return new LocalSearchScope((PsiElement)file);
    }

    public static boolean isMainMethod(PsiMethod method) {
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        try {
            PsiMethod appMain = factory.createMethodFromText("void main(String[] args);", null);
            if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)appMain)) {
                return true;
            }
            PsiMethod appPremain = factory.createMethodFromText("void premain(String args, java.lang.instrument.Instrumentation i);", null);
            if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)appPremain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    public static boolean processDeclarationsInClass(PsiClass aClass, PsiScopeProcessor processor, ResolveState state, Set<PsiClass> visited, PsiElement last, PsiElement place, boolean isRaw) {
        if (visited != null && visited.contains(aClass)) {
            return true;
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        boolean bl = isRaw = isRaw || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor);
        if (last instanceof PsiTypeParameterList || last instanceof PsiModifierList) {
            return true;
        }
        Boolean built = (Boolean)aClass.getUserData(NAME_MAPS_BUILT_FLAG);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        if (built == null) {
            return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass, processor, state, visited, last, place, isRaw, factory);
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (nameHint != null) {
            PsiSubstitutor finalSubstitutor;
            List<Pair<PsiField, PsiSubstitutor>> list;
            if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.FIELD)) {
                PsiField fieldByName = aClass.findFieldByName(nameHint.getName(state), false);
                if (fieldByName != null) {
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)aClass);
                    if (!processor.execute((PsiElement)fieldByName, state)) {
                        return false;
                    }
                } else {
                    Map<String, List<Pair<PsiField, PsiSubstitutor>>> allFieldsMap = PsiClassImplUtil.getMap(aClass, PsiField.class);
                    list = allFieldsMap.get(nameHint.getName(state));
                    if (list != null) {
                        for (Pair<PsiField, PsiSubstitutor> candidate : list) {
                            PsiField candidateField = (PsiField)candidate.getFirst();
                            finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(candidateField.getContainingClass(), (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, place, factory);
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)candidateField.getContainingClass());
                            if (processor.execute((PsiElement)candidateField, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor))) continue;
                            return false;
                        }
                    }
                }
            }
            if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) {
                if (last != null && last.getParent() == aClass) {
                    if (last instanceof PsiClass && !processor.execute(last, state)) {
                        return false;
                    }
                    PsiTypeParameterList list2 = aClass.getTypeParameterList();
                    if (list2 != null && !list2.processDeclarations(processor, state, last, place)) {
                        return false;
                    }
                }
                if (!(last instanceof PsiReferenceList)) {
                    PsiClass classByName = aClass.findInnerClassByName(nameHint.getName(state), false);
                    if (classByName != null) {
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)aClass);
                        if (!processor.execute((PsiElement)classByName, state)) {
                            return false;
                        }
                    } else {
                        Map<String, List<Pair<PsiClass, PsiSubstitutor>>> allClassesMap = PsiClassImplUtil.getMap(aClass, PsiClass.class);
                        list = allClassesMap.get(nameHint.getName(state));
                        if (list != null) {
                            for (Pair<PsiField, PsiSubstitutor> candidate : list) {
                                PsiClass inner = (PsiClass)candidate.getFirst();
                                PsiClass containingClass = inner.getContainingClass();
                                if (containingClass == null) continue;
                                PsiSubstitutor finalSubstitutor2 = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, place, factory);
                                processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)containingClass);
                                if (processor.execute((PsiElement)inner, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor2))) continue;
                                return false;
                            }
                        }
                    }
                }
            }
            if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.METHOD)) {
                MethodResolverProcessor methodResolverProcessor;
                if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                    PsiMethod[] constructors = aClass.getConstructors();
                    methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                    for (PsiMethod constructor : constructors) {
                        if (methodResolverProcessor.execute((PsiElement)constructor, state)) continue;
                        return false;
                    }
                    return true;
                }
                Map<String, List<Pair<PsiMethod, PsiSubstitutor>>> allMethodsMap = PsiClassImplUtil.getMap(aClass, PsiMethod.class);
                List<Pair<PsiMethod, PsiSubstitutor>> list3 = allMethodsMap.get(nameHint.getName(state));
                if (list3 != null) {
                    for (Pair<PsiMethod, PsiSubstitutor> candidate : list3) {
                        PsiMethod candidateMethod = (PsiMethod)candidate.getFirst();
                        if (processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor()) continue;
                        PsiClass containingClass = candidateMethod.getContainingClass();
                        finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, place, factory);
                        if (isRaw && !candidateMethod.hasModifierProperty("static")) {
                            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
                            finalSubstitutor = factory.createRawSubstitutor(finalSubstitutor, methodTypeParameters);
                        }
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)containingClass);
                        if (processor.execute((PsiElement)candidateMethod, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass, processor, state, visited, last, place, isRaw, factory);
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, PsiSubstitutor candidateSubstitutor, PsiClass aClass, PsiSubstitutor substitutor, PsiElement place, PsiElementFactory elementFactory) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor)) {
            return elementFactory.createRawSubstitutor((PsiTypeParameterListOwner)candidateClass);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, PsiUtil.getLanguageLevel((PsiElement)place));
        PsiType type = substitutor.substitute((PsiType)containingType);
        if (!(type instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type).resolveGenerics().getSubstitutor();
    }

    private static boolean processDeclarationsInClassNotCached(PsiClass aClass, PsiScopeProcessor processor, ResolveState state, Set<PsiClass> visited, PsiElement last, PsiElement place, boolean isRaw, PsiElementFactory factory) {
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add(aClass)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)aClass);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.FIELD)) {
            if (nameHint != null) {
                PsiField fieldByName = aClass.findFieldByName(nameHint.getName(state), false);
                if (fieldByName != null && !processor.execute((PsiElement)fieldByName, state)) {
                    return false;
                }
            } else {
                PsiField[] fields;
                for (PsiField psiField : fields = aClass.getFields()) {
                    if (processor.execute((PsiElement)psiField, state)) continue;
                    return false;
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.METHOD)) {
            PsiMethod[] methods = nameHint != null ? aClass.findMethodsByName(nameHint.getName(state), false) : aClass.getMethods();
            for (PsiField psiField : methods) {
                if (isRaw && !psiField.hasModifierProperty("static")) {
                    PsiTypeParameter[] methodTypeParameters = psiField.getTypeParameters();
                    PsiSubstitutor raw = factory.createRawSubstitutor((PsiSubstitutor)state.get(PsiSubstitutor.KEY), methodTypeParameters);
                    state = state.put(PsiSubstitutor.KEY, (Object)raw);
                }
                if (processor.execute((PsiElement)psiField, state)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) {
            PsiTypeParameterList list;
            if (last != null && last.getParent() == aClass && (list = aClass.getTypeParameterList()) != null && !list.processDeclarations(processor, ResolveState.initial(), last, place)) {
                return false;
            }
            if (!(last instanceof PsiReferenceList) && !(last instanceof PsiModifierList)) {
                if (nameHint != null) {
                    PsiClass inner = aClass.findInnerClassByName(nameHint.getName(state), false);
                    if (inner != null && !processor.execute((PsiElement)inner, state)) {
                        return false;
                    }
                } else {
                    PsiClass[] inners = aClass.getInnerClasses();
                    for (PsiField psiField : inners) {
                        if (processor.execute((PsiElement)psiField, state)) continue;
                        return false;
                    }
                }
            }
        }
        return last instanceof PsiReferenceList || PsiClassImplUtil.processSuperTypes(aClass, processor, (Set<PsiClass>)visited, last, place, state, isRaw, factory);
    }

    private static boolean processSuperTypes(PsiClass aClass, PsiScopeProcessor processor, Set<PsiClass> visited, PsiElement last, PsiElement place, ResolveState state, boolean isRaw, PsiElementFactory factory) {
        for (PsiClassType superType : aClass.getSuperTypes()) {
            PsiSubstitutor finalSubstitutor;
            PsiClassType.ClassResolveResult superTypeResolveResult = superType.resolveGenerics();
            PsiClass superClass = superTypeResolveResult.getElement();
            if (superClass == null || PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state.put(PsiSubstitutor.KEY, (Object)(finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), place, factory))), visited, last, place, isRaw)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiClass getSuperClass(PsiClass psiClass) {
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope resolveScope = psiClass.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (psiClass.isInterface()) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        if (psiClass.isEnum()) {
            return facade.findClass("java.lang.Enum", resolveScope);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return facade.findClass("java.lang.Object", resolveScope);
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        PsiClass psiResoved = referenceElements[0].resolve();
        return psiResoved == null ? facade.findClass("java.lang.Object", resolveScope) : psiResoved;
    }

    @NotNull
    public static PsiClass[] getSupers(PsiClass psiClass) {
        PsiClass[] supers;
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupers must not return null");
        }
        return supers;
    }

    private static PsiClass[] getSupersInner(PsiClass psiClass) {
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), true);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    return psiClassArray2;
                }
                return new PsiClass[]{baseClass};
            }
            PsiClass objectClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
            if (objectClass != null) {
                PsiClass[] psiClassArray5 = new PsiClass[1];
                psiClassArray = psiClassArray5;
                psiClassArray5[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                if (objectClass != null) {
                    PsiClass[] psiClassArray6 = new PsiClass[1];
                    psiClassArray = psiClassArray6;
                    psiClassArray6[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                return psiClassArray;
            }
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        }
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            return interfaces;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        return types;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClassType[] getSuperTypes(PsiClass psiClass) {
        PsiClassType[] psiClassTypeArray;
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType objectType;
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (!(baseClass == null || !baseClass.isInterface() ? (psiClassTypeArray = new PsiClassType[]{baseClassType}) != null : (psiClassTypeArray = new PsiClassType[]{objectType = PsiType.getJavaLangObject((PsiManager)psiClass.getManager(), (GlobalSearchScope)psiClass.getResolveScope()), baseClassType}) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
                if (PsiClassType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
                return psiClassTypeArray;
            }
            PsiManager manager = psiClass.getManager();
            result[0] = objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result, extendsListLength, implementsTypes.length);
        for (int i = 0; i < result.length; ++i) {
            PsiClassType type = result[i];
            result[i] = (PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)type, (PsiElement)psiClass);
        }
        psiClassTypeArray = result;
        if (result != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
    }

    private static PsiClassType getAnnotationSuperType(PsiClass psiClass, PsiElementFactory factory) {
        return factory.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
    }

    private static PsiClassType getEnumSuperType(PsiClass psiClass, PsiElementFactory factory) {
        PsiClassType superType;
        PsiManager manager = psiClass.getManager();
        PsiClass enumClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Enum", psiClass.getResolveScope());
        if (enumClass == null) {
            try {
                superType = (PsiClassType)factory.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], (PsiType)factory.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass, substitutor);
        }
        return superType;
    }

    public static PsiClass[] getInterfaces(PsiTypeParameter typeParameter) {
        PsiClassType[] referencedTypes;
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClassType referencedType : referencedTypes = typeParameter.getExtendsListTypes()) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result.add(psiClass);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    public static PsiClass[] getInterfaces(PsiClass psiClass) {
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                return new PsiClass[]{baseClass};
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        return PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
    }

    private static PsiClass[] resolveClassReferenceList(PsiClassType[] listOfTypes, PsiManager manager, GlobalSearchScope resolveScope, boolean includeObject) {
        PsiClass objectClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Object", resolveScope);
        if (objectClass == null) {
            includeObject = false;
        }
        if (listOfTypes == null || listOfTypes.length == 0) {
            if (includeObject) {
                return new PsiClass[]{objectClass};
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        return resolved;
    }

    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(PsiClass psiClass, String name, boolean checkBases) {
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add((Pair<PsiMethod, PsiSubstitutor>)new Pair((Object)method, (Object)PsiSubstitutor.EMPTY));
            }
            return ret;
        }
        Map<String, List<Pair<PsiMethod, PsiSubstitutor>>> map = PsiClassImplUtil.getMap(psiClass, PsiMethod.class);
        List<Pair<PsiMethod, PsiSubstitutor>> list = map.get(name);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public static PsiClassType[] getExtendsListTypes(PsiClass psiClass) {
        if (psiClass.isEnum()) {
            return new PsiClassType[]{PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory())};
        }
        if (psiClass.isAnnotationType()) {
            return new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory())};
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            return extendsList.getReferencedTypes();
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public static PsiClassType[] getImplementsListTypes(PsiClass psiClass) {
        PsiReferenceList extendsList = psiClass.getImplementsList();
        if (extendsList != null) {
            return extendsList.getReferencedTypes();
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public static boolean isClassEquivalentTo(PsiClass aClass, PsiElement another) {
        PsiFile original2;
        PsiFile file2;
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                return p1.getIndex() == p2.getIndex() && aClass.getManager().areElementsEquivalent((PsiElement)p1.getOwner(), (PsiElement)p2.getOwner());
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (PsiClassImplUtil.originalElement(aClass).equals(PsiClassImplUtil.originalElement((PsiClass)another))) {
            return true;
        }
        PsiFile file1 = aClass.getContainingFile().getOriginalFile();
        if (file1.equals(file2 = another.getContainingFile().getOriginalFile())) {
            return true;
        }
        PsiFile original1 = (PsiFile)file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = (PsiFile)file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex();
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        return !(!fileIndex.isInSource(vfile1) && !fileIndex.isInLibraryClasses(vfile1) || !fileIndex.isInSource(vfile2) && !fileIndex.isInLibraryClasses(vfile2));
    }

    private static PsiElement originalElement(PsiClass aClass) {
        PsiElement originalElement = aClass.getOriginalElement();
        PsiCompiledElement compiled = (PsiCompiledElement)originalElement.getUserData(ClsElementImpl.COMPILED_ELEMENT);
        if (compiled != null) {
            return compiled;
        }
        return originalElement;
    }

    public static boolean isFieldEquivalentTo(PsiField field, PsiElement another) {
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent((PsiElement)aClass1, (PsiElement)aClass2);
    }

    public static boolean isMethodEquivalentTo(PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        String name1 = method1.getName();
        if (!another.isValid()) {
            return false;
        }
        String name2 = method2.getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent((PsiElement)aClass1, (PsiElement)aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type1 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type1 instanceof PsiArrayType) {
            if (!(type2 instanceof PsiArrayType)) {
                return false;
            }
            return PsiClassImplUtil.compareParamTypes(manager, ((PsiArrayType)type1).getComponentType(), ((PsiArrayType)type2).getComponentType());
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            return Comparing.equal((String)class1.getName(), (String)class2.getName()) && ((PsiTypeParameter)class1).getIndex() == ((PsiTypeParameter)class2).getIndex();
        }
        return manager.areElementsEquivalent((PsiElement)class1, (PsiElement)class2);
    }

    private static class ByNameCachedValueProvider
    implements CachedValueProvider<Map> {
        private final PsiClass myClass;

        private ByNameCachedValueProvider(PsiClass aClass) {
            this.myClass = aClass;
        }

        public CachedValueProvider.Result<Map> compute() {
            Map map = PsiClassImplUtil.buildAllMaps(this.myClass);
            return new CachedValueProvider.Result((Object)map, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }
    }

    private static class ClassIconRequest {
        public PsiClass psiClass;
        public int flags;

        private ClassIconRequest(PsiClass psiClass, int flags) {
            this.psiClass = psiClass;
            this.flags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            if (this.flags != that.flags) {
                return false;
            }
            return !(this.psiClass != null ? !this.psiClass.equals(that.psiClass) : that.psiClass != null);
        }

        public int hashCode() {
            int result = this.psiClass != null ? this.psiClass.hashCode() : 0;
            result = 31 * result + this.flags;
            return result;
        }
    }
}

