/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassReferenceExpression;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightKeyword;
import com.intellij.psi.impl.light.LightPackageReference;
import com.intellij.psi.impl.light.LightPackageReferenceExpression;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.impl.source.PsiExpressionCodeFragmentImpl;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceCodeFragmentImpl;
import com.intellij.psi.impl.source.PsiTypeCodeFragmentImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiElementFactoryImpl");
    private PsiClass ARRAY_CLASS;
    private PsiClass ARRAY_CLASS15;

    private static void initPrimitiveTypes() {
        ourPrimitiveTypesMap.put(PsiType.BYTE.getCanonicalText(), (PsiPrimitiveType)PsiType.BYTE);
        ourPrimitiveTypesMap.put(PsiType.CHAR.getCanonicalText(), (PsiPrimitiveType)PsiType.CHAR);
        ourPrimitiveTypesMap.put(PsiType.DOUBLE.getCanonicalText(), (PsiPrimitiveType)PsiType.DOUBLE);
        ourPrimitiveTypesMap.put(PsiType.FLOAT.getCanonicalText(), (PsiPrimitiveType)PsiType.FLOAT);
        ourPrimitiveTypesMap.put(PsiType.INT.getCanonicalText(), (PsiPrimitiveType)PsiType.INT);
        ourPrimitiveTypesMap.put(PsiType.LONG.getCanonicalText(), (PsiPrimitiveType)PsiType.LONG);
        ourPrimitiveTypesMap.put(PsiType.SHORT.getCanonicalText(), (PsiPrimitiveType)PsiType.SHORT);
        ourPrimitiveTypesMap.put(PsiType.BOOLEAN.getCanonicalText(), (PsiPrimitiveType)PsiType.BOOLEAN);
        ourPrimitiveTypesMap.put(PsiType.VOID.getCanonicalText(), (PsiPrimitiveType)PsiType.VOID);
        ourPrimitiveTypesMap.put(PsiType.NULL.getCanonicalText(), (PsiPrimitiveType)PsiType.NULL);
    }

    public PsiElementFactoryImpl(PsiManagerEx manager) {
        super(manager);
    }

    public PsiJavaFile getDummyJavaFile() {
        if (this.myDummyJavaFile == null) {
            this.myDummyJavaFile = this.createDummyJavaFile("");
        }
        return this.myDummyJavaFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        PsiClass psiClass;
        block6: {
            PsiClass psiClass2;
            if (languageLevel == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClass must not be null");
            }
            try {
                if (languageLevel.compareTo((Enum)LanguageLevel.JDK_1_5) >= 0) break block6;
                if (this.ARRAY_CLASS == null) {
                    this.ARRAY_CLASS = this.createClassFromText("public class __Array__{\n public final int length; \n public Object clone(){}\n}", null).getInnerClasses()[0];
                }
                psiClass2 = this.ARRAY_CLASS;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                psiClass = null;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClass must not return null");
            }
            psiClass = psiClass2;
            if (psiClass2 != null) return psiClass;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClass must not return null");
        }
        if (this.ARRAY_CLASS15 == null) {
            this.ARRAY_CLASS15 = this.createClassFromText("public class __Array__<T>{\n public final int length; \n public T[] clone(){}\n}", null).getInnerClasses()[0];
        }
        PsiClass psiClass3 = this.ARRAY_CLASS15;
        psiClass = psiClass3;
        if (psiClass3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClass must not return null");
        return psiClass;
    }

    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClassType must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClassType must not be null");
        }
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] typeParameters = arrayClass.getTypeParameters();
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], componentType);
        }
        PsiClassType psiClassType = this.createType(arrayClass, substitutor);
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClassType must not return null");
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor) {
        if (resolve == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel) {
        if (resolve == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor, languageLevel);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        if (resolve == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (annotations == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor, languageLevel, annotations);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClass createClass(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createClass must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        String text = "public class " + name + "{ }";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException();
        }
        PsiClass psiClass = classes[0];
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createClass must not return null");
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createInterface(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createInterface must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        String text = "public interface " + name + "{ }";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException();
        }
        PsiClass psiClass = classes[0];
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createInterface must not return null");
        }
        return psiClass;
    }

    public PsiClass createEnum(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createEnum must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        String text = "public enum " + name + "{ }";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException();
        }
        return classes[0];
    }

    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeElement must not be null");
        }
        LightTypeElement element = new LightTypeElement((PsiManager)this.myManager, psiType);
        CodeEditUtil.setNodeGenerated(element.getNode(), true);
        LightTypeElement lightTypeElement = element;
        if (lightTypeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeElement must not return null");
        }
        return lightTypeElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type) {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByType must not be null");
        }
        if (type instanceof PsiClassReferenceType) {
            psiJavaCodeReferenceElement = ((PsiClassReferenceType)type).getReference();
            if (psiJavaCodeReferenceElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByType must not return null");
            return psiJavaCodeReferenceElement;
        }
        PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
        psiJavaCodeReferenceElement = new LightClassReference((PsiManager)this.myManager, type.getPresentableText(), resolveResult.getElement(), resolveResult.getSubstitutor());
        if (psiJavaCodeReferenceElement != null) return psiJavaCodeReferenceElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByType must not return null");
    }

    @NotNull
    public PsiField createField(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createField must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createField must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create field with type \"<null_type>\".");
        }
        TreeElement typeCopy = ChangeUtil.copyToElement((PsiElement)this.createTypeElement(type));
        typeCopy.acceptTree(new GeneratedMarkerVisitor());
        String text = "class _Dummy_ {private int " + name + ";}";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass aClass = aFile.getClasses()[0];
        PsiField field = aClass.getFields()[0];
        SourceTreeToPsiMap.psiElementToTree((PsiElement)field).replaceChild(SourceTreeToPsiMap.psiElementToTree((PsiElement)field.getTypeElement()), (ASTNode)typeCopy);
        ChangeUtil.decodeInformation((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)field));
        PsiField psiField = (PsiField)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)field);
        if (psiField == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createField must not return null");
        }
        return psiField;
    }

    @NotNull
    public PsiMethod createMethod(@NotNull String name, PsiType returnType) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createMethod must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        if (PsiType.NULL.equals(returnType)) {
            throw new IncorrectOperationException("Cannot create field with type \"<null_type>\".");
        }
        String text = "class _Dummy_ {\n public " + returnType.getCanonicalText() + " " + name + "(){}\n}";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass aClass = aFile.getClasses()[0];
        PsiMethod method = aClass.getMethods()[0];
        JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)method);
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createMethod must not return null");
        }
        return psiMethod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiMethod createConstructor() {
        PsiMethod psiMethod;
        PsiMethod psiMethod2;
        try {
            String text = "class _Dummy_ {\n public _Dummy_(){}\n}";
            PsiJavaFile aFile = this.createDummyJavaFile(text);
            PsiClass aClass = aFile.getClasses()[0];
            PsiMethod method = aClass.getMethods()[0];
            psiMethod2 = (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
        }
        catch (IncorrectOperationException e) {
            LOG.assertTrue(false);
            psiMethod = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createConstructor must not return null");
        }
        psiMethod = psiMethod2;
        if (psiMethod2 != null) return psiMethod;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createConstructor must not return null");
    }

    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        String text = "class _Dummy_ { {} }";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass aClass = aFile.getClasses()[0];
        PsiClassInitializer psiClassInitializer = aClass.getInitializers()[0];
        PsiClassInitializer psiClassInitializer2 = (PsiClassInitializer)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)psiClassInitializer);
        if (psiClassInitializer2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createClassInitializer must not return null");
        }
        return psiClassInitializer2;
    }

    @NotNull
    public PsiParameter createParameter(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameter must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameter must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create field with type \"<null_type>\".");
        }
        FileElement treeHolder = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        CompositeElement treeElement = this.getJavaParsingContext(treeHolder).getDeclarationParsing().parseParameterText(type.getCanonicalText() + " " + name);
        treeHolder.rawAddChildren(treeElement);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myManager.getProject());
        PsiParameter parameter = (PsiParameter)SourceTreeToPsiMap.treeElementToPsi(treeElement);
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)CodeStyleSettingsManager.getSettings((Project)this.myManager.getProject()).GENERATE_FINAL_PARAMETERS);
        treeElement.acceptTree(new GeneratedMarkerVisitor());
        JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)parameter);
        PsiParameter psiParameter = (PsiParameter)codeStyleManager.reformat((PsiElement)parameter);
        if (psiParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParameter must not return null");
        }
        return psiParameter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock psiCodeBlock;
        PsiCodeBlock psiCodeBlock2;
        try {
            PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
            psiCodeBlock2 = (PsiCodeBlock)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)block);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            psiCodeBlock = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlock must not return null");
        }
        psiCodeBlock = psiCodeBlock2;
        if (psiCodeBlock2 != null) return psiCodeBlock;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlock must not return null");
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass, aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor((PsiTypeParameterListOwner)aClass));
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference) {
        if (classReference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(classReference, null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiClassReferenceType;
    }

    @NotNull
    public PsiType detachType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.detachType must not be null");
        }
        PsiType psiType = (PsiType)type.accept((PsiTypeVisitor)TypeDetacher.INSTANCE);
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.detachType must not return null");
        }
        return psiType;
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not be null");
        }
        HashMap substMap = null;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)owner)) {
            if (substMap == null) {
                substMap = new HashMap();
            }
            substMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not return null");
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, @NotNull PsiTypeParameter[] typeParameters) {
        if (baseSubstitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not be null");
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not be null");
        }
        HashMap substMap = null;
        for (PsiTypeParameter parameter : typeParameters) {
            if (substMap == null) {
                substMap = new HashMap();
            }
            substMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = baseSubstitutor.putAll(PsiSubstitutorImpl.createSubstitutor(substMap));
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not return null");
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiElement createDummyHolder(@NotNull String text, @NotNull IElementType type, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createDummyHolder must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createDummyHolder must not be null");
        }
        DummyHolder result = DummyHolderFactory.createHolder(this.myManager, context);
        FileElement holder = result.getTreeElement();
        Language language = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for language " + language));
        }
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, (ASTNode)holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createDummyHolder must not return null");
        }
        return psiElement;
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createSubstitutor must not be null");
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(map);
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createSubstitutor must not return null");
        }
        return psiSubstitutor;
    }

    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPrimitiveType must not be null");
        }
        return PsiElementFactoryImpl.getPrimitiveType(text);
    }

    public static PsiPrimitiveType getPrimitiveType(String text) {
        return (PsiPrimitiveType)ourPrimitiveTypesMap.get(text);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not be null");
        }
        PsiClassType psiClassType = this.createTypeByFQClassName(qName, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not return null");
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not be null");
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not return null");
        }
        return psiClassReferenceType;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createClassReferenceElement must not be null");
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        LightClassReference lightClassReference = new LightClassReference(this.myManager, text, aClass);
        if (lightClassReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createClassReferenceElement must not return null");
        }
        return lightClassReference;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByFQClassName must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByFQClassName must not be null");
        }
        String shortName = PsiNameHelper.getShortClassName((String)qName);
        LightClassReference lightClassReference = new LightClassReference((PsiManager)this.myManager, shortName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByFQClassName must not return null");
        }
        return lightClassReference;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createFQClassNameReferenceElement must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createFQClassNameReferenceElement must not be null");
        }
        LightClassReference lightClassReference = new LightClassReference((PsiManager)this.myManager, qName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createFQClassNameReferenceElement must not return null");
        }
        return lightClassReference;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not be null");
        }
        if (aPackage.getQualifiedName().length() == 0) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference((PsiManager)this.myManager, aPackage);
        if (lightPackageReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not return null");
        }
        return lightPackageReference;
    }

    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPackageStatement must not be null");
        }
        PsiJavaFile javaFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("dummy.java", "package " + name + ";");
        PsiPackageStatement stmt = javaFile.getPackageStatement();
        if (stmt == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name);
        }
        PsiPackageStatement psiPackageStatement = stmt;
        if (psiPackageStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createPackageStatement must not return null");
        }
        return psiPackageStatement;
    }

    @NotNull
    public PsiJavaCodeReferenceCodeFragment createReferenceCodeFragment(@NotNull String text, PsiElement context, boolean isPhysical, boolean isClassesAccepted) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceCodeFragment must not be null");
        }
        PsiJavaCodeReferenceCodeFragmentImpl result = new PsiJavaCodeReferenceCodeFragmentImpl(this.myManager.getProject(), isPhysical, "fragment.java", (CharSequence)text, isClassesAccepted);
        result.setContext(context);
        PsiJavaCodeReferenceCodeFragmentImpl psiJavaCodeReferenceCodeFragmentImpl = result;
        if (psiJavaCodeReferenceCodeFragmentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceCodeFragment must not return null");
        }
        return psiJavaCodeReferenceCodeFragmentImpl;
    }

    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStaticStatement must not be null");
        }
        if (memberName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStaticStatement must not be null");
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        String text = "import static " + aClass.getQualifiedName() + "." + memberName + ";";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiImportStaticStatement statement = aFile.getImportList().getImportStaticStatements()[0];
        PsiImportStaticStatement psiImportStaticStatement = (PsiImportStaticStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStaticStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createImportStaticStatement must not return null");
        }
        return psiImportStaticStatement;
    }

    @NotNull
    public PsiParameterList createParameterList(@NotNull String[] names, @NotNull PsiType[] types) throws IncorrectOperationException {
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameterList must not be null");
        }
        if (types == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameterList must not be null");
        }
        String text = "void method(";
        String sep = "";
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            PsiType type = types[i];
            text = text + sep + type.getCanonicalText() + " " + name;
            sep = ",";
        }
        text = text + "){}";
        PsiMethod method = this.createMethodFromText(text, null);
        PsiParameterList psiParameterList = method.getParameterList();
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParameterList must not return null");
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList createReferenceList(@NotNull PsiJavaCodeReferenceElement[] references) throws IncorrectOperationException {
        if (references == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceList must not be null");
        }
        String text = "void method() ";
        if (references.length > 0) {
            text = text + "throws ";
        }
        String sep = "";
        for (PsiJavaCodeReferenceElement reference : references) {
            text = text + sep + reference.getCanonicalText();
            sep = ",";
        }
        text = text + "{}";
        PsiMethod method = this.createMethodFromText(text, null);
        PsiReferenceList psiReferenceList = method.getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceList must not return null");
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not be null");
        }
        if (packageName.length() == 0) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference((PsiManager)this.myManager, packageName);
        if (lightPackageReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not return null");
        }
        return lightPackageReference;
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not be null");
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        LightClassReferenceExpression lightClassReferenceExpression = new LightClassReferenceExpression(this.myManager, text, aClass);
        if (lightClassReferenceExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not return null");
        }
        return lightClassReferenceExpression;
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not be null");
        }
        if (aPackage.getQualifiedName().length() == 0) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReferenceExpression lightPackageReferenceExpression = new LightPackageReferenceExpression((PsiManager)this.myManager, aPackage);
        if (lightPackageReferenceExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not return null");
        }
        return lightPackageReferenceExpression;
    }

    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createIdentifier must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)text);
        LightIdentifier lightIdentifier = new LightIdentifier((PsiManager)this.myManager, text);
        if (lightIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createIdentifier must not return null");
        }
        return lightIdentifier;
    }

    @NotNull
    public PsiKeyword createKeyword(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createKeyword must not be null");
        }
        if (!JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getNameHelper().isKeyword(text)) {
            throw new IncorrectOperationException("\"" + text + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword((PsiManager)this.myManager, text);
        if (lightKeyword == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createKeyword must not return null");
        }
        return lightKeyword;
    }

    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatement must not be null");
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        String text = "import " + aClass.getQualifiedName() + ";";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiImportStatement statement = aFile.getImportList().getImportStatements()[0];
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatement must not return null");
        }
        return psiImportStatement;
    }

    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatementOnDemand must not be null");
        }
        if (packageName.length() == 0) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getNameHelper().isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        String text = "import " + packageName + ".*;";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiImportStatement statement = aFile.getImportList().getImportStatements()[0];
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatementOnDemand must not return null");
        }
        return psiImportStatement;
    }

    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NotNull String name, @NotNull PsiType type, PsiExpression initializer) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createVariableDeclarationStatement must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createVariableDeclarationStatement must not be null");
        }
        if (!JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getNameHelper().isIdentifier(name)) {
            throw new IncorrectOperationException("\"" + name + "\" is not an identifier.");
        }
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create field with type \"<null_type>\".");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("X ");
        buffer.append(name);
        if (initializer != null) {
            buffer.append("=x");
        }
        buffer.append(";");
        PsiDeclarationStatement statement = (PsiDeclarationStatement)this.createStatementFromText(buffer.toString(), null);
        PsiVariable variable = (PsiVariable)statement.getDeclaredElements()[0];
        variable.getTypeElement().replace((PsiElement)this.createTypeElement(type));
        PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)CodeStyleSettingsManager.getSettings((Project)this.myManager.getProject()).GENERATE_FINAL_LOCALS);
        if (initializer != null) {
            variable.getInitializer().replace((PsiElement)initializer);
        }
        PsiElementFactoryImpl.markGenerated((PsiElement)statement);
        PsiDeclarationStatement psiDeclarationStatement = statement;
        if (psiDeclarationStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createVariableDeclarationStatement must not return null");
        }
        return psiDeclarationStatement;
    }

    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, @NonNls String description) throws IncorrectOperationException {
        if (parameterName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParamTag must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(" * @param ");
        buffer.append(parameterName);
        buffer.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (i > 0) {
                buffer.append("\n * ");
            }
            buffer.append(string);
        }
        PsiDocTag psiDocTag = this.createDocTagFromText(buffer.toString(), null);
        if (psiDocTag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParamTag must not return null");
        }
        return psiDocTag;
    }

    @NotNull
    public PsiExpressionCodeFragment createExpressionCodeFragment(@NotNull String text, PsiElement context, PsiType expectedType, boolean isPhysical) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createExpressionCodeFragment must not be null");
        }
        PsiExpressionCodeFragmentImpl result = new PsiExpressionCodeFragmentImpl(this.myManager.getProject(), isPhysical, "fragment.java", (CharSequence)text, expectedType);
        result.setContext(context);
        PsiExpressionCodeFragmentImpl psiExpressionCodeFragmentImpl = result;
        if (psiExpressionCodeFragmentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createExpressionCodeFragment must not return null");
        }
        return psiExpressionCodeFragmentImpl;
    }

    @NotNull
    public JavaCodeFragment createCodeBlockCodeFragment(@NotNull String text, PsiElement context, boolean isPhysical) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlockCodeFragment must not be null");
        }
        PsiCodeFragmentImpl result = new PsiCodeFragmentImpl(this.myManager.getProject(), JavaElementType.STATEMENTS, isPhysical, "fragment.java", text);
        result.setContext(context);
        PsiCodeFragmentImpl psiCodeFragmentImpl = result;
        if (psiCodeFragmentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlockCodeFragment must not return null");
        }
        return psiCodeFragmentImpl;
    }

    @NotNull
    public PsiTypeCodeFragment createTypeCodeFragment(@NotNull String text, PsiElement context, boolean isPhysical) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeCodeFragment must not be null");
        }
        PsiTypeCodeFragment psiTypeCodeFragment = this.createTypeCodeFragment(text, context, false, isPhysical, false);
        if (psiTypeCodeFragment == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeCodeFragment must not return null");
        }
        return psiTypeCodeFragment;
    }

    @NotNull
    public PsiTypeCodeFragment createTypeCodeFragment(@NotNull String text, PsiElement context, boolean isVoidValid, boolean isPhysical) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeCodeFragment must not be null");
        }
        PsiTypeCodeFragment psiTypeCodeFragment = this.createTypeCodeFragment(text, context, true, isPhysical, false);
        if (psiTypeCodeFragment == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeCodeFragment must not return null");
        }
        return psiTypeCodeFragment;
    }

    @NotNull
    public PsiTypeCodeFragment createTypeCodeFragment(@NotNull String text, PsiElement context, boolean isVoidValid, boolean isPhysical, boolean allowEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeCodeFragment must not be null");
        }
        PsiTypeCodeFragmentImpl result = new PsiTypeCodeFragmentImpl(this.myManager.getProject(), isPhysical, allowEllipsis, "fragment.java", (CharSequence)text);
        result.setContext(context);
        if (isVoidValid) {
            result.putUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT, Boolean.TRUE);
        }
        PsiTypeCodeFragmentImpl psiTypeCodeFragmentImpl = result;
        if (psiTypeCodeFragmentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeCodeFragment must not return null");
        }
        return psiTypeCodeFragmentImpl;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createAnnotationFromText must not be null");
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createAnnotationFromText must not return null");
        }
        return psiAnnotation2;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlockFromText must not be null");
        }
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)psiCodeBlock);
        PsiCodeBlock psiCodeBlock2 = psiCodeBlock;
        if (psiCodeBlock2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlockFromText must not return null");
        }
        return psiCodeBlock2;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createEnumConstantFromText must not be null");
        }
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)enumConstant);
        PsiEnumConstant psiEnumConstant = enumConstant;
        if (psiEnumConstant == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createEnumConstantFromText must not return null");
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createExpressionFromText must not be null");
        }
        PsiExpression expression = super.createExpressionFromText(text, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)expression);
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createExpressionFromText must not return null");
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createFieldFromText must not be null");
        }
        PsiField psiField = super.createFieldFromText(text, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)psiField);
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createFieldFromText must not return null");
        }
        return psiField2;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameterFromText must not be null");
        }
        PsiParameter parameter = super.createParameterFromText(text, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)parameter);
        PsiParameter psiParameter = parameter;
        if (psiParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParameterFromText must not return null");
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createStatementFromText must not be null");
        }
        PsiStatement statement = super.createStatementFromText(text, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)statement);
        PsiStatement psiStatement = statement;
        if (psiStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createStatementFromText must not return null");
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeFromText must not be null");
        }
        PsiType psiType = this.createTypeInner(text, context, true);
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeFromText must not return null");
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeParameterFromText must not be null");
        }
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)typeParameter);
        PsiTypeParameter psiTypeParameter = typeParameter;
        if (psiTypeParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeParameterFromText must not return null");
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createWhiteSpaceFromText must not be null");
        }
        PsiElement whitespace = super.createWhiteSpaceFromText(text);
        PsiElementFactoryImpl.markGenerated(whitespace);
        PsiElement psiElement = whitespace;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createWhiteSpaceFromText must not return null");
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createMethodFromText must not be null");
        }
        PsiMethod method = super.createMethodFromText(text, context, level);
        PsiElementFactoryImpl.markGenerated((PsiElement)method);
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createMethodFromText must not return null");
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiClassType exceptionType, @NotNull String exceptionName, PsiElement context) throws IncorrectOperationException {
        if (exceptionType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createCatchSection must not be null");
        }
        if (exceptionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createCatchSection must not be null");
        }
        PsiCatchSection psiCatchSection = super.createCatchSection(exceptionType, exceptionName, context);
        PsiElementFactoryImpl.markGenerated((PsiElement)psiCatchSection);
        PsiCatchSection psiCatchSection2 = psiCatchSection;
        if (psiCatchSection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCatchSection must not return null");
        }
        return psiCatchSection2;
    }

    private static void markGenerated(PsiElement element) {
        ((TreeElement)element.getNode()).acceptTree(new GeneratedMarkerVisitor());
    }

    static {
        PsiElementFactoryImpl.initPrimitiveTypes();
    }

    private static class TypeDetacher
    extends PsiTypeVisitor<PsiType> {
        public static final TypeDetacher INSTANCE = new TypeDetacher();

        private TypeDetacher() {
        }

        public PsiType visitType(PsiType type) {
            return type;
        }

        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            return PsiWildcardType.changeBound((PsiWildcardType)wildcardType, (PsiType)((PsiType)bound.accept((PsiTypeVisitor)this)));
        }

        public PsiType visitArrayType(PsiArrayType arrayType) {
            PsiType componentType = arrayType.getComponentType();
            PsiType detachedComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
            if (detachedComponentType == componentType) {
                return arrayType;
            }
            return detachedComponentType.createArrayType();
        }

        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return classType;
            }
            HashMap map = new HashMap();
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                PsiType type = resolveResult.getSubstitutor().substitute(parameter);
                if (type != null) {
                    type = (PsiType)type.accept((PsiTypeVisitor)this);
                }
                map.put((Object)parameter, (Object)type);
            }
            return new PsiImmediateClassType(aClass, PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)map));
        }
    }
}

