/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.FileTypeIdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer> {
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create((String)"IdIndex");
    private final FileBasedIndex.InputFilter myInputFilter = new FileBasedIndex.InputFilter(){
        private final FileTypeManager myFtManager = FileTypeManager.getInstance();

        @Override
        public boolean acceptInput(VirtualFile file) {
            FileType fileType = this.myFtManager.getFileTypeByFile(file);
            return IdIndex.isIndexable(fileType) && !ProjectUtil.isProjectOrWorkspaceFile(file, fileType);
        }
    };
    private final DataExternalizer<Integer> myValueExternalizer = new DataExternalizer<Integer>(){

        public void save(DataOutput out, Integer value) throws IOException {
            out.writeByte(value);
        }

        public Integer read(DataInput in) throws IOException {
            return in.readByte();
        }
    };
    private final KeyDescriptor<IdIndexEntry> myKeyDescriptor = new InlineKeyDescriptor<IdIndexEntry>(){

        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };
    private final DataIndexer<IdIndexEntry, Integer, FileContent> myIndexer = new DataIndexer<IdIndexEntry, Integer, FileContent>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Map<IdIndexEntry, Integer> map(FileContent inputData) {
            Map<Object, Object> map;
            FileTypeIdIndexer indexer = IdTableBuilding.getFileTypeIndexer(inputData.getFileType());
            if (indexer != null) {
                map = indexer.map(inputData);
                if (map == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdIndex$4.map must not return null");
                return map;
            }
            map = Collections.emptyMap();
            if (map != null) return map;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/IdIndex$4.map must not return null");
        }
    };

    @Override
    public int getVersion() {
        return 9;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public ID<IdIndexEntry, Integer> getName() {
        return NAME;
    }

    @Override
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @Override
    public DataExternalizer<Integer> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @Override
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    private static boolean isIndexable(FileType fileType) {
        return fileType instanceof LanguageFileType || fileType instanceof AbstractFileType || IdTableBuilding.isIdIndexerRegistered(fileType) || CacheBuilderRegistry.getInstance().getCacheBuilder(fileType) != null;
    }
}

