/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.StoppableLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.parsing.WhiteSpaceAndCommentsProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.DeclarationParsing");

    public DeclarationParsing(JavaParsingContext context) {
        super(context);
    }

    public TreeElement parseEnumConstantText(CharSequence buffer) {
        JavaLexer originalLexer = new JavaLexer(LanguageLevel.JDK_1_5);
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer);
        return this.parseEnumConstant((Lexer)lexer);
    }

    public TreeElement parseDeclarationText(PsiManager manager, LanguageLevel languageLevel, CharSequence buffer, Context context) {
        JavaLexer originalLexer = new JavaLexer(languageLevel);
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer);
        TreeElement first = this.parseDeclaration((Lexer)lexer, context);
        if (first == null) {
            return null;
        }
        if (lexer.getTokenType() != null) {
            return null;
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        dummyRoot.rawAddChildren(first);
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return first;
    }

    public TreeElement parseMemberValueText(PsiManager manager, CharSequence buffer, LanguageLevel languageLevel) {
        JavaLexer originalLexer = new JavaLexer(languageLevel);
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer);
        TreeElement first = this.parseAnnotationMemberValue((Lexer)lexer);
        if (first == null) {
            return null;
        }
        if (lexer.getTokenType() != null) {
            return null;
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        dummyRoot.rawAddChildren(first);
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return first;
    }

    protected TreeElement parseDeclaration(Lexer lexer, Context context) {
        CompositeElement type;
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context == Context.FILE_CONTEXT || context == Context.CODE_BLOCK_CONTEXT) {
                return null;
            }
        } else if (tokenType == JavaTokenType.IDENTIFIER || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
            if (context == Context.FILE_CONTEXT) {
                return null;
            }
        } else {
            if (tokenType instanceof ILazyParseableElementType) {
                LazyParseableElement declaration = ASTFactory.lazy((ILazyParseableElementType)tokenType, this.myContext.tokenText(lexer));
                lexer.advance();
                return declaration;
            }
            if (!(ElementType.MODIFIER_BIT_SET.contains(tokenType) || ElementType.CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context != Context.CODE_BLOCK_CONTEXT && tokenType == JavaTokenType.LT)) {
                return null;
            }
        }
        LexerPosition startPos = lexer.getCurrentPosition();
        CompositeElement modifierList = this.parseModifierList(lexer);
        tokenType = lexer.getTokenType();
        if (tokenType == JavaTokenType.AT) {
            TreeElement atToken = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            tokenType = lexer.getTokenType();
            if (tokenType == JavaTokenType.INTERFACE_KEYWORD) {
                return this.parseClassFromKeyword(lexer, modifierList, atToken);
            }
            lexer.restore(startPos);
            return null;
        }
        if (ElementType.CLASS_KEYWORD_BIT_SET.contains(tokenType)) {
            CompositeElement root = this.parseClassFromKeyword(lexer, modifierList, null);
            if (context == Context.FILE_CONTEXT) {
                boolean declsAfterEnd = false;
                while (lexer.getTokenType() != null && lexer.getTokenType() != JavaTokenType.RBRACE) {
                    LexerPosition position = lexer.getCurrentPosition();
                    TreeElement element = this.parseDeclaration(lexer, Context.CLASS_CONTEXT);
                    if (element != null && (element.getElementType() == JavaElementType.METHOD || element.getElementType() == JavaElementType.FIELD)) {
                        if (!declsAfterEnd) {
                            CompositeElement classExpected = Factory.createErrorElement(JavaErrorMessages.message("expected.class.or.interface", new Object[0]));
                            root.rawAddChildren(classExpected);
                        }
                        declsAfterEnd = true;
                        root.rawAddChildren(element);
                        continue;
                    }
                    lexer.restore(position);
                    break;
                }
                if (declsAfterEnd) {
                    this.expectRBrace(root, lexer);
                }
            }
            return root;
        }
        TreeElement classParameterList = null;
        if (tokenType == JavaTokenType.LT) {
            classParameterList = this.parseTypeParameterList(lexer);
            tokenType = lexer.getTokenType();
        }
        if (context == Context.FILE_CONTEXT) {
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.class.or.interface", new Object[0]));
            modifierList.rawInsertAfterMe(errorElement);
            if (classParameterList != null) {
                errorElement.rawInsertAfterMe(classParameterList);
            }
            return modifierList;
        }
        CompositeElement first = modifierList;
        CompositeElement last = modifierList;
        if (tokenType != null && ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
            type = this.parseType(lexer);
        } else if (tokenType == JavaTokenType.IDENTIFIER) {
            LexerPosition idPos = lexer.getCurrentPosition();
            type = this.parseType(lexer);
            if (lexer.getTokenType() == JavaTokenType.LPARENTH) {
                if (context == Context.CODE_BLOCK_CONTEXT) {
                    lexer.restore(startPos);
                    return null;
                }
                lexer.restore(idPos);
                CompositeElement method = ASTFactory.composite(JavaElementType.METHOD);
                method.rawAddChildren(first);
                if (classParameterList == null) {
                    classParameterList = ASTFactory.composite(JavaElementType.TYPE_PARAMETER_LIST);
                }
                method.rawAddChildren(classParameterList);
                method.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                if (lexer.getTokenType() != JavaTokenType.LPARENTH) {
                    lexer.restore(startPos);
                    return null;
                }
                this.parseMethodFromLparenth(lexer, method, false);
                return method;
            }
        } else {
            if (tokenType == JavaTokenType.LBRACE) {
                if (context == Context.CODE_BLOCK_CONTEXT) {
                    CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.identifier.or.type", new Object[0]));
                    last.rawInsertAfterMe(errorElement);
                    return first;
                }
                TreeElement codeBlock = this.myContext.getStatementParsing().parseCodeBlock(lexer, false);
                LOG.assertTrue(codeBlock != null);
                CompositeElement initializer = ASTFactory.composite(JavaElementType.CLASS_INITIALIZER);
                initializer.rawAddChildren(modifierList);
                if (classParameterList != null) {
                    CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("unexpected.token", new Object[0]));
                    errorElement.rawAddChildren(classParameterList);
                    initializer.rawAddChildren(errorElement);
                }
                initializer.rawAddChildren(codeBlock);
                return initializer;
            }
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.identifier.or.type", new Object[0]));
            if (classParameterList != null) {
                errorElement.rawAddChildren(classParameterList);
            }
            last.rawInsertAfterMe(errorElement);
            return first;
        }
        last.rawInsertAfterMe(type);
        last = type;
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            if (context == Context.CODE_BLOCK_CONTEXT && modifierList.getFirstChildNode() == null) {
                lexer.restore(startPos);
                return null;
            }
            if (classParameterList != null) {
                CompositeElement errorElement1 = Factory.createErrorElement(JavaErrorMessages.message("unexpected.token", new Object[0]));
                errorElement1.rawAddChildren(classParameterList);
                last.rawInsertBeforeMe(errorElement1);
            }
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0]));
            last.rawInsertAfterMe(errorElement);
            return first;
        }
        TreeElement identifier = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        lexer.advance();
        last.rawInsertAfterMe(identifier);
        if (lexer.getTokenType() == JavaTokenType.LPARENTH) {
            if (context == Context.CLASS_CONTEXT) {
                CompositeElement method = ASTFactory.composite(JavaElementType.METHOD);
                if (classParameterList == null) {
                    classParameterList = ASTFactory.composite(JavaElementType.TYPE_PARAMETER_LIST);
                }
                first.rawInsertAfterMe(classParameterList);
                method.rawAddChildren(first);
                this.parseMethodFromLparenth(lexer, method, false);
                return method;
            }
            if (context == Context.ANNOTATION_INTERFACE_CONTEXT) {
                CompositeElement method = ASTFactory.composite(JavaElementType.ANNOTATION_METHOD);
                if (classParameterList == null) {
                    classParameterList = ASTFactory.composite(JavaElementType.TYPE_PARAMETER_LIST);
                }
                first.rawInsertAfterMe(classParameterList);
                method.rawAddChildren(first);
                this.parseMethodFromLparenth(lexer, method, true);
                return method;
            }
            return this.parseFieldOrLocalVariable(classParameterList, first, context, lexer, startPos);
        }
        return this.parseFieldOrLocalVariable(classParameterList, first, context, lexer, startPos);
    }

    private TreeElement parseFieldOrLocalVariable(TreeElement classParameterList, TreeElement first, Context context, Lexer lexer, LexerPosition startPos) {
        boolean shouldRollback;
        CompositeElement variable;
        if (classParameterList != null) {
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("unexpected.token", new Object[0]));
            errorElement.rawAddChildren(classParameterList);
            first.rawInsertAfterMe(errorElement);
        }
        if (context == Context.CLASS_CONTEXT || context == Context.ANNOTATION_INTERFACE_CONTEXT) {
            variable = ASTFactory.composite(JavaElementType.FIELD);
            variable.rawAddChildren(first);
        } else if (context == Context.CODE_BLOCK_CONTEXT) {
            variable = ASTFactory.composite(JavaElementType.LOCAL_VARIABLE);
            variable.rawAddChildren(first);
        } else {
            LOG.assertTrue(false);
            return null;
        }
        CompositeElement variable1 = variable;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        while (true) {
            shouldRollback = true;
            while (lexer.getTokenType() == JavaTokenType.LBRACKET) {
                variable1.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                if (lexer.getTokenType() != JavaTokenType.RBRACKET) {
                    variable1.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbracket", new Object[0])));
                    unclosed = true;
                    break;
                }
                variable1.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
            }
            if (lexer.getTokenType() == JavaTokenType.EQ) {
                variable1.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
                if (expr != null) {
                    shouldRollback = false;
                    variable1.rawAddChildren(expr);
                } else {
                    variable1.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                    unclosed = true;
                    break;
                }
            }
            if (lexer.getTokenType() != JavaTokenType.COMMA) break;
            TreeElement comma = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            variable1.rawInsertAfterMe(comma);
            if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
                comma.rawInsertAfterMe(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
                unclosed = true;
                eatSemicolon = false;
                break;
            }
            CompositeElement variable2 = ASTFactory.composite(variable1.getElementType());
            comma.rawInsertAfterMe(variable2);
            variable2.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            variable1 = variable2;
        }
        if (lexer.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            variable1.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else {
            if (lexer.getTokenType() != null && shouldRollback) {
                int spaceStart = lexer instanceof StoppableLexerAdapter ? ((StoppableLexerAdapter)lexer).getPrevTokenEnd() : ((FilterLexer)lexer).getPrevTokenEnd();
                int spaceEnd = lexer.getTokenStart();
                CharSequence buffer = lexer.getBufferSequence();
                int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)buffer, (int)spaceEnd, (String)"\n\r");
                if (startPos.getOffset() < lineStart && lineStart < spaceStart) {
                    final int newBufferEnd = CharArrayUtil.shiftForward((CharSequence)buffer, (int)lineStart, (String)"\n\r \t");
                    lexer.restore(startPos);
                    StoppableLexerAdapter stoppableLexer = new StoppableLexerAdapter(new StoppableLexerAdapter.StoppingCondition(){

                        public boolean stopsAt(IElementType token, int start, int end) {
                            return start >= newBufferEnd || end > newBufferEnd;
                        }
                    }, lexer);
                    return this.parseDeclaration((Lexer)stoppableLexer, context);
                }
            }
            if (!unclosed) {
                variable1.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.semicolon", new Object[0])));
            }
        }
        return variable;
    }

    public CompositeElement parseAnnotationList(Lexer lexer, CompositeElement list) {
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null && tokenType == JavaTokenType.AT) {
            LexerPosition pos = lexer.getCurrentPosition();
            lexer.advance();
            IElementType nextTokenType = lexer.getTokenType();
            lexer.restore(pos);
            if (nextTokenType != null && ElementType.KEYWORD_BIT_SET.contains(nextTokenType)) break;
            CompositeElement annotation = this.parseAnnotation(lexer);
            list.rawAddChildren(annotation);
        }
        return list;
    }

    @NotNull
    public CompositeElement parseModifierList(Lexer lexer) {
        IElementType tokenType;
        CompositeElement modifierList = ASTFactory.composite(JavaElementType.MODIFIER_LIST);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (ElementType.MODIFIER_BIT_SET.contains(tokenType)) {
                modifierList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                continue;
            }
            if (tokenType != JavaTokenType.AT) break;
            LexerPosition pos = lexer.getCurrentPosition();
            lexer.advance();
            IElementType nextTokenType = lexer.getTokenType();
            lexer.restore(pos);
            if (nextTokenType != null && ElementType.KEYWORD_BIT_SET.contains(nextTokenType)) break;
            CompositeElement annotation = this.parseAnnotation(lexer);
            modifierList.rawAddChildren(annotation);
        }
        CompositeElement compositeElement = modifierList;
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/parsing/DeclarationParsing.parseModifierList must not return null");
        }
        return compositeElement;
    }

    @Nullable
    public CompositeElement parseAnnotationFromText(PsiManager manager, String text, LanguageLevel languageLevel) {
        JavaLexer originalLexer = new JavaLexer(languageLevel);
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start((CharSequence)text);
        CompositeElement first = this.parseAnnotation((Lexer)lexer);
        if (lexer.getTokenType() != null) {
            return null;
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        dummyRoot.rawAddChildren(first);
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, 0, text.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return first;
    }

    @NotNull
    public CompositeElement parseAnnotationParamsFromText(PsiManager manager, CharSequence text, LanguageLevel languageLevel) {
        JavaLexer originalLexer = new JavaLexer(languageLevel);
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(text);
        CompositeElement first = this.parseAnnotationParameterList((Lexer)lexer);
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        dummyRoot.rawAddChildren(first);
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, 0, text.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        CompositeElement compositeElement = first;
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/parsing/DeclarationParsing.parseAnnotationParamsFromText must not return null");
        }
        return compositeElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    CompositeElement parseAnnotation(Lexer lexer) {
        CompositeElement compositeElement;
        CompositeElement annotation = ASTFactory.composite(JavaElementType.ANNOTATION);
        if (lexer.getTokenType() == null) {
            compositeElement = annotation;
            if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/parsing/DeclarationParsing.parseAnnotation must not return null");
            return compositeElement;
        }
        annotation.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement classReference = this.parseJavaCodeReference(lexer, true, false, false);
        if (classReference != null) {
            annotation.rawAddChildren(classReference);
        } else {
            annotation.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.class.reference", new Object[0])));
        }
        annotation.rawAddChildren(this.parseAnnotationParameterList(lexer));
        compositeElement = annotation;
        if (compositeElement != null) return compositeElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/parsing/DeclarationParsing.parseAnnotation must not return null");
    }

    private CompositeElement parseAnnotationParameterList(Lexer lexer) {
        CompositeElement parameterList = ASTFactory.composite(JavaElementType.ANNOTATION_PARAMETER_LIST);
        if (lexer.getTokenType() == JavaTokenType.LPARENTH) {
            parameterList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == JavaTokenType.RPARENTH) {
                parameterList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                return parameterList;
            }
            CompositeElement firstParam = this.parseAnnotationParameter(lexer, true);
            parameterList.rawAddChildren(firstParam);
            boolean isFirstParamNamed = firstParam.getChildRole(firstParam.getFirstChildNode()) == 9;
            boolean afterBad = false;
            while (true) {
                if ((tokenType = lexer.getTokenType()) == null) {
                    parameterList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.parameter", new Object[0])));
                    return parameterList;
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    parameterList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    return parameterList;
                }
                if (tokenType == JavaTokenType.COMMA) {
                    TreeElement comma = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
                    lexer.advance();
                    CompositeElement param = this.parseAnnotationParameter(lexer, false);
                    if (!isFirstParamNamed && param != null && param.getChildRole(param.getFirstChildNode()) == 9) {
                        parameterList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("annotation.name.is.missing", new Object[0])));
                    }
                    parameterList.rawAddChildren(comma);
                    parameterList.rawAddChildren(param);
                    continue;
                }
                if (!afterBad) {
                    parameterList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.comma.or.rparen", new Object[0])));
                    parameterList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    afterBad = true;
                    continue;
                }
                afterBad = false;
                parameterList.rawAddChildren(this.parseAnnotationParameter(lexer, false));
            }
        }
        return parameterList;
    }

    private CompositeElement parseAnnotationParameter(Lexer lexer, boolean mayBeSimple) {
        CompositeElement pair = ASTFactory.composite(JavaElementType.NAME_VALUE_PAIR);
        if (mayBeSimple) {
            LexerPosition pos = lexer.getCurrentPosition();
            TreeElement value = this.parseAnnotationMemberValue(lexer);
            if (value != null && lexer.getTokenType() != JavaTokenType.EQ) {
                pair.rawAddChildren(value);
                return pair;
            }
            lexer.restore(pos);
        }
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            pair.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
        } else {
            pair.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        if (lexer.getTokenType() != JavaTokenType.EQ) {
            pair.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.eq", new Object[0])));
        } else {
            pair.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        pair.rawAddChildren(this.parseAnnotationMemberValue(lexer));
        return pair;
    }

    public TreeElement parseAnnotationMemberValue(PsiManager manager, CharSequence text) {
        JavaLexer originalLexer = new JavaLexer(this.myContext.getLanguageLevel());
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(text);
        TreeElement result = this.parseAnnotationMemberValue((Lexer)lexer);
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        dummyRoot.rawAddChildren(result);
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, 0, text.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return result;
    }

    private TreeElement parseAnnotationMemberValue(Lexer lexer) {
        TreeElement result = lexer.getTokenType() == JavaTokenType.AT ? this.parseAnnotation(lexer) : (lexer.getTokenType() == JavaTokenType.LBRACE ? (TreeElement)this.parseArrayMemberValue(lexer) : this.myContext.getExpressionParsing().parseConditionalExpression(lexer));
        if (result == null) {
            result = Factory.createErrorElement(JavaErrorMessages.message("expected.value", new Object[0]));
        }
        return result;
    }

    private ASTNode parseArrayMemberValue(Lexer lexer) {
        CompositeElement memberList;
        block3: {
            LOG.assertTrue(lexer.getTokenType() == JavaTokenType.LBRACE);
            memberList = ASTFactory.composite(JavaElementType.ANNOTATION_ARRAY_INITIALIZER);
            memberList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == JavaTokenType.RBRACE) {
                memberList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                return memberList;
            }
            memberList.rawAddChildren(this.parseAnnotationMemberValue(lexer));
            do {
                if ((tokenType = lexer.getTokenType()) == JavaTokenType.RBRACE) {
                    memberList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    return memberList;
                }
                if (tokenType != JavaTokenType.COMMA) break block3;
                memberList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                memberList.rawAddChildren(this.parseAnnotationMemberValue(lexer));
            } while (lexer.getTokenType() != JavaTokenType.RBRACE);
            memberList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            return memberList;
        }
        memberList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbrace", new Object[0])));
        memberList.putUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY, "");
        return memberList;
    }

    private CompositeElement parseClassFromKeyword(Lexer lexer, TreeElement modifierList, TreeElement atToken) {
        CompositeElement aClass = ASTFactory.composite(JavaElementType.CLASS);
        aClass.rawAddChildren(modifierList);
        if (atToken != null) {
            aClass.rawAddChildren(atToken);
        }
        IElementType keywordTokenType = lexer.getTokenType();
        LOG.assertTrue(ElementType.CLASS_KEYWORD_BIT_SET.contains(keywordTokenType));
        boolean isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        aClass.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0]));
            aClass.rawAddChildren(errorElement);
            return (CompositeElement)aClass.getFirstChildNode();
        }
        aClass.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        TreeElement classParameterList = this.parseTypeParameterList(lexer);
        aClass.rawAddChildren(classParameterList);
        TreeElement extendsList = this.parseExtendsList(lexer);
        if (extendsList == null) {
            extendsList = ASTFactory.composite(JavaElementType.EXTENDS_LIST);
        }
        aClass.rawAddChildren(extendsList);
        TreeElement implementsList = this.parseImplementsList(lexer);
        if (implementsList == null) {
            implementsList = ASTFactory.composite(JavaElementType.IMPLEMENTS_LIST);
        }
        aClass.rawAddChildren(implementsList);
        if (lexer.getTokenType() != JavaTokenType.LBRACE) {
            IElementType tokenType;
            CompositeElement invalidElementsGroup = Factory.createErrorElement(JavaErrorMessages.message("expected.lbrace", new Object[0]));
            aClass.rawAddChildren(invalidElementsGroup);
            while ((tokenType = lexer.getTokenType()) == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.COMMA || tokenType == JavaTokenType.EXTENDS_KEYWORD || tokenType == JavaTokenType.IMPLEMENTS_KEYWORD) {
                invalidElementsGroup.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
            }
        }
        this.parseClassBodyWithBraces(aClass, lexer, atToken != null, isEnum);
        return aClass;
    }

    private TreeElement parseTypeParameterList(Lexer lexer) {
        CompositeElement result = ASTFactory.composite(JavaElementType.TYPE_PARAMETER_LIST);
        if (lexer.getTokenType() != JavaTokenType.LT) {
            return result;
        }
        result.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        while (true) {
            CompositeElement typeParameter;
            if ((typeParameter = this.parseTypeParameter(lexer)) == null) {
                typeParameter = Factory.createErrorElement(JavaErrorMessages.message("expected.type.parameter", new Object[0]));
            }
            result.rawAddChildren(typeParameter);
            if (lexer.getTokenType() != JavaTokenType.COMMA) break;
            result.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        if (lexer.getTokenType() == JavaTokenType.GT) {
            result.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            LexerPosition position = lexer.getCurrentPosition();
            lexer.advance();
            IElementType lookahead = lexer.getTokenType();
            lexer.restore(position);
            if (lookahead == JavaTokenType.GT) {
                CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("unexpected.identifier", new Object[0]));
                errorElement.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                result.rawAddChildren(errorElement);
                lexer.advance();
                result.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
            } else {
                result.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.gt", new Object[0])));
            }
        } else {
            result.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.gt", new Object[0])));
        }
        return result;
    }

    @Nullable
    public TreeElement parseTypeParameterText(CharSequence buffer) {
        JavaLexer originalLexer = new JavaLexer(this.myContext.getLanguageLevel());
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer);
        CompositeElement typeParameter = this.parseTypeParameter((Lexer)lexer);
        if (typeParameter == null) {
            return null;
        }
        if (lexer.getTokenType() != null) {
            return null;
        }
        ParseUtil.insertMissingTokens(typeParameter, (Lexer)originalLexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return typeParameter;
    }

    @Nullable
    private CompositeElement parseTypeParameter(Lexer lexer) {
        CompositeElement result = ASTFactory.composite(JavaElementType.TYPE_PARAMETER);
        LexerPosition beforeAnno = lexer.getCurrentPosition();
        this.parseAnnotationListTo(lexer, result);
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            lexer.restore(beforeAnno);
            return null;
        }
        result.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement extendsBound = this.parseReferenceList(lexer, JavaElementType.EXTENDS_BOUND_LIST, JavaTokenType.AND, JavaTokenType.EXTENDS_KEYWORD);
        if (extendsBound == null) {
            extendsBound = ASTFactory.composite(JavaElementType.EXTENDS_BOUND_LIST);
        }
        result.rawAddChildren(extendsBound);
        return result;
    }

    @Nullable
    protected ASTNode parseClassBodyWithBraces(CompositeElement root, Lexer lexer, boolean annotationInterface, boolean isEnum) {
        if (lexer.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        LeafElement lbrace = (LeafElement)ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        root.rawAddChildren(lbrace);
        lexer.advance();
        StoppableLexerAdapter classLexer = new StoppableLexerAdapter(new StoppableLexerAdapter.StoppingCondition(){
            private int braceCount = 1;

            public boolean stopsAt(IElementType token, int start, int end) {
                if (token == JavaTokenType.LBRACE) {
                    ++this.braceCount;
                } else if (token == JavaTokenType.RBRACE) {
                    --this.braceCount;
                }
                return this.braceCount == 0;
            }
        }, lexer);
        int context = annotationInterface ? 1 : (isEnum ? 2 : 0);
        this.myContext.getClassBodyParsing().parseClassBody(root, (Lexer)classLexer, context);
        this.expectRBrace(root, lexer);
        return lbrace;
    }

    private void expectRBrace(CompositeElement root, Lexer lexer) {
        if (lexer.getTokenType() == JavaTokenType.RBRACE) {
            root.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else {
            root.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbrace", new Object[0])));
        }
    }

    @Nullable
    public TreeElement parseEnumConstant(Lexer lexer) {
        LexerPosition pos = lexer.getCurrentPosition();
        CompositeElement modifierList = this.parseModifierList(lexer);
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            CompositeElement element = ASTFactory.composite(JavaElementType.ENUM_CONSTANT);
            element.rawAddChildren(modifierList);
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            CompositeElement argumentList = this.myContext.getExpressionParsing().parseArgumentList(lexer);
            element.rawAddChildren(argumentList);
            if (lexer.getTokenType() == JavaTokenType.LBRACE) {
                CompositeElement classElement = ASTFactory.composite(JavaElementType.ENUM_CONSTANT_INITIALIZER);
                element.rawAddChildren(classElement);
                this.parseClassBodyWithBraces(classElement, lexer, false, false);
            }
            return element;
        }
        lexer.restore(pos);
        return null;
    }

    private void parseMethodFromLparenth(Lexer lexer, CompositeElement method, boolean annotationMethod) {
        IElementType tokenType;
        TreeElement throwsList;
        CompositeElement parmList = this.parseParameterList(lexer);
        method.rawAddChildren(parmList);
        while (lexer.getTokenType() == JavaTokenType.LBRACKET) {
            method.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            if (lexer.getTokenType() != JavaTokenType.RBRACKET) {
                method.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbracket", new Object[0])));
                break;
            }
            method.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        if (this.myContext.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_7)) {
            CompositeElement receiver = ASTFactory.composite(JavaElementType.METHOD_RECEIVER);
            this.parseAnnotationList(lexer, receiver);
            if (receiver.getFirstChildNode() != null) {
                method.rawAddChildren(receiver);
            }
        }
        if ((throwsList = this.parseThrowsList(lexer)) == null) {
            throwsList = ASTFactory.composite(JavaElementType.THROWS_LIST);
        }
        method.rawAddChildren(throwsList);
        if (annotationMethod && lexer.getTokenType() == JavaTokenType.DEFAULT_KEYWORD) {
            method.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            method.rawAddChildren(this.parseAnnotationMemberValue(lexer));
        }
        if ((tokenType = lexer.getTokenType()) != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            CompositeElement invalidElementsGroup = Factory.createErrorElement(JavaErrorMessages.message("expected.lbrace.or.semicolon", new Object[0]));
            method.rawAddChildren(invalidElementsGroup);
            block1: while (true) {
                tokenType = lexer.getTokenType();
                CharSequence buf = lexer.getBufferSequence();
                int start = lexer.getTokenStart();
                for (int i = start - 1; i >= 0; --i) {
                    if (buf.charAt(i) == '\n') break block1;
                    if (buf.charAt(i) != ' ' && buf.charAt(i) != '\t') break;
                }
                if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.COMMA && tokenType != JavaTokenType.THROWS_KEYWORD) break;
                invalidElementsGroup.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
            }
        }
        if (lexer.getTokenType() == JavaTokenType.SEMICOLON) {
            method.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else if (lexer.getTokenType() == JavaTokenType.LBRACE) {
            TreeElement codeBlock = this.myContext.getStatementParsing().parseCodeBlock(lexer, false);
            method.rawAddChildren(codeBlock);
        }
    }

    private CompositeElement parseParameterList(Lexer lexer) {
        CompositeElement paramList = ASTFactory.composite(JavaElementType.PARAMETER_LIST);
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.LPARENTH);
        paramList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement invalidElementsGroup = null;
        boolean commaExpected = false;
        int paramCount = 0;
        while (true) {
            CompositeElement ref;
            IElementType tokenType;
            if ((tokenType = lexer.getTokenType()) == null || tokenType == JavaTokenType.RPARENTH) {
                boolean noLastParm;
                boolean bl = noLastParm = !commaExpected && paramCount > 0;
                if (noLastParm) {
                    paramList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier.or.type", new Object[0])));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    paramList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    break;
                }
                if (noLastParm) break;
                paramList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rparen", new Object[0])));
                break;
            }
            if (commaExpected) {
                if (tokenType == JavaTokenType.COMMA) {
                    paramList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    commaExpected = false;
                    invalidElementsGroup = null;
                    continue;
                }
            } else {
                TreeElement param = this.parseParameter(lexer, true);
                if (param != null) {
                    paramList.rawAddChildren(param);
                    commaExpected = true;
                    invalidElementsGroup = null;
                    ++paramCount;
                    continue;
                }
            }
            if (invalidElementsGroup == null) {
                if (tokenType == JavaTokenType.COMMA) {
                    paramList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.parameter", new Object[0])));
                    paramList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    continue;
                }
                invalidElementsGroup = Factory.createErrorElement(commaExpected ? JavaErrorMessages.message("expected.comma", new Object[0]) : JavaErrorMessages.message("expected.parameter", new Object[0]));
                paramList.rawAddChildren(invalidElementsGroup);
            }
            if ((ref = this.parseJavaCodeReference(lexer, true, true, false)) != null) {
                invalidElementsGroup.rawAddChildren(ref);
                continue;
            }
            if (lexer.getTokenType() == null) continue;
            invalidElementsGroup.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        return paramList;
    }

    @Nullable
    private TreeElement parseExtendsList(Lexer lexer) {
        return this.parseReferenceList(lexer, JavaElementType.EXTENDS_LIST, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD);
    }

    @Nullable
    private TreeElement parseImplementsList(Lexer lexer) {
        return this.parseReferenceList(lexer, JavaElementType.IMPLEMENTS_LIST, JavaTokenType.COMMA, JavaTokenType.IMPLEMENTS_KEYWORD);
    }

    @Nullable
    private TreeElement parseThrowsList(Lexer lexer) {
        return this.parseReferenceList(lexer, JavaElementType.THROWS_LIST, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD);
    }

    @Nullable
    private CompositeElement parseReferenceList(@NotNull Lexer lexer, @NotNull IElementType elementType, @NotNull IElementType referenceDelimiter, @NotNull IElementType keyword) {
        if (lexer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/parsing/DeclarationParsing.parseReferenceList must not be null");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/parsing/DeclarationParsing.parseReferenceList must not be null");
        }
        if (referenceDelimiter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/parsing/DeclarationParsing.parseReferenceList must not be null");
        }
        if (keyword == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/parsing/DeclarationParsing.parseReferenceList must not be null");
        }
        if (lexer.getTokenType() != keyword) {
            return null;
        }
        CompositeElement list = ASTFactory.composite(elementType);
        list.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        while (true) {
            CompositeElement classReference;
            if ((classReference = this.parseJavaCodeReference(lexer, true, true, true)) == null) {
                classReference = Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            list.rawAddChildren(classReference);
            if (lexer.getTokenType() != referenceDelimiter) break;
            TreeElement delimiter = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            list.rawAddChildren(delimiter);
        }
        return list;
    }

    @Nullable
    public CompositeElement parseParameterText(CharSequence buffer) {
        JavaLexer originalLexer = new JavaLexer(this.myContext.getLanguageLevel());
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer);
        TreeElement first = this.parseParameter((Lexer)lexer, true);
        if (first == null || first.getElementType() != JavaElementType.PARAMETER) {
            return null;
        }
        if (lexer.getTokenType() != null) {
            return null;
        }
        ParseUtil.insertMissingTokens((CompositeElement)first, (Lexer)originalLexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return (CompositeElement)first;
    }

    @Nullable
    public TreeElement parseParameter(Lexer lexer, boolean allowEllipsis) {
        CompositeElement type;
        LexerPosition pos = lexer.getCurrentPosition();
        CompositeElement modifierList = this.parseModifierList(lexer);
        CompositeElement compositeElement = type = allowEllipsis ? this.parseTypeWithEllipsis(lexer) : this.parseType(lexer);
        if (type == null && modifierList.getFirstChildNode() == null) {
            lexer.restore(pos);
            return null;
        }
        CompositeElement param = ASTFactory.composite(JavaElementType.PARAMETER);
        param.rawAddChildren(modifierList);
        if (type == null) {
            type = ASTFactory.composite(JavaElementType.TYPE);
            param.rawAddChildren(Factory.createErrorElement("Parameter type missing"));
        }
        param.rawAddChildren(type);
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            param.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            while (lexer.getTokenType() == JavaTokenType.LBRACKET) {
                param.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                if (lexer.getTokenType() != JavaTokenType.RBRACKET) {
                    param.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbracket", new Object[0])));
                    break;
                }
                param.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
            }
            return param;
        }
        param.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
        return param.getFirstChildNode();
    }

    public static enum Context {
        FILE_CONTEXT,
        CLASS_CONTEXT,
        CODE_BLOCK_CONTEXT,
        ANNOTATION_INTERFACE_CONTEXT;

    }
}

