/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFileElement
extends FileElement
implements Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.JavaFileElement");

    public JavaFileElement(CharSequence text) {
        super((IElementType)JAVA_FILE, text);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (before == null && first == last && first.getElementType() == ElementType.PACKAGE_STATEMENT) {
            anchor = this.getFirstChildNode();
            before = Boolean.TRUE;
        }
        return super.addInternal(first, last, anchor, before);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiJavaFile file;
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/JavaFileElement.deleteChildInternal must not be null");
        }
        if (child.getElementType() == CLASS && (file = (PsiJavaFile)SourceTreeToPsiMap.treeElementToPsi(this)).getClasses().length == 1) {
            file.delete();
            return;
        }
        super.deleteChildInternal(child);
    }

    @Override
    @Nullable
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 1: {
                return this.findChildByType(PACKAGE_STATEMENT);
            }
            case 2: 
        }
        return this.findChildByType(IMPORT_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PACKAGE_STATEMENT) {
            return 1;
        }
        if (i == IMPORT_LIST) {
            return 2;
        }
        if (i == CLASS) {
            return 3;
        }
        return 0;
    }

    @Override
    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/JavaFileElement.replaceChildInternal must not be null");
        }
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/JavaFileElement.replaceChildInternal must not be null");
        }
        if (newElement.getElementType() == ElementType.IMPORT_LIST) {
            ASTNode next;
            LOG.assertTrue(child.getElementType() == ElementType.IMPORT_LIST);
            if (newElement.getFirstChildNode() == null && (next = child.getTreeNext()) != null && next.getElementType() == WHITE_SPACE) {
                this.removeChild(next);
            }
        }
        super.replaceChildInternal(child, newElement);
    }
}

