/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class XmlTagValueImpl
implements XmlTagValue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlTagValueImpl");
    private final XmlTag myTag;
    private final XmlTagChild[] myElements;
    private volatile XmlText[] myTextElements;
    private volatile String myText;
    private volatile String myTrimmedText;

    public XmlTagValueImpl(@NotNull XmlTagChild[] bodyElements, @NotNull XmlTag tag) {
        if (bodyElements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlTagValueImpl.<init> must not be null");
        }
        if (tag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlTagValueImpl.<init> must not be null");
        }
        this.myTextElements = null;
        this.myText = null;
        this.myTrimmedText = null;
        this.myTag = tag;
        this.myElements = bodyElements;
    }

    @NotNull
    public XmlTagChild[] getChildren() {
        if (this.myElements == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getChildren must not return null");
        }
        return this.myElements;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XmlText[] getTextElements() {
        XmlText[] xmlTextArray;
        XmlText[] textElements = this.myTextElements;
        if (textElements != null) {
            xmlTextArray = textElements;
            if (textElements == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getTextElements must not return null");
            return xmlTextArray;
        }
        ArrayList<XmlText> textElementsList = new ArrayList<XmlText>();
        for (XmlTagChild element : this.myElements) {
            if (!(element instanceof XmlText)) continue;
            textElementsList.add((XmlText)element);
        }
        xmlTextArray = this.myTextElements = (XmlText[])ContainerUtil.toArray(textElementsList, (Object[])new XmlText[textElementsList.size()]);
        if (this.myTextElements != null) return xmlTextArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getTextElements must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getText() {
        String string;
        String text = this.myText;
        if (text != null) {
            string = text;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getText must not return null");
            return string;
        }
        StringBuilder consolidatedText = new StringBuilder();
        for (XmlTagChild element : this.myElements) {
            consolidatedText.append(element.getText());
        }
        string = this.myText = consolidatedText.toString();
        if (this.myText != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getText must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange;
        if (this.myElements.length == 0) {
            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild((ASTNode)this.myTag);
            if (!(child != null ? (textRange = new TextRange(child.getStartOffset() + 1, child.getStartOffset() + 1)) != null : (textRange = new TextRange(this.myTag.getTextRange().getEndOffset(), this.myTag.getTextRange().getEndOffset())) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getTextRange must not return null");
            return textRange;
        }
        textRange = new TextRange(this.myElements[0].getTextRange().getStartOffset(), this.myElements[this.myElements.length - 1].getTextRange().getEndOffset());
        if (textRange != null) return textRange;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getTextRange must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getTrimmedText() {
        XmlText[] textElements;
        String string;
        String trimmedText = this.myTrimmedText;
        if (trimmedText != null) {
            string = trimmedText;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getTrimmedText must not return null");
            return string;
        }
        StringBuilder consolidatedText = new StringBuilder();
        for (XmlText textElement : textElements = this.getTextElements()) {
            consolidatedText.append(textElement.getValue());
        }
        string = this.myTrimmedText = consolidatedText.toString().trim();
        if (this.myTrimmedText != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagValueImpl.getTrimmedText must not return null");
    }

    public void setText(String value) {
        try {
            XmlText text = null;
            if (StringUtil.isNotEmpty((String)value)) {
                XmlText[] texts = this.getTextElements();
                text = texts.length == 0 ? (XmlText)this.myTag.add((PsiElement)XmlElementFactory.getInstance((Project)this.myTag.getProject()).createDisplayText("x")) : texts[0];
                text.setValue(value);
            }
            if (this.myElements.length > 0) {
                for (XmlTagChild child : this.myElements) {
                    if (child == text) continue;
                    child.delete();
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

