/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPushDown.PushDownDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPushDownHandler
implements RefactoringActionHandler,
ElementsHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"push.members.down.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/memberPushDown/JavaPushDownHandler.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pushMembersDown");
                return;
            }
            if (element instanceof PsiClass || element instanceof PsiField || element instanceof PsiMethod) {
                if (element instanceof JspClass) {
                    RefactoringMessageUtil.showNotSupportedForJspClassesError(project, editor, REFACTORING_NAME, "refactoring.pushMembersDown");
                    return;
                }
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiClass aClass;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/memberPushDown/JavaPushDownHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/memberPushDown/JavaPushDownHandler.invoke must not be null");
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        PsiElement aMember = null;
        if (element instanceof PsiClass) {
            aClass = (PsiClass)element;
        } else if (element instanceof PsiMethod) {
            aClass = ((PsiMethod)element).getContainingClass();
            aMember = element;
        } else if (element instanceof PsiField) {
            aClass = ((PsiField)element).getContainingClass();
            aMember = element;
        } else {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(aClass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return !(element instanceof PsiEnumConstant);
            }
        });
        List members = memberInfoStorage.getClassMemberInfos(aClass);
        PsiManager manager = aClass.getManager();
        for (MemberInfo member : members) {
            if (!manager.areElementsEquivalent(member.getMember(), aMember)) continue;
            member.setChecked(true);
            break;
        }
        PushDownDialog dialog = new PushDownDialog(project, members.toArray(new MemberInfo[members.size()]), aClass);
        dialog.show();
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }
}

