/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.TestFinderHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GotoTestOrCodeHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.testOrCode";
    }

    @Override
    protected Pair<PsiElement, PsiElement[]> getSourceAndTargetElements(Editor editor, PsiFile file) {
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor, file);
        List<PsiElement> candidates = TestFinderHelper.isTest(selectedElement) ? TestFinderHelper.findClassesForTest(selectedElement) : TestFinderHelper.findTestsForClass(selectedElement);
        PsiElement sourceElement = TestFinderHelper.findSourceElement(selectedElement);
        return new Pair((Object)sourceElement, (Object)candidates.toArray(new PsiElement[candidates.size()]));
    }

    @NotNull
    public static PsiElement getSelectedElement(Editor editor, PsiFile file) {
        PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testIntegration/GotoTestOrCodeHandler.getSelectedElement must not return null");
        }
        return psiElement;
    }

    @Override
    protected boolean shouldSortResult() {
        return false;
    }

    @Override
    protected void handleNoVariansCase(Project project, Editor editor, PsiFile file) {
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor, file);
        if (TestFinderHelper.isTest(selectedElement)) {
            HintManager.getInstance().showErrorHint(editor, ActionsBundle.message((String)"action.GotoTestSubject.nothing.found", (Object[])new Object[0]));
            return;
        }
        TestCreator creator = (TestCreator)LanguageTestCreators.INSTANCE.forLanguage(file.getLanguage());
        if (creator != null) {
            creator.createTest(project, editor, file);
        }
    }

    @Override
    protected String getChooserInFileTitleKey(PsiElement sourceElement) {
        if (TestFinderHelper.isTest(sourceElement)) {
            return "goto.test.subject.in.file.chooser.title";
        }
        return "goto.test.in.file.chooser.title";
    }

    @Override
    protected String getChooserTitleKey(PsiElement sourceElement) {
        if (TestFinderHelper.isTest(sourceElement)) {
            return "goto.test.subject.chooser.title";
        }
        return "goto.test.chooser.title";
    }

    @Override
    protected void navigateToElement(Navigatable element) {
        if (element instanceof PsiElement) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element);
        } else {
            element.navigate(true);
        }
    }
}

