/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolProcessAdapter;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ToolRunProfile
implements ModuleRunProfile {
    private final Tool myTool;
    private final GeneralCommandLine myCommandLine;

    public ToolRunProfile(Tool tool, DataContext context) {
        this.myTool = tool;
        this.myCommandLine = this.myTool.createCommandLine(context);
        if (context instanceof DataManagerImpl.MyDataContext) {
            ((DataManagerImpl.MyDataContext)context).setEventCount(IdeEventQueue.getInstance().getEventCount());
        }
    }

    public String getName() {
        return this.myTool.getName();
    }

    public Icon getIcon() {
        return null;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/tools/ToolRunProfile.getModules must not return null");
        }
        return Module.EMPTY_ARRAY;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/tools/ToolRunProfile.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/tools/ToolRunProfile.getState must not be null");
        }
        final Project project = env.getProject();
        if (project == null || this.myCommandLine == null) {
            return null;
        }
        CommandLineState commandLineState = new CommandLineState(env){

            GeneralCommandLine createCommandLine() {
                return ToolRunProfile.this.myCommandLine;
            }

            protected OSProcessHandler startProcess() throws ExecutionException {
                GeneralCommandLine commandLine = this.createCommandLine();
                OSProcessHandler processHandler = new OSProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString());
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                return processHandler;
            }

            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/tools/ToolRunProfile$1.execute must not be null");
                }
                if (runner == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/tools/ToolRunProfile$1.execute must not be null");
                }
                ExecutionResult result = super.execute(executor, runner);
                ProcessHandler processHandler = result.getProcessHandler();
                if (processHandler != null) {
                    processHandler.addProcessListener((ProcessListener)new ToolProcessAdapter(project, ToolRunProfile.this.myTool.synchronizeAfterExecution(), ToolRunProfile.this.getName()));
                }
                return result;
            }
        };
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        FilterInfo[] outputFilters = this.myTool.getOutputFilters();
        for (int i = 0; i < outputFilters.length; ++i) {
            builder.addFilter((Filter)new RegexpFilter(project, outputFilters[i].getRegExp()));
        }
        commandLineState.setConsoleBuilder(builder);
        return commandLineState;
    }
}

