/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.HeavyweightHint;
import com.intellij.ui.Hint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToolTipHandler<KeyType, ComponentType extends JComponent> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.AbstractToolTipHandler");
    protected final ComponentType myComponent;
    protected final CellRendererPane myRendererPane;
    private final TipComponent myTipComponent;
    private Hint myHint;
    private KeyType myKey;
    protected BufferedImage myImage;

    protected AbstractToolTipHandler(@NotNull ComponentType component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/AbstractToolTipHandler.<init> must not be null");
        }
        this.myRendererPane = new CellRendererPane();
        this.myComponent = component;
        ((Container)this.myComponent).add(this.myRendererPane);
        ((Container)this.myComponent).validate();
        this.myTipComponent = new TipComponent();
        ((Component)this.myComponent).addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractToolTipHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AbstractToolTipHandler.this.hideHint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractToolTipHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractToolTipHandler.this.handleMouseEvent(e);
            }
        });
        ((Component)this.myComponent).addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                AbstractToolTipHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                AbstractToolTipHandler.this.handleMouseEvent(e);
            }
        });
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractToolTipHandler.this.hideHint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractToolTipHandler.this.repaintHint();
            }
        });
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AbstractToolTipHandler.this.hideHint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AbstractToolTipHandler.this.hideHint();
            }
        });
        ((Component)this.myComponent).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                AbstractToolTipHandler.this.hideHint();
            }
        });
    }

    protected abstract KeyType getCellKeyForPoint(Point var1);

    protected final void hideHint() {
        if (this.myHint != null) {
            this.myHint.hide();
            this.myHint = null;
        }
    }

    private void handleMouseEvent(MouseEvent e) {
        KeyType oldKey = this.myKey;
        this.myKey = this.getCellKeyForPoint(e.getPoint());
        if (this.myKey == null || !((Component)this.myComponent).isShowing()) {
            this.hideHint();
            return;
        }
        Point location = this.createToolTipImage(this.myKey);
        if (location == null) {
            this.hideHint();
        } else if (this.myHint == null) {
            this.show(location);
        } else if (!Comparing.equal(oldKey, this.myKey)) {
            this.hideHint();
            this.show(location);
        }
    }

    private void show(Point location) {
        boolean fitIntoLayeredPane;
        LOG.assertTrue(this.myHint == null);
        if (!((Component)this.myComponent).isShowing()) {
            return;
        }
        JLayeredPane layeredPane = ((JComponent)this.myComponent).getRootPane().getLayeredPane();
        Point layeredPanePoint = SwingUtilities.convertPoint(this.myComponent, location.x + this.myTipComponent.getPreferredSize().width, 0, layeredPane);
        boolean bl = fitIntoLayeredPane = layeredPanePoint.x < layeredPane.getWidth();
        if (fitIntoLayeredPane) {
            this.myHint = new LightweightHint(this.myTipComponent);
        } else {
            MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            this.myHint = new HeavyweightHint(this.myTipComponent, false);
        }
        this.myHint.show((JComponent)this.myComponent, location.x, location.y, (JComponent)this.myComponent);
    }

    protected void repaintHint() {
        if (this.myHint != null && this.myKey != null && ((Component)this.myComponent).isShowing()) {
            this.createToolTipImage(this.myKey);
            this.myTipComponent.repaint();
        }
    }

    protected Point createToolTipImage(@NotNull KeyType key) {
        int height;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/AbstractToolTipHandler.createToolTipImage must not be null");
        }
        Component rComponent = this.getRendererComponent(key);
        if (!(rComponent instanceof JComponent)) {
            return null;
        }
        Rectangle cellBounds = this.getCellBounds(key, rComponent);
        if (cellBounds == null) {
            return null;
        }
        Point cellLocation = cellBounds.getLocation();
        Rectangle visibleRect = this.getVisibleRect(key);
        if (visibleRect.contains(cellLocation.x + cellBounds.width, cellLocation.y + (height = cellBounds.height))) {
            return null;
        }
        Point visibleRightTop = new Point(visibleRect.x + visibleRect.width, cellLocation.y);
        int rightLimit = cellLocation.x + cellBounds.width;
        int width = rightLimit - visibleRightTop.x;
        if (width <= 0 || height <= 0) {
            return null;
        }
        this.myImage = new BufferedImage(width, height, 1);
        Graphics2D g = this.myImage.createGraphics();
        g.setClip(null);
        g.setColor(((Component)this.myComponent).getBackground());
        g.fillRect(0, 0, width, height);
        g.translate(-(visibleRect.x + visibleRect.width - cellLocation.x), 0);
        this.myRendererPane.paintComponent(g, rComponent, (Container)this.myComponent, 0, 0, cellBounds.width, height, true);
        g.translate(visibleRect.x + visibleRect.width - cellLocation.x, 0);
        g.setColor(Color.black);
        int rightX = this.myImage.getWidth() - 1;
        UIUtil.drawLine((Graphics)g, (int)0, (int)0, (int)rightX, (int)0);
        UIUtil.drawLine((Graphics)g, (int)rightX, (int)0, (int)rightX, (int)height);
        UIUtil.drawLine((Graphics)g, (int)0, (int)(height - 1), (int)rightX, (int)(height - 1));
        g.dispose();
        ((Container)this.myComponent).remove(rComponent);
        return visibleRightTop;
    }

    protected Rectangle getVisibleRect(KeyType key) {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    protected abstract Rectangle getCellBounds(KeyType var1, Component var2);

    protected abstract Component getRendererComponent(KeyType var1);

    private class TipComponent
    extends JComponent {
        private TipComponent() {
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(AbstractToolTipHandler.this.myImage.getWidth(), AbstractToolTipHandler.this.myImage.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(AbstractToolTipHandler.this.myImage, 0, 0, null);
        }
    }
}

