/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.popup.WizardPopup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SpeedSearchPane
extends JDialog {
    private static final Color SPEEDSEARCH_BACKGROUND = new Color(244, 249, 181);
    private static final Color SPEEDSEARCH_FOREGROUND = Color.black;
    private final WizardPopup myPopup;
    private final JLabel myLabel = new JLabel();
    private final JPanel myPanel = new JPanel();
    private Dimension myLastLabelSize = new Dimension();
    private static final Icon ICON_PROMPT = IconLoader.getIcon((String)"/icons/ide/speedSearchPrompt.png");

    public SpeedSearchPane(WizardPopup popup) throws HeadlessException {
        this.myPopup = popup;
        this.setUndecorated(true);
        this.setFocusableWindowState(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.myPanel, "Center");
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.setOpaque(true);
        this.myPanel.add((Component)this.myLabel, "Center");
        this.myPanel.setBackground(SPEEDSEARCH_BACKGROUND);
        this.myLabel.setIcon(ICON_PROMPT);
        this.myPanel.setBorder(BorderFactory.createLineBorder(SPEEDSEARCH_FOREGROUND));
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
    }

    public void update() {
        if (!this.isShowing()) {
            if (this.myPopup.getSpeedSearch().isHoldingFilter()) {
                this.setVisible(true);
                CaptionPanel title = this.myPopup.getTitle();
                Point titleScreenPoint = title.getLocationOnScreen();
                this.setLocation(new Point(titleScreenPoint.x + title.getSize().width / 4, titleScreenPoint.y - title.getSize().height / 2));
                this.updateTextAndBounds();
            }
        } else if (!this.myPopup.getSpeedSearch().isHoldingFilter()) {
            this.setVisible(false);
        } else {
            this.updateTextAndBounds();
        }
    }

    private void updateTextAndBounds() {
        this.myLabel.setText(this.myPopup.getSpeedSearch().getFilter());
        if (this.myLabel.getPreferredSize().width > this.myLastLabelSize.width) {
            this.pack();
            this.myLastLabelSize = this.myLabel.getPreferredSize();
        }
        this.myPanel.repaint();
    }
}

