/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.CollectionQueryCalledVisitor;
import com.siyeh.ig.bugs.CollectionUpdateCalledVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class MismatchedCollectionQueryUpdateInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfCollection" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection.getID must not return null");
        }
        return "MismatchedQueryAndUpdateOfCollection";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.update.collection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean updated = (Boolean)infos[0];
        if (updated) {
            string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.descriptor.updated.not.queried", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.description.queried.not.updated", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedCollectionQueryUpdateVisitor();
    }

    private static boolean isEmptyCollectionInitializer(PsiExpression initializer) {
        PsiExpression[] expressions;
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        for (PsiExpression arg : expressions = argumentList.getExpressions()) {
            PsiType argType = arg.getType();
            if (argType == null) {
                return false;
            }
            if (CollectionUtils.isCollectionClassOrInterface(argType)) {
                return false;
            }
            if (!(argType instanceof PsiArrayType)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectionQueriedByAssignment(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection.collectionQueriedByAssignment must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection.collectionQueriedByAssignment must not be null");
        }
        CollectionQueriedByAssignmentVisitor visitor = new CollectionQueriedByAssignmentVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.mayBeQueried();
    }

    private static class CollectionQueriedByAssignmentVisitor
    extends JavaRecursiveElementVisitor {
        private boolean mayBeQueried;
        @NotNull
        private final PsiVariable variable;

        CollectionQueriedByAssignmentVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection$CollectionQueriedByAssignmentVisitor.<init> must not be null");
            }
            this.mayBeQueried = false;
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection$CollectionQueriedByAssignmentVisitor.visitElement must not be null");
            }
            if (this.mayBeQueried) {
                return;
            }
            super.visitElement(element);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection$CollectionQueriedByAssignmentVisitor.visitAssignmentExpression must not be null");
            }
            if (this.mayBeQueried) {
                return;
            }
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            if (!VariableAccessUtils.mayEvaluateToVariable(lhs, this.variable)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (MismatchedCollectionQueryUpdateInspection.isEmptyCollectionInitializer(rhs)) {
                return;
            }
            this.mayBeQueried = true;
        }

        public boolean mayBeQueried() {
            return this.mayBeQueried;
        }
    }

    private static class MismatchedCollectionQueryUpdateVisitor
    extends BaseInspectionVisitor {
        private MismatchedCollectionQueryUpdateVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection$MismatchedCollectionQueryUpdateVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (containingClass == null) {
                return;
            }
            PsiType type = field.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return;
            }
            boolean written = MismatchedCollectionQueryUpdateVisitor.collectionContentsAreUpdated((PsiVariable)field, (PsiElement)containingClass);
            boolean read = MismatchedCollectionQueryUpdateVisitor.collectionContentsAreQueried((PsiVariable)field, (PsiElement)containingClass);
            if (read == written) {
                return;
            }
            this.registerFieldError(field, written);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspection$MismatchedCollectionQueryUpdateVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return;
            }
            PsiType type = variable.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return;
            }
            boolean written = MismatchedCollectionQueryUpdateVisitor.collectionContentsAreUpdated((PsiVariable)variable, (PsiElement)codeBlock);
            boolean read = MismatchedCollectionQueryUpdateVisitor.collectionContentsAreQueried((PsiVariable)variable, (PsiElement)codeBlock);
            if (read != written) {
                this.registerVariableError((PsiVariable)variable, written);
            }
        }

        private static boolean collectionContentsAreUpdated(PsiVariable variable, PsiElement context) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            if (MismatchedCollectionQueryUpdateVisitor.collectionUpdateCalled(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedCollectionQueryUpdateInspection.isEmptyCollectionInitializer(initializer)) {
                return true;
            }
            if (initializer instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)initializer).getAnonymousClass()) != null && MismatchedCollectionQueryUpdateVisitor.collectionUpdateCalled(variable, (PsiElement)anonymousClass)) {
                return true;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context)) {
                return true;
            }
            return VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean collectionContentsAreQueried(PsiVariable variable, PsiElement context) {
            if (MismatchedCollectionQueryUpdateVisitor.collectionQueryCalled(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedCollectionQueryUpdateInspection.isEmptyCollectionInitializer(initializer)) {
                return true;
            }
            if (MismatchedCollectionQueryUpdateInspection.collectionQueriedByAssignment(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context)) {
                return true;
            }
            return VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean collectionQueryCalled(PsiVariable variable, PsiElement context) {
            CollectionQueryCalledVisitor visitor = new CollectionQueryCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isQueried();
        }

        private static boolean collectionUpdateCalled(PsiVariable variable, PsiElement context) {
            CollectionUpdateCalledVisitor visitor = new CollectionUpdateCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isUpdated();
        }
    }
}

