/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import javax.swing.JButton;
import org.jetbrains.annotations.Nullable;

public class ListenerNavigateButton
extends JButton
implements ActionListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.designSurface.ListenerNavigateButton");
    private final RadComponent myComponent;

    public ListenerNavigateButton(RadComponent component) {
        this.myComponent = component;
        this.setIcon(IconLoader.getIcon((String)"/com/intellij/uiDesigner/icons/listener.png"));
        this.setOpaque(false);
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ListenerNavigateButton.showNavigatePopup(this.myComponent, false);
    }

    public static void showNavigatePopup(RadComponent component, boolean showIfEmpty) {
        DefaultActionGroup actionGroup = ListenerNavigateButton.prepareActionGroup(component);
        if (actionGroup != null && actionGroup.getChildrenCount() == 0 && showIfEmpty) {
            actionGroup.add((AnAction)new MyNavigateAction(UIDesignerBundle.message("navigate.to.listener.empty", new Object[0]), null));
        }
        if (actionGroup != null && actionGroup.getChildrenCount() > 0) {
            DataContext context = DataManager.getInstance().getDataContext((Component)component.getDelegee());
            JBPopupFactory factory = JBPopupFactory.getInstance();
            ListPopup popup = factory.createActionGroupPopup(UIDesignerBundle.message("navigate.to.listener.title", new Object[0]), (ActionGroup)actionGroup, context, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
            FormEditingUtil.showPopupUnderComponent((JBPopup)popup, component);
        }
    }

    @Nullable
    public static DefaultActionGroup prepareActionGroup(RadComponent component) {
        PsiField boundField;
        PsiClass aClass;
        String classToBind;
        IRootContainer root = FormEditingUtil.getRoot(component);
        String string = classToBind = root == null ? null : root.getClassToBind();
        if (classToBind != null && (aClass = FormEditingUtil.findClassToBind(component.getModule(), classToBind)) != null && (boundField = aClass.findFieldByName(component.getBinding(), false)) != null) {
            return ListenerNavigateButton.buildNavigateActionGroup(component, boundField);
        }
        return null;
    }

    private static DefaultActionGroup buildNavigateActionGroup(RadComponent component, PsiField boundField) {
        EventSetDescriptor[] eventSetDescriptors;
        final DefaultActionGroup actionGroup = new DefaultActionGroup();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(component.getComponentClass());
            eventSetDescriptors = beanInfo.getEventSetDescriptors();
        }
        catch (IntrospectionException e) {
            LOG.error((Throwable)e);
            return null;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)boundField.getContainingFile());
        ReferencesSearch.search((PsiElement)boundField, (SearchScope)scope).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference ref) {
                PsiReferenceExpression refExpr;
                PsiElement element = ref.getElement();
                if (element.getParent() instanceof PsiReferenceExpression && (refExpr = (PsiReferenceExpression)element.getParent()).getParent() instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)refExpr.getParent();
                    PsiElement psiElement = refExpr.resolve();
                    if (psiElement instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)psiElement;
                        for (EventSetDescriptor eventSetDescriptor : eventSetDescriptors) {
                            if (!Comparing.equal((String)eventSetDescriptor.getAddListenerMethod().getName(), (String)method.getName())) continue;
                            String eventName = eventSetDescriptor.getName();
                            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                            if (args.length <= 0) continue;
                            ListenerNavigateButton.addListenerRef(actionGroup, eventName, args[0]);
                        }
                    }
                }
                return true;
            }
        });
        return actionGroup;
    }

    private static void addListenerRef(DefaultActionGroup actionGroup, String eventName, PsiExpression listenerArg) {
        PsiClass listenerClass;
        PsiType type = listenerArg.getType();
        if (type instanceof PsiClassType && (listenerClass = ((PsiClassType)type).resolve()) != null) {
            PsiCodeBlock codeBlock;
            PsiElement[] defs;
            PsiElement psiElement;
            if (!ListenerNavigateButton.isAbstractOrInterface(listenerClass)) {
                actionGroup.add((AnAction)new MyNavigateAction(eventName + ": " + ClassPresentationUtil.getNameForClass((PsiClass)listenerClass, (boolean)false), (PsiElement)listenerClass));
                return;
            }
            if (listenerArg instanceof PsiReferenceExpression && (psiElement = ((PsiReferenceExpression)listenerArg).resolve()) instanceof PsiVariable && (defs = DefUseUtil.getDefs((PsiCodeBlock)(codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)listenerArg, PsiCodeBlock.class)), (PsiVariable)((PsiVariable)psiElement), (PsiElement)listenerArg)).length == 1) {
                PsiAssignmentExpression assignmentExpr;
                PsiElement def = defs[0];
                if (def instanceof PsiVariable) {
                    PsiVariable var = (PsiVariable)def;
                    if (var.getInitializer() != listenerArg) {
                        ListenerNavigateButton.addListenerRef(actionGroup, eventName, var.getInitializer());
                        return;
                    }
                } else if (def.getParent() instanceof PsiAssignmentExpression && def.equals((assignmentExpr = (PsiAssignmentExpression)def.getParent()).getLExpression())) {
                    ListenerNavigateButton.addListenerRef(actionGroup, eventName, assignmentExpr.getRExpression());
                    return;
                }
            }
        }
        actionGroup.add((AnAction)new MyNavigateAction(eventName + ": " + listenerArg.getText(), (PsiElement)listenerArg));
    }

    private static boolean isAbstractOrInterface(PsiClass element) {
        return element.isInterface() || element.hasModifierProperty("abstract");
    }

    private static class MyNavigateAction
    extends AnAction {
        private final PsiElement myElement;

        public MyNavigateAction(String name, PsiElement element) {
            super(name);
            this.myElement = element;
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myElement instanceof Navigatable) {
                ((Navigatable)this.myElement).navigate(true);
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myElement != null && (!(this.myElement instanceof PsiClass) || !ListenerNavigateButton.isAbstractOrInterface((PsiClass)this.myElement)));
        }
    }
}

