/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ControlFlowUtils;
import com.siyeh.ipp.psiutils.EquivalenceChecker;
import com.siyeh.ipp.psiutils.ErrorUtil;

class MergeIfOrPredicate
implements PsiElementPredicate {
    MergeIfOrPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        return MergeIfOrPredicate.isMergableExplicitIf(element) || MergeIfOrPredicate.isMergableImplicitIf(element);
    }

    public static boolean isMergableExplicitIf(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (thenBranch == null) {
            return false;
        }
        if (elseBranch == null) {
            return false;
        }
        if (!(elseBranch instanceof PsiIfStatement)) {
            return false;
        }
        if (ErrorUtil.containsError((PsiElement)ifStatement)) {
            return false;
        }
        PsiIfStatement childIfStatement = (PsiIfStatement)elseBranch;
        PsiStatement childThenBranch = childIfStatement.getThenBranch();
        return EquivalenceChecker.statementsAreEquivalent(thenBranch, childThenBranch);
    }

    private static boolean isMergableImplicitIf(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch == null) {
            return false;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            return false;
        }
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
            return false;
        }
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement childIfStatement = (PsiIfStatement)nextStatement;
        PsiStatement childThenBranch = childIfStatement.getThenBranch();
        return EquivalenceChecker.statementsAreEquivalent(thenBranch, childThenBranch);
    }
}

