/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class FileTemplateGroupDescriptor
extends FileTemplateDescriptor {
    private final String myTitle;
    private final List<FileTemplateDescriptor> myTemplates = new ArrayList<FileTemplateDescriptor>();

    public FileTemplateGroupDescriptor(String title, Icon icon, FileTemplateDescriptor ... children) {
        this(title, icon);
        for (FileTemplateDescriptor child : children) {
            this.addTemplate(child);
        }
    }

    public FileTemplateGroupDescriptor(String title, Icon icon) {
        super(null, icon);
        this.myTitle = title;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public FileTemplateDescriptor[] getTemplates() {
        return this.myTemplates.toArray(new FileTemplateDescriptor[this.myTemplates.size()]);
    }

    @Override
    public String getDisplayName() {
        return this.getTitle();
    }

    public void addTemplate(FileTemplateDescriptor descriptor) {
        this.myTemplates.add(descriptor);
    }

    public void addTemplate(@NonNls String fileName) {
        this.addTemplate(new FileTemplateDescriptor(fileName, FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon()));
    }
}

