/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class DocumentContent
extends DiffContent {
    private final Document myDocument;
    private final VirtualFile myFile;
    private final FileType myOverridenType;
    private Project myProject;

    public DocumentContent(Project project, Document document) {
        this(project, document, null);
    }

    public DocumentContent(Project project, @NotNull Document document, FileType type) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/diff/DocumentContent.<init> must not be null");
        }
        this.myProject = project;
        this.myDocument = document;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
        this.myOverridenType = type;
    }

    public DocumentContent(Document document) {
        this(null, document, null);
    }

    public DocumentContent(Document document, FileType type) {
        this(null, document, type);
    }

    @Override
    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        if (this.myProject == null) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public FileType getContentType() {
        return this.myOverridenType == null ? DiffContentUtil.getContentType(this.getFile()) : this.myOverridenType;
    }

    @Override
    public byte[] getBytes() {
        return this.myDocument.getText().getBytes();
    }
}

