/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.versionBrowser;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.StandardVersionFilterComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.michaelbaranov.microba.calendar.DatePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class DateFilterComponent {
    private JPanel myDatePanel;
    private JCheckBox myUseDateAfterFilter;
    private JCheckBox myUseDateBeforeFilter;
    private DatePicker myDateAfter;
    private DatePicker myDateBefore;
    private JPanel myRootPanel;

    public DateFilterComponent() {
        this.$$$setupUI$$$();
        this.myDatePanel.setBorder(IdeBorderFactory.createTitledHeaderBorder(VcsBundle.message("border.changes.filter.date.filter", new Object[0])));
        this.myDateAfter.setDateFormat(SimpleDateFormat.getDateTimeInstance(3, 2));
        this.myDateBefore.setDateFormat(SimpleDateFormat.getDateTimeInstance(3, 2));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateFilterComponent.this.updateAllEnabled(e);
            }
        };
        this.myUseDateAfterFilter.addActionListener(listener);
        this.myUseDateBeforeFilter.addActionListener(listener);
        this.updateAllEnabled(null);
    }

    private void updateAllEnabled(ActionEvent e) {
        StandardVersionFilterComponent.updatePair(this.myUseDateBeforeFilter, (JComponent)this.myDateBefore, e);
        StandardVersionFilterComponent.updatePair(this.myUseDateAfterFilter, (JComponent)this.myDateAfter, e);
    }

    public JPanel getPanel() {
        return this.myRootPanel;
    }

    public void initValues(ChangeBrowserSettings settings) {
        this.myUseDateBeforeFilter.setSelected(settings.USE_DATE_BEFORE_FILTER);
        this.myUseDateAfterFilter.setSelected(settings.USE_DATE_AFTER_FILTER);
        try {
            this.myDateBefore.setDate(settings.getDateBefore());
            this.myDateAfter.setDate(settings.getDateAfter());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.updateAllEnabled(null);
    }

    public void saveValues(ChangeBrowserSettings settings) {
        settings.USE_DATE_BEFORE_FILTER = this.myUseDateBeforeFilter.isSelected();
        settings.USE_DATE_AFTER_FILTER = this.myUseDateAfterFilter.isSelected();
        settings.setDateBefore(this.myDateBefore.getDate());
        settings.setDateAfter(this.myDateAfter.getDate());
    }

    @Nullable
    public String validateInput() {
        if (this.myUseDateAfterFilter.isSelected() && this.myDateAfter.getDate() == null) {
            return "Date After must be a valid date";
        }
        if (this.myUseDateBeforeFilter.isSelected() && this.myDateBefore.getDate() == null) {
            return "Date Before must be a valid date";
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        DatePicker datePicker;
        DatePicker datePicker2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myDatePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        FormLayout formLayout = new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):grow,left:4dlu:noGrow,fill:d:noGrow,left:6dlu:noGrow,fill:max(d;4px):grow", "center:d:grow");
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[]{3, 7};
        nArrayArray[0] = nArray;
        formLayout.setColumnGroups((int[][])nArrayArray);
        jPanel3.setLayout((LayoutManager)formLayout);
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseDateAfterFilter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.show.changes.after.date"));
        jPanel3.add((Component)jCheckBox2, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myUseDateBeforeFilter = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.show.changes.before.date"));
        jPanel3.add((Component)jCheckBox, new CellConstraints(5, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDateAfter = datePicker2 = new DatePicker();
        jPanel3.add((Component)datePicker2, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDateBefore = datePicker = new DatePicker();
        jPanel3.add((Component)datePicker, new CellConstraints(7, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

