/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyPatternCondition<T, P>
extends PatternCondition<T> {
    private final ElementPattern<? extends P> myPropertyPattern;

    public PropertyPatternCondition(@NonNls String methodName, ElementPattern<? extends P> propertyPattern) {
        super(methodName);
        this.myPropertyPattern = propertyPattern;
    }

    @Nullable
    public abstract P getPropertyValue(@NotNull Object var1);

    @Override
    public final boolean accepts(@NotNull T t, ProcessingContext context) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PropertyPatternCondition.accepts must not be null");
        }
        P value = this.getPropertyValue(t);
        return this.myPropertyPattern.getCondition().accepts(value, context);
    }
}

