/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.xml;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Consumer;
import com.intellij.util.Icons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.XmlAttributeInjection;
import org.intellij.plugins.intelliLang.inject.config.XmlTagInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.XmlAttributePanel;
import org.intellij.plugins.intelliLang.inject.config.ui.XmlTagPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.configurables.XmlAttributeInjectionConfigurable;
import org.intellij.plugins.intelliLang.inject.config.ui.configurables.XmlTagInjectionConfigurable;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    private static boolean isMine(PsiLanguageInjectionHost host) {
        if (host instanceof XmlAttributeValue) {
            PsiElement p = host.getParent();
            if (p instanceof XmlAttribute) {
                String s = ((XmlAttribute)p).getName();
                return !s.equals("xmlns") && !s.startsWith("xmlns:");
            }
        } else if (host instanceof XmlText) {
            XmlTag tag = ((XmlText)host).getParentTag();
            return tag != null;
        }
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        if ("xml" == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjectionSupport.getId must not return null");
        }
        return "xml";
    }

    @Override
    @NotNull
    public Class[] getPatternClasses() {
        Class[] classArray = new Class[]{XmlPatterns.class};
        if (classArray == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjectionSupport.getPatternClasses must not return null");
        }
        return classArray;
    }

    @Override
    public boolean useDefaultInjector(PsiElement host) {
        return false;
    }

    @Override
    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        if (!XmlLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        if (psiElement instanceof XmlAttributeValue) {
            return XmlLanguageInjectionSupport.doInjectInAttributeValue((XmlAttributeValue)psiElement, language.getID());
        }
        if (psiElement instanceof XmlText) {
            return XmlLanguageInjectionSupport.doInjectInXmlText((XmlText)psiElement, language.getID());
        }
        return false;
    }

    @Override
    public boolean removeInjectionInPlace(PsiLanguageInjectionHost host) {
        if (!XmlLanguageInjectionSupport.isMine(host)) {
            return false;
        }
        Configuration configuration = Configuration.getInstance();
        ArrayList<BaseInjection> injections = XmlLanguageInjectionSupport.collectInjections(host, configuration);
        if (injections.isEmpty()) {
            return false;
        }
        ArrayList newInjections = new ArrayList();
        for (BaseInjection injection : injections) {
            BaseInjection newInjection = injection.copy();
            newInjection.setPlaceEnabled(null, false);
        }
        Configuration.getInstance().replaceInjectionsWithUndo(host.getProject(), newInjections, injections, Collections.emptyList());
        return true;
    }

    @Override
    public boolean editInjectionInPlace(PsiLanguageInjectionHost host) {
        if (!XmlLanguageInjectionSupport.isMine(host)) {
            return false;
        }
        Configuration configuration = Configuration.getInstance();
        ArrayList<BaseInjection> injections = XmlLanguageInjectionSupport.collectInjections(host, configuration);
        if (injections.isEmpty()) {
            return false;
        }
        Project project = host.getProject();
        BaseInjection originalInjection = injections.get(0);
        BaseInjection xmlInjection = XmlLanguageInjectionSupport.createFrom(originalInjection, host);
        if (xmlInjection == null) {
            return false;
        }
        AbstractTagInjection newInjection = this.showInjectionUI(project, xmlInjection);
        if (newInjection != null) {
            newInjection.mergeOriginalPlacesFrom(originalInjection, true);
            Configuration.getInstance().replaceInjectionsWithUndo(project, Collections.singletonList(xmlInjection), Collections.singletonList(originalInjection), Collections.emptyList());
        }
        return true;
    }

    @Nullable
    private AbstractTagInjection showInjectionUI(Project project, BaseInjection xmlInjection) {
        AbstractInjectionPanel panel;
        final DialogBuilder builder = new DialogBuilder(project);
        if (xmlInjection instanceof XmlTagInjection) {
            panel = new XmlTagPanel((XmlTagInjection)xmlInjection, project);
            builder.setHelpId("reference.settings.injection.language.injection.settings.xml.tag");
        } else if (xmlInjection instanceof XmlAttributeInjection) {
            panel = new XmlAttributePanel((XmlAttributeInjection)xmlInjection, project);
            builder.setHelpId("reference.settings.injection.language.injection.settings.xml.attribute");
        } else {
            throw new AssertionError();
        }
        panel.reset();
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle("Language Injection Settings");
        builder.setOkOperation(new Runnable(){

            @Override
            public void run() {
                panel.apply();
                builder.getDialogWrapper().close(0);
            }
        });
        if (builder.show() == 0) {
            xmlInjection.initializePlaces(false);
            return new AbstractTagInjection().copyFrom(xmlInjection);
        }
        return null;
    }

    @Nullable
    private static BaseInjection createFrom(BaseInjection injection, PsiLanguageInjectionHost host) {
        AbstractTagInjection result;
        XmlTag element;
        if (host instanceof XmlText) {
            XmlTag xmlTag = ((XmlText)host).getParentTag();
            if (xmlTag == null) {
                return null;
            }
            element = xmlTag;
            result = new XmlTagInjection().copyFrom(injection);
        } else if (host instanceof XmlAttributeValue) {
            PsiElement parent = host.getParent();
            if (!(parent instanceof XmlAttribute)) {
                return null;
            }
            element = parent;
            result = new XmlAttributeInjection().copyFrom(injection);
        } else {
            result = null;
            element = null;
        }
        Pattern pattern = Pattern.compile("withLocalName[^\"]*\"([^\"]*)\"\\)+(?:\\.withNamespace[^\"]*\"([^\"]*)\")?");
        for (InjectionPlace place : injection.getInjectionPlaces()) {
            Matcher matcher;
            if (element != null && (place.getElementPattern() == null || !place.getElementPattern().accepts((Object)element)) || !(matcher = pattern.matcher(place.getText())).find()) continue;
            Pair pair1 = Pair.create((Object)matcher.group(1), (Object)matcher.group(2));
            Pair pair2 = matcher.find(Math.max(matcher.end(1), matcher.end(2))) ? Pair.create((Object)matcher.group(1), (Object)matcher.group(2)) : null;
            if (result == null) {
                if (place.getText().startsWith("xmlTag")) {
                    result = new XmlTagInjection().copyFrom(injection);
                } else {
                    if (!place.getText().startsWith("xmlAttribute")) continue;
                    result = new XmlAttributeInjection().copyFrom(injection);
                }
            }
            if (result instanceof XmlAttributeInjection) {
                ((XmlAttributeInjection)result).setAttributeName((String)pair1.first);
                ((XmlAttributeInjection)result).setAttributeNamespace(StringUtil.notNullize((String)((String)pair1.second)));
                if (pair2 == null) break;
                result.setTagName((String)pair2.first);
                result.setTagNamespace(StringUtil.notNullize((String)((String)pair2.second)));
                break;
            }
            if (!(result instanceof XmlTagInjection)) continue;
            result.setTagName((String)pair1.first);
            result.setTagNamespace(StringUtil.notNullize((String)((String)pair1.second)));
            break;
        }
        if (result != null) {
            result.getInjectionPlaces().clear();
        }
        return result;
    }

    @Override
    public BaseInjection createInjection(Element element) {
        if (element.getName().equals(XmlAttributeInjection.class.getSimpleName())) {
            return new XmlAttributeInjection();
        }
        if (element.getName().equals(XmlTagInjection.class.getSimpleName())) {
            return new XmlTagInjection();
        }
        return new AbstractTagInjection();
    }

    @Override
    public Configurable[] createSettings(Project project, Configuration configuration) {
        return new Configurable[0];
    }

    private static boolean doInjectInXmlText(XmlText host, String languageId) {
        XmlTag tag = host.getParentTag();
        if (tag != null) {
            XmlTagInjection injection = new XmlTagInjection();
            injection.setInjectedLanguageId(languageId);
            injection.setTagName(tag.getLocalName());
            injection.setTagNamespace(tag.getNamespace());
            XmlLanguageInjectionSupport.doEditInjection(host.getProject(), injection);
            return true;
        }
        return false;
    }

    private static void doEditInjection(Project project, XmlTagInjection template) {
        XmlTagInjection newInjection;
        AbstractTagInjection originalInjection = (AbstractTagInjection)Configuration.getInstance().findExistingInjection(template);
        XmlTagInjection xmlTagInjection = newInjection = originalInjection == null ? template : new XmlTagInjection().copyFrom(originalInjection);
        if (InjectLanguageAction.doEditConfigurable(project, (Configurable)new XmlTagInjectionConfigurable(newInjection, null, project))) {
            Configuration.getInstance().replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), ContainerUtil.createMaybeSingletonList((Object)originalInjection), Collections.emptyList());
        }
    }

    private static boolean doInjectInAttributeValue(XmlAttributeValue host, String languageId) {
        XmlTag tag;
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)host, XmlAttribute.class, (boolean)true);
        XmlTag xmlTag = tag = attribute == null ? null : attribute.getParent();
        if (tag != null) {
            XmlAttributeInjection injection = new XmlAttributeInjection();
            injection.setInjectedLanguageId(languageId);
            injection.setAttributeName(attribute.getLocalName());
            injection.setAttributeNamespace(attribute.getNamespace());
            injection.setTagName(tag.getLocalName());
            injection.setTagNamespace(tag.getNamespace());
            XmlLanguageInjectionSupport.doEditInjection(host.getProject(), injection);
            return true;
        }
        return false;
    }

    private static void doEditInjection(Project project, XmlAttributeInjection template) {
        BaseInjection newInjection;
        Configuration configuration = Configuration.getInstance();
        template.initializePlaces(false);
        BaseInjection originalInjection = configuration.findExistingInjection(template);
        BaseInjection baseInjection = newInjection = originalInjection == null ? template : originalInjection.copy();
        if (InjectLanguageAction.doEditConfigurable(project, (Configurable)new XmlAttributeInjectionConfigurable((XmlAttributeInjection)newInjection, null, project))) {
            Configuration.getInstance().replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), ContainerUtil.createMaybeSingletonList((Object)originalInjection), Collections.emptyList());
        }
    }

    private static ArrayList<BaseInjection> collectInjections(PsiLanguageInjectionHost host, Configuration configuration) {
        ArrayList<BaseInjection> result = new ArrayList<BaseInjection>();
        XmlTag element = host instanceof XmlText ? ((XmlText)host).getParentTag() : (host instanceof XmlAttributeValue ? host.getParent() : host);
        for (BaseInjection injection : configuration.getInjections("xml")) {
            if (!injection.acceptsPsiElement((PsiElement)element)) continue;
            result.add(injection);
        }
        return result;
    }

    @Override
    public AnAction[] createAddActions(final Project project, final Consumer<BaseInjection> consumer) {
        return new AnAction[]{new AnAction("XML Tag Injection", null, Icons.XML_TAG_ICON){

            public void actionPerformed(AnActionEvent e) {
                AbstractTagInjection newInjection = XmlLanguageInjectionSupport.this.showInjectionUI(project, new XmlTagInjection());
                if (newInjection != null) {
                    consumer.consume((Object)newInjection);
                }
            }
        }, new AnAction("XML Attribute Injection", null, Icons.ANNOTATION_TYPE_ICON){

            public void actionPerformed(AnActionEvent e) {
                AbstractTagInjection injection = XmlLanguageInjectionSupport.this.showInjectionUI(project, new XmlAttributeInjection());
                if (injection != null) {
                    consumer.consume((Object)injection);
                }
            }
        }};
    }

    @Override
    public AnAction createEditAction(final Project project, final Factory<BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection originalInjection = (BaseInjection)producer.create();
                BaseInjection injection = XmlLanguageInjectionSupport.createFrom(originalInjection, null);
                if (injection != null) {
                    AbstractTagInjection newInjection = XmlLanguageInjectionSupport.this.showInjectionUI(project, injection);
                    if (newInjection != null) {
                        originalInjection.copyFrom(newInjection);
                        originalInjection.initializePlaces(true);
                    }
                } else {
                    AbstractLanguageInjectionSupport.createDefaultEditAction(project, (Factory<BaseInjection>)producer).actionPerformed(null);
                }
            }
        };
    }
}

