/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.actions.TargetActionStub;
import com.intellij.lang.ant.config.explorer.AntExplorer;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntToolwindowRegistrar
extends AbstractProjectComponent {
    private AntExplorer myAntExplorer;
    private final ToolWindowManager myToolWindowManager;

    public AntToolwindowRegistrar(Project project, ToolWindowManager toolWindowManager) {
        super(project);
        this.myToolWindowManager = toolWindowManager;
    }

    public void projectOpened() {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        String prefix = AntConfiguration.getActionIdPrefix(this.myProject);
        ActionManager actionManager = ActionManager.getInstance();
        for (Keymap keymap : keymapManager.getAllKeymaps()) {
            for (String id : keymap.getActionIds()) {
                if (!id.startsWith(prefix) || actionManager.getAction(id) != null) continue;
                actionManager.registerAction(id, (AnAction)new TargetActionStub(id, this.myProject));
            }
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        final DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        compilerManager.addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfiguration config = AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                ((AntConfigurationBase)config).ensureInitialized();
                return config.executeTargetBeforeCompile(dataContext);
            }
        });
        compilerManager.addAfterTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfiguration config = AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                ((AntConfigurationBase)config).ensureInitialized();
                return config.executeTargetAfterCompile(dataContext);
            }
        });
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                JPanel explorerPanel = new JPanel(new BorderLayout()){
                    boolean explorerInitialized;
                    {
                        this.explorerInitialized = false;
                    }

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        if (!this.explorerInitialized) {
                            this.explorerInitialized = true;
                            this.add((Component)((Object)(AntToolwindowRegistrar.this.myAntExplorer = new AntExplorer(AntToolwindowRegistrar.this.myProject))), "Center");
                        }
                    }
                };
                ToolWindow toolWindow = AntToolwindowRegistrar.this.myToolWindowManager.registerToolWindow(ToolWindowId.ANT_BUILD, (JComponent)explorerPanel, ToolWindowAnchor.RIGHT);
                toolWindow.setIcon(IconLoader.getIcon((String)"/general/toolWindowAnt.png"));
            }
        });
    }

    public void projectClosed() {
        String[] oldIds;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (String oldId : oldIds = actionManager.getActionIds(AntConfiguration.getActionIdPrefix(this.myProject))) {
            actionManager.unregisterAction(oldId);
        }
        if (this.myAntExplorer != null) {
            this.myToolWindowManager.unregisterToolWindow(ToolWindowId.ANT_BUILD);
            this.myAntExplorer.dispose();
            this.myAntExplorer = null;
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("AntToolwindowRegistrar" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/impl/AntToolwindowRegistrar.getComponentName must not return null");
        }
        return "AntToolwindowRegistrar";
    }
}

