/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.misc.AntPsiUtil;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.impl.reference.AntPropertyReference;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;

public class AntCreatePropertyFix
extends BaseIntentionAction {
    private final AntPropertyReference myRef;
    private final PropertiesFile myPropFile;

    public AntCreatePropertyFix(AntPropertyReference ref) {
        this(ref, null);
    }

    public AntCreatePropertyFix(AntPropertyReference ref, PropertiesFile propFile) {
        this.myRef = ref;
        this.myPropFile = propFile;
    }

    @NotNull
    public String getFamilyName() {
        String i18nName = AntBundle.message("intention.create.property.family.name", new Object[0]);
        String string = i18nName == null ? "Create property" : i18nName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreatePropertyFix.getFamilyName must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getText() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append(this.getFamilyName());
        builder.append(" '");
        builder.append(this.myRef.getCanonicalRepresentationText());
        builder.append('\'');
        if (this.myPropFile != null) {
            builder.append(' ');
            builder.append(AntBundle.message("text.in.the.file", this.myPropFile.getName()));
        }
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreatePropertyFix.getText must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreatePropertyFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreatePropertyFix.invoke must not be null");
        }
        String name = this.myRef.getCanonicalRepresentationText();
        if (name == null) {
            return;
        }
        Navigatable result = null;
        if (this.myPropFile != null) {
            result = (Navigatable)this.myPropFile.addProperty(PropertiesElementFactory.createProperty((Project)this.myPropFile.getProject(), (String)name, (String)""));
        } else {
            AntElement element = this.myRef.getElement();
            AntElement anchor = AntPsiUtil.getSubProjectElement(element);
            XmlTag projectTag = element.getAntProject().getSourceElement();
            XmlTag propTag = projectTag.createChildTag("property", projectTag.getNamespace(), null, false);
            propTag.setAttribute("name", name);
            if (CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)projectTag)) {
                result = (Navigatable)(anchor == null ? projectTag.add((PsiElement)propTag) : projectTag.addBefore((PsiElement)propTag, (PsiElement)anchor.getSourceElement()));
            }
        }
        if (result != null) {
            result.navigate(true);
        }
    }
}

