/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;

public class MavenTargetUtil {
    public static PsiElement getRefactorTarget(Editor editor, PsiFile file) {
        PsiElement target = MavenTargetUtil.getFindTarget(editor, file);
        return target == null || !MavenDomUtil.isMavenProperty(target) ? null : target;
    }

    public static PsiElement getFindTarget(Editor editor, PsiFile file) {
        if (editor == null || file == null) {
            return null;
        }
        PsiElement target = TargetElementUtil.findTargetElement((Editor)editor, (int)1);
        if (target instanceof MavenPsiElementWrapper) {
            return ((MavenPsiElementWrapper)target).getWrappee();
        }
        if ((target == null || MavenTargetUtil.isSchema(target)) && (target = file.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return null;
        }
        if (!MavenDomUtil.isMavenFile(target)) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)target, XmlTag.class, (boolean)false);
    }

    private static boolean isSchema(PsiElement element) {
        return element instanceof XmlTag && "http://www.w3.org/2001/XMLSchema".equals(((XmlTag)element).getNamespace());
    }
}

