/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;

public class MavenUtil {
    public static final String MAVEN_NOTIFICATION_GROUP = "Maven";

    public static void invokeLater(Project p, Runnable r) {
        MavenUtil.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(final Project p, ModalityState state, final Runnable r) {
        if (MavenUtil.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (p.isDisposed()) {
                        return;
                    }
                    r.run();
                }
            }, state);
        }
    }

    public static void invokeAndWait(Project p, Runnable r) {
        MavenUtil.invokeAndWait(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeAndWait(final Project p, ModalityState state, final Runnable r) {
        if (MavenUtil.isNoBackgroundMode()) {
            r.run();
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (p.isDisposed()) {
                        return;
                    }
                    r.run();
                }
            }, state);
        }
    }

    public static void invokeAndWaitWriteAction(Project p, final Runnable r) {
        MavenUtil.invokeAndWait(p, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(r);
            }
        });
    }

    public static void runDumbAware(final Project project, final Runnable r) {
        if (r instanceof DumbAware) {
            r.run();
        } else {
            DumbService.getInstance((Project)project).runWhenSmart(new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    r.run();
                }
            });
        }
    }

    public static void runWhenInitialized(Project project, Runnable r) {
        if (project.isDisposed()) {
            return;
        }
        if (MavenUtil.isNoBackgroundMode()) {
            r.run();
            return;
        }
        if (!project.isInitialized()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(r);
            return;
        }
        MavenUtil.runDumbAware(project, r);
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public static boolean isInModalContext() {
        if (MavenUtil.isNoBackgroundMode()) {
            return false;
        }
        return LaterInvocator.isInModalContext();
    }

    public static void showError(Project project, String title, Throwable e) {
        MavenLog.LOG.warn(title, e);
        Notifications.Bus.notify((Notification)new Notification(MAVEN_NOTIFICATION_GROUP, title, e.getMessage(), NotificationType.ERROR), (Project)project);
    }

    public static Properties getSystemProperties() {
        Properties result = (Properties)System.getProperties().clone();
        for (String each : new THashSet(result.keySet())) {
            if (!each.startsWith("idea.")) continue;
            result.remove(each);
        }
        return result;
    }

    public static Properties getEnvProperties() {
        Properties reuslt = new Properties();
        for (Map.Entry<String, String> each : System.getenv().entrySet()) {
            if (MavenUtil.isMagicalProperty(each.getKey())) continue;
            reuslt.put(each.getKey(), each.getValue());
        }
        return reuslt;
    }

    private static boolean isMagicalProperty(String key) {
        return key.startsWith("=");
    }

    public static File getPluginSystemDir(String folder) {
        return new File(PathManager.getSystemPath(), "Maven/" + folder).getAbsoluteFile();
    }

    public static VirtualFile findProfilesXmlFile(VirtualFile pomFile) {
        return pomFile.getParent().findChild("profiles.xml");
    }

    public static File getProfilesXmlIoFile(VirtualFile pomFile) {
        return new File(pomFile.getParent().getPath(), "profiles.xml");
    }

    public static <T, U> List<T> collectFirsts(List<Pair<T, U>> pairs) {
        ArrayList<Object> result = new ArrayList<Object>(pairs.size());
        for (Pair<T, U> each : pairs) {
            result.add(each.first);
        }
        return result;
    }

    public static <T, U> List<U> collectSeconds(List<Pair<T, U>> pairs) {
        ArrayList<Object> result = new ArrayList<Object>(pairs.size());
        for (Pair<T, U> each : pairs) {
            result.add(each.second);
        }
        return result;
    }

    public static List<String> collectPaths(List<VirtualFile> files) {
        return ContainerUtil.map(files, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return file.getPath();
            }
        });
    }

    public static List<VirtualFile> collectFiles(Collection<MavenProject> projects) {
        return ContainerUtil.map(projects, (Function)new Function<MavenProject, VirtualFile>(){

            public VirtualFile fun(MavenProject project) {
                return project.getFile();
            }
        });
    }

    public static <T> boolean equalAsSets(Collection<T> collection1, Collection<T> collection2) {
        return ((Object)MavenUtil.toSet(collection1)).equals(MavenUtil.toSet(collection2));
    }

    private static <T> Collection<T> toSet(Collection<T> collection) {
        return collection instanceof Set ? collection : new THashSet((Collection)collection);
    }

    public static <T, U> List<Pair<T, U>> mapToList(Map<T, U> map) {
        return ContainerUtil.map2List(map.entrySet(), (Function)new Function<Map.Entry<T, U>, Pair<T, U>>(){

            public Pair<T, U> fun(Map.Entry<T, U> tuEntry) {
                return Pair.create(tuEntry.getKey(), tuEntry.getValue());
            }
        });
    }

    public static String formatHtmlImage(URL url) {
        return "<img src=\"" + url + "\"> ";
    }

    public static void runOrApplyMavenProjectFileTemplate(Project project, VirtualFile file, MavenId projectId, MavenId parentId, boolean interactive) throws IOException {
        Properties properties = new Properties();
        Properties conditions = new Properties();
        properties.setProperty("GROUP_ID", projectId.getGroupId());
        properties.setProperty("ARTIFACT_ID", projectId.getArtifactId());
        properties.setProperty("VERSION", projectId.getVersion());
        if (parentId != null) {
            conditions.setProperty("HAS_PARENT", "true");
            properties.setProperty("PARENT_GROUP_ID", parentId.getGroupId());
            properties.setProperty("PARENT_ARTIFACT_ID", parentId.getArtifactId());
            properties.setProperty("PARENT_VERSION", parentId.getVersion());
        }
        MavenUtil.runOrApplyFileTemplate(project, file, "Maven Project.xml", properties, conditions, interactive);
    }

    public static void runFileTemplate(Project project, VirtualFile file, String templateName) throws IOException {
        MavenUtil.runOrApplyFileTemplate(project, file, templateName, new Properties(), new Properties(), true);
    }

    private static void runOrApplyFileTemplate(Project project, VirtualFile file, String templateName, Properties properties, Properties conditions, boolean interactive) throws IOException {
        FileTemplateManager manager = FileTemplateManager.getInstance();
        FileTemplate fileTemplate = manager.getJ2eeTemplate(templateName);
        Properties allProperties = manager.getDefaultProperties();
        if (!interactive) {
            allProperties.putAll((Map<?, ?>)properties);
        }
        allProperties.putAll((Map<?, ?>)conditions);
        String text = fileTemplate.getText(allProperties);
        Pattern pattern = Pattern.compile("\\$\\{(.*)\\}");
        Matcher matcher = pattern.matcher(text);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(builder, "\\$" + matcher.group(1).toUpperCase() + "\\$");
        }
        matcher.appendTail(builder);
        text = builder.toString();
        TemplateImpl template = (TemplateImpl)TemplateManager.getInstance((Project)project).createTemplate("", "", text);
        for (int i = 0; i < template.getSegmentsCount(); ++i) {
            if (i == template.getEndSegmentNumber()) continue;
            String name = template.getSegmentName(i);
            String value = "\"" + properties.getProperty(name, "") + "\"";
            template.addVariable(name, value, value, true);
        }
        if (interactive) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            editor.getDocument().setText((CharSequence)"");
            TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)template);
        } else {
            VfsUtil.saveText((VirtualFile)file, (String)template.getTemplateText());
        }
    }

    public static <T extends Collection<Pattern>> T collectPattern(String text, T result) {
        String antPattern = FileUtil.convertAntToRegexp((String)text.trim());
        try {
            result.add((Pattern)Pattern.compile(antPattern));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isIncluded(String relativeName, List<Pattern> includes, List<Pattern> excludes) {
        boolean result = false;
        for (Pattern each : includes) {
            if (!each.matcher(relativeName).matches()) continue;
            result = true;
            break;
        }
        if (!result) {
            return false;
        }
        for (Pattern each : excludes) {
            if (!each.matcher(relativeName).matches()) continue;
            return false;
        }
        return true;
    }

    public static <T extends Serializable> T cloneObject(T object) {
        try {
            return (T)((Serializable)BeanUtils.cloneBean(object));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static void stripDown(Object object) {
        try {
            for (Field each : ReflectionUtil.collectFields(object.getClass())) {
                Package pack;
                Class<?> type = each.getType();
                each.setAccessible(true);
                Object value = each.get(object);
                if (MavenUtil.shouldStrip(value)) {
                    each.set(object, null);
                    continue;
                }
                if (value == null || (pack = type.getPackage()) == null || !Model.class.getPackage().getName().equals(pack.getName())) continue;
                MavenUtil.stripDown(value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean shouldStrip(Object value) {
        if (value == null) {
            return false;
        }
        return value.getClass().isArray() || value instanceof Collection || value instanceof Map || value instanceof Xpp3Dom;
    }

    public static void run(Project project, String title, final MavenTask task) throws MavenProcessCanceledException {
        final Exception[] canceledEx = new Exception[1];
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, true){

            public void run(@NotNull ProgressIndicator i) {
                if (i == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/utils/MavenUtil$8.run must not be null");
                }
                try {
                    task.run(new MavenProgressIndicator(i));
                }
                catch (MavenProcessCanceledException e) {
                    canceledEx[0] = e;
                }
                catch (ProcessCanceledException e) {
                    canceledEx[0] = e;
                }
            }
        });
        if (canceledEx[0] instanceof MavenProcessCanceledException) {
            throw (MavenProcessCanceledException)canceledEx[0];
        }
        if (canceledEx[0] instanceof ProcessCanceledException) {
            throw new MavenProcessCanceledException();
        }
    }

    public static MavenTaskHandler runInBackground(final Project project, final String title, final boolean cancellable, final MavenTask task) {
        final MavenProgressIndicator indicator = new MavenProgressIndicator();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    task.run(indicator);
                }
                catch (MavenProcessCanceledException ignore) {
                    indicator.cancel();
                }
                catch (ProcessCanceledException ignore) {
                    indicator.cancel();
                }
            }
        };
        if (MavenUtil.isNoBackgroundMode()) {
            runnable.run();
            return new MavenTaskHandler(){

                @Override
                public void waitFor() {
                }
            };
        }
        final Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
        final MavenTaskHandler handler = new MavenTaskHandler(){

            @Override
            public void waitFor() {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    MavenLog.LOG.error((Throwable)e);
                }
                catch (ExecutionException e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        };
        MavenUtil.invokeLater(project, new Runnable(){

            @Override
            public void run() {
                if (future.isDone()) {
                    return;
                }
                new Task.Backgroundable(project, title, cancellable){

                    public void run(@NotNull ProgressIndicator i) {
                        if (i == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/utils/MavenUtil$12$1.run must not be null");
                        }
                        indicator.setIndicator(i);
                        handler.waitFor();
                    }
                }.queue();
            }
        });
        return handler;
    }

    public static interface MavenTaskHandler {
        public void waitFor();
    }
}

