/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitCommand {
    public static final GitCommand STASH = GitCommand.write("stash");
    public static final GitCommand CLONE = GitCommand.write("clone");
    public static final GitCommand RM = GitCommand.write("rm");
    public static final GitCommand ADD = GitCommand.write("add");
    public static final GitCommand ANNOTATE = GitCommand.read("annotate");
    public static final GitCommand COMMIT = GitCommand.write("commit");
    public static final GitCommand CONFIG = GitCommand.meta("config");
    public static final GitCommand FETCH = GitCommand.write("fetch");
    public static final GitCommand SHOW = GitCommand.write("show");
    public static final GitCommand LOG = GitCommand.meta("log");
    public static final GitCommand INIT = GitCommand.write("init");
    public static final GitCommand BRANCH = GitCommand.meta("branch");
    public static final GitCommand MERGE = GitCommand.write("merge");
    public static final GitCommand MERGE_BASE = GitCommand.meta("merge-base");
    public static final GitCommand PUSH = GitCommand.write("push");
    public static final GitCommand LS_REMOTE = GitCommand.meta("ls-remote");
    public static final GitCommand REMOTE = GitCommand.meta("remote");
    public static final GitCommand REV_LIST = GitCommand.meta("rev-list");
    public static final GitCommand CHECKOUT = GitCommand.write("checkout");
    public static final GitCommand TAG = GitCommand.meta("tag");
    public static final GitCommand PULL = GitCommand.write("pull");
    public static final GitCommand LS_FILES = GitCommand.read("ls-files");
    public static final GitCommand DIFF = GitCommand.read("diff");
    public static final GitCommand VERSION = GitCommand.meta("version");
    public static final GitCommand REBASE = GitCommand.writeSuspendable("rebase");
    public static final GitCommand RESET = GitCommand.write("reset");
    public static final GitCommand UPDATE_INDEX = GitCommand.write("update-index");
    public static final GitCommand CHECK_ATTR = GitCommand.read("check-attr");
    public static final String GIT_EDITOR_ENV = "GIT_EDITOR";
    @NotNull
    @NonNls
    private final String myName;
    @NotNull
    private final LockingPolicy myLocking;
    @NotNull
    private final ThreadPolicy myThreading;

    private GitCommand(@NonNls @NotNull String name, @NotNull LockingPolicy locking, @NotNull ThreadPolicy threading) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitCommand.<init> must not be null");
        }
        if (locking == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/commands/GitCommand.<init> must not be null");
        }
        if (threading == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/commands/GitCommand.<init> must not be null");
        }
        this.myLocking = locking;
        this.myName = name;
        this.myThreading = threading;
    }

    private static GitCommand meta(String name) {
        return new GitCommand(name, LockingPolicy.META, ThreadPolicy.ANY);
    }

    private static GitCommand read(String name) {
        return new GitCommand(name, LockingPolicy.READ, ThreadPolicy.BACKGROUND_ONLY);
    }

    private static GitCommand write(String name) {
        return new GitCommand(name, LockingPolicy.WRITE, ThreadPolicy.BACKGROUND_ONLY);
    }

    private static GitCommand writeSuspendable(String name) {
        return new GitCommand(name, LockingPolicy.WRITE_SUSPENDABLE, ThreadPolicy.BACKGROUND_ONLY);
    }

    @NotNull
    public String name() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/commands/GitCommand.name must not return null");
        }
        return string;
    }

    @NotNull
    public LockingPolicy lockingPolicy() {
        LockingPolicy lockingPolicy = this.myLocking;
        if (lockingPolicy == null) {
            throw new IllegalStateException("@NotNull method git4idea/commands/GitCommand.lockingPolicy must not return null");
        }
        return lockingPolicy;
    }

    @NotNull
    public ThreadPolicy threadingPolicy() {
        ThreadPolicy threadPolicy = this.myThreading;
        if (threadPolicy == null) {
            throw new IllegalStateException("@NotNull method git4idea/commands/GitCommand.threadingPolicy must not return null");
        }
        return threadPolicy;
    }

    static enum ThreadPolicy {
        ANY,
        BACKGROUND_ONLY;

    }

    static enum LockingPolicy {
        READ,
        WRITE,
        WRITE_SUSPENDABLE,
        META;

    }
}

