/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitBranch;
import git4idea.GitRevisionNumber;
import git4idea.actions.GitShowAllSubmittedFilesAction;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUIUtil;
import git4idea.validators.GitBranchNameValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GitUnstashDialog
extends DialogWrapper {
    private JComboBox myGitRootComboBox;
    private JLabel myCurrentBranch;
    private JButton myViewButton;
    private JButton myDropButton;
    private JButton myClearButton;
    private JCheckBox myPopStashCheckBox;
    private JTextField myBranchTextField;
    private JPanel myPanel;
    private JList myStashList;
    private JCheckBox myReinstateIndexCheckBox;
    private final HashSet<String> myBranches;
    private final Project myProject;

    public GitUnstashDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myBranches = new HashSet();
        this.myProject = project;
        this.setTitle(GitBundle.getString("unstash.title"));
        this.setOKButtonText(GitBundle.getString("unstash.button.apply"));
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranch);
        this.myStashList.setModel(new DefaultListModel());
        this.refreshStashList();
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.refreshStashList();
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myStashList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myBranchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myPopStashCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitLineHandler h = new GitLineHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                h.setNoSSH(true);
                h.addParameters("clear");
                GitHandlerUtil.doSynchronously(h, GitBundle.getString("unstash.clearing.stashes"), h.printableCommandLine());
                GitUnstashDialog.this.refreshStashList();
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myDropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String stash = GitUnstashDialog.this.getSelectedStash();
                GitSimpleHandler h = this.dropHandler(stash);
                try {
                    h.setSilent(true);
                    h.run();
                    h.unsilence();
                }
                catch (VcsException ex) {
                    try {
                        if (!ex.getMessage().startsWith("fatal: Needed a single revision")) {
                            h.unsilence();
                            throw ex;
                        }
                        h = this.dropHandler(GitUnstashDialog.translateStash(stash));
                        h.run();
                    }
                    catch (VcsException ex2) {
                        GitUIUtil.showOperationError(GitUnstashDialog.this.myProject, ex, h.printableCommandLine());
                        return;
                    }
                }
                GitUnstashDialog.this.refreshStashList();
                GitUnstashDialog.this.updateDialogState();
            }

            private GitSimpleHandler dropHandler(String stash) {
                GitSimpleHandler h = new GitSimpleHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                h.setNoSSH(true);
                h.addParameters("drop", stash);
                return h;
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String resolvedStash;
                VirtualFile root = GitUnstashDialog.this.getGitRoot();
                String selectedStash = GitUnstashDialog.this.getSelectedStash();
                try {
                    resolvedStash = GitRevisionNumber.resolve(GitUnstashDialog.this.myProject, root, selectedStash).asString();
                }
                catch (VcsException ex) {
                    try {
                        if (!ex.getMessage().startsWith("fatal: bad revision 'stash@")) {
                            throw ex;
                        }
                        selectedStash = GitUnstashDialog.translateStash(selectedStash);
                        resolvedStash = GitRevisionNumber.resolve(GitUnstashDialog.this.myProject, root, selectedStash).asString();
                    }
                    catch (VcsException ex2) {
                        GitUIUtil.showOperationError(GitUnstashDialog.this.myProject, ex, "resolving revision");
                        return;
                    }
                }
                GitShowAllSubmittedFilesAction.showSubmittedFiles(GitUnstashDialog.this.myProject, resolvedStash, root);
            }
        });
        this.init();
        this.updateDialogState();
    }

    private static String translateStash(String selectedStash) {
        return selectedStash.replaceAll("([\\{}])", "\\\\$1");
    }

    private void updateDialogState() {
        String branch = this.myBranchTextField.getText();
        if (branch.length() != 0) {
            this.setOKButtonText(GitBundle.getString("unstash.button.branch"));
            this.myPopStashCheckBox.setEnabled(false);
            this.myPopStashCheckBox.setSelected(true);
            this.myReinstateIndexCheckBox.setEnabled(false);
            this.myReinstateIndexCheckBox.setSelected(true);
            if (!GitBranchNameValidator.INSTANCE.checkInput(branch)) {
                this.setErrorText(GitBundle.getString("unstash.error.invalid.branch.name"));
                this.setOKActionEnabled(false);
                return;
            }
            if (this.myBranches.contains(branch)) {
                this.setErrorText(GitBundle.getString("unstash.error.branch.exists"));
                this.setOKActionEnabled(false);
                return;
            }
        } else {
            if (!this.myPopStashCheckBox.isEnabled()) {
                this.myPopStashCheckBox.setSelected(false);
            }
            this.myPopStashCheckBox.setEnabled(true);
            this.setOKButtonText(this.myPopStashCheckBox.isSelected() ? GitBundle.getString("unstash.button.pop") : GitBundle.getString("unstash.button.apply"));
            if (!this.myReinstateIndexCheckBox.isEnabled()) {
                this.myReinstateIndexCheckBox.setSelected(false);
            }
            this.myReinstateIndexCheckBox.setEnabled(true);
        }
        if (this.myStashList.getModel().getSize() == 0) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.myClearButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myClearButton.setEnabled(true);
        if (this.myStashList.getSelectedIndex() == -1) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myViewButton.setEnabled(true);
        this.myDropButton.setEnabled(true);
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void refreshStashList() {
        String out;
        DefaultListModel listModel = (DefaultListModel)this.myStashList.getModel();
        listModel.clear();
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, this.getGitRoot(), GitCommand.STASH);
        h.setSilent(true);
        h.setNoSSH(true);
        h.addParameters("list");
        try {
            h.setCharset(Charset.forName(GitConfigUtil.getLogEncoding(this.myProject, this.getGitRoot())));
            out = h.run();
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, e, h.printableCommandLine());
            return;
        }
        StringScanner s = new StringScanner(out);
        while (s.hasMoreData()) {
            listModel.addElement(new StashInfo(s.boundedToken(':'), s.boundedToken(':'), s.line()));
        }
        this.myBranches.clear();
        try {
            GitBranch.listAsStrings(this.myProject, this.getGitRoot(), false, true, this.myBranches);
        }
        catch (VcsException e) {
            // empty catch block
        }
    }

    private VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    private GitLineHandler handler(boolean escaped) {
        GitLineHandler h = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.STASH);
        h.setNoSSH(true);
        String branch = this.myBranchTextField.getText();
        if (branch.length() == 0) {
            h.addParameters(this.myPopStashCheckBox.isSelected() ? "pop" : "apply");
            if (this.myReinstateIndexCheckBox.isSelected()) {
                h.addParameters("--index");
            }
        } else {
            h.addParameters("branch", branch);
        }
        String selectedStash = this.getSelectedStash();
        h.addParameters(escaped ? GitUnstashDialog.translateStash(selectedStash) : selectedStash);
        return h;
    }

    private String getSelectedStash() {
        return ((StashInfo)this.myStashList.getSelectedValue()).myStash;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Unstash";
    }

    public static void showUnstashDialog(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot, Set<VirtualFile> affectedRoots) {
        GitUnstashDialog d = new GitUnstashDialog(project, gitRoots, defaultRoot);
        d.show();
        if (!d.isOK()) {
            return;
        }
        affectedRoots.add(d.getGitRoot());
        GitLineHandler h = d.handler(false);
        final AtomicBoolean needToEscapedBraces = new AtomicBoolean(false);
        h.addLineListener(new GitLineHandlerAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (line.startsWith("fatal: Needed a single revision")) {
                    needToEscapedBraces.set(true);
                }
            }
        });
        int rc = GitHandlerUtil.doSynchronously(h, GitBundle.getString("unstash.unstashing"), h.printableCommandLine(), false);
        if (needToEscapedBraces.get()) {
            h = d.handler(true);
            rc = GitHandlerUtil.doSynchronously(h, GitBundle.getString("unstash.unstashing"), h.printableCommandLine(), false);
        }
        if (rc != 0) {
            GitUIUtil.showOperationErrors(project, h.errors(), h.printableCommandLine());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JList jList;
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRootComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jLabel.setText("  ");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.stashes"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myViewButton = jButton3 = new JButton();
        jButton3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.view.tooltip"));
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.view"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDropButton = jButton2 = new JButton();
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.drop.tooltip"));
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.drop"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myClearButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.clear.tooltip"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.clear"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.branch.label:"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchTextField = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.branch.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myStashList = jList = new JList();
        jList.setSelectionMode(0);
        jScrollPane.setViewportView(jList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPopStashCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.pop.stash"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.pop.stash.tooltip"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReinstateIndexCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.reinstate.index"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.reinstate.index.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jScrollPane);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class StashInfo {
        private final String myStash;
        private final String myText;

        public StashInfo(String stash, String branch, String message) {
            this.myStash = stash;
            this.myText = GitBundle.message("unstash.stashes.item", StringUtil.escapeXml((String)stash), StringUtil.escapeXml((String)branch), StringUtil.escapeXml((String)message));
        }

        public String toString() {
            return this.myText;
        }
    }
}

