/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrDocMethodParamsImpl
extends GroovyDocPsiElementImpl
implements GrDocMethodParams {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocMethodParamsImpl");

    public GrDocMethodParamsImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodParamsImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "GrDocMethodParameterList";
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitDocMethodParameterList(this);
    }

    @Override
    public PsiType[] getParameterTypes() {
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        PsiManagerEx manager = this.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.getProject());
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        for (GrDocMethodParameter parameter : this.getParameters()) {
            GrDocReferenceElement typeElement = parameter.getTypeElement();
            try {
                PsiType type = factory.createTypeFromText(typeElement.getText(), (PsiElement)this);
                type = TypesUtil.boxPrimitiveType(type, (PsiManager)manager, scope);
                types.add(type);
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                types.add(null);
            }
        }
        return types.toArray(new PsiType[types.size()]);
    }

    @Override
    public GrDocMethodParameter[] getParameters() {
        return (GrDocMethodParameter[])this.findChildrenByClass(GrDocMethodParameter.class);
    }

    @Override
    @NotNull
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN);
        assert (paren != null);
        PsiElement psiElement = paren.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodParamsImpl.getLeftParen must not return null");
        }
        return psiElement;
    }

    @Override
    @Nullable
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN);
        return paren != null ? paren.getPsi() : null;
    }
}

