/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsoperations.common.RepositoryModificationOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class CvsStandardOperationsProvider {
    private RepositoryModificationOperation myCurrentTransaction;
    private final Project myProject;

    public CvsStandardOperationsProvider(Project project) {
        this.myProject = project;
    }

    public void checkinFile(String path, Object parameters, Map userData) throws VcsException {
        this.getCurrentTransaction().commitFile(path);
    }

    public void addFile(String folderPath, String name, Object parameters, Map userData) throws VcsException {
        KeywordSubstitution substitution = null;
        if (parameters instanceof KeywordSubstitution) {
            substitution = (KeywordSubstitution)parameters;
        }
        this.getCurrentTransaction().addFile(folderPath, name, substitution);
    }

    public void removeFile(String path, Object parameters, Map userData) throws VcsException {
        this.getCurrentTransaction().removeFile(path);
    }

    public void addDirectory(String parentPath, String name, Object parameters, Map userData) throws VcsException {
        this.addFile(parentPath, name, parameters, userData);
    }

    public void removeDirectory(String path, Object parameters, Map userData) throws VcsException {
    }

    private RepositoryModificationOperation getCurrentTransaction() {
        if (this.myCurrentTransaction == null) {
            this.createTransaction();
        }
        return this.myCurrentTransaction;
    }

    public void createTransaction() {
        this.myCurrentTransaction = RepositoryModificationOperation.createGlobalTransactionOperation(null, CvsConfiguration.getInstance(this.myProject));
    }

    public int getFilesToProcessCount() {
        return this.getCurrentTransaction().getFilesToProcessCount();
    }

    public void commit(Object parameters) throws VcsException {
        this.getCurrentTransaction().setMessage(parameters);
        CvsVcs2.executeOperation(CvsBundle.message((String)"operation.name.commit.changes", (Object[])new Object[0]), this.getCurrentTransaction(), this.myProject);
        this.myCurrentTransaction = null;
    }

    public void rollback() {
        this.myCurrentTransaction = null;
    }

    public byte[] getFileContent(String path) throws VcsException {
        try {
            GetFileContentOperation command = GetFileContentOperation.createForFile(CvsVfsUtil.findFileByIoFile(new File(path)));
            CvsVcs2.executeOperation(CvsBundle.message((String)"operation.name.get.file.content", (Object[])new Object[0]), command, this.myProject);
            return command.getFileBytes();
        }
        catch (CannotFindCvsRootException cannotFindCvsRootException) {
            throw new VcsException((Throwable)cannotFindCvsRootException);
        }
    }
}

