/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.CvsRootEditor;
import com.intellij.cvsSupport2.config.ui.CvsRootAsStringConfigurationPanel;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.CvsRootDataBuilder;
import com.intellij.cvsSupport2.connections.ext.ui.ExtConnectionDualPanel;
import com.intellij.cvsSupport2.connections.local.ui.LocalConnectionSettingsPanel;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.connections.pserver.ui.PServerSettingsPanel;
import com.intellij.cvsSupport2.connections.ssh.ui.SshConnectionSettingsPanel;
import com.intellij.cvsSupport2.connections.ui.ProxySettingsPanel;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsProviderOnEnvironment;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.ui.DateOrRevisionOrTagSettings;
import com.intellij.cvsSupport2.ui.CvsRootChangeListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.BooleanValueHolder;
import com.intellij.util.ThreeState;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Cvs2SettingsEditPanel
implements CvsRootEditor {
    private JPanel myPanel;
    private final BooleanValueHolder myIsInUpdating;
    private final CvsRootAsStringConfigurationPanel myCvsRootConfigurationPanelView;
    private JPanel myCvsRootConfigurationPanel;
    private final DateOrRevisionOrTagSettings myDateOrRevisionOrTagSettings;
    private JPanel myConnectionSettingsPanel;
    private JPanel myDateOrRevisionOrTagSettingsPanel;
    private final ExtConnectionDualPanel myExtConnectionSettingsEditor;
    private final SshConnectionSettingsPanel mySshConnectionSettingsEditor;
    private final LocalConnectionSettingsPanel myLocalConnectionSettingsPanel;
    private final PServerSettingsPanel myPServerSettingsEditor;
    private JButton myTestButton;
    @NonNls
    public static final String EMPTY = "EMPTY";
    private JPanel myProxySettingsPanel;
    private final ProxySettingsPanel myProxySettingsNonEmptyPanel;
    @NonNls
    private static final String NON_EMPTY_PROXY_SETTINGS = "NON-EMPTY-PROXY-SETTINGS";
    private final Project myProject;

    public Cvs2SettingsEditPanel(Project project) {
        this.$$$setupUI$$$();
        this.myIsInUpdating = new BooleanValueHolder(false);
        this.myCvsRootConfigurationPanelView = new CvsRootAsStringConfigurationPanel(this.myIsInUpdating);
        this.myProject = project;
        this.myDateOrRevisionOrTagSettings = new DateOrRevisionOrTagSettings(new TagsProviderOnEnvironment(){

            @Override
            @NotNull
            protected CvsEnvironment getEnv() {
                CvsRootConfiguration cvsRootConfiguration = Cvs2SettingsEditPanel.this.createConfigurationWithCurrentSettings();
                if (cvsRootConfiguration == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/config/ui/Cvs2SettingsEditPanel$1.getEnv must not return null");
                }
                return cvsRootConfiguration;
            }
        }, project, true);
        this.myPanel.setSize(this.myPanel.getPreferredSize());
        this.myCvsRootConfigurationPanel.setLayout(new BorderLayout());
        this.myCvsRootConfigurationPanel.add((Component)this.myCvsRootConfigurationPanelView.getPanel(), "Center");
        this.myConnectionSettingsPanel.setLayout(new CardLayout());
        this.myExtConnectionSettingsEditor = new ExtConnectionDualPanel(this);
        this.mySshConnectionSettingsEditor = new SshConnectionSettingsPanel(this);
        this.myLocalConnectionSettingsPanel = new LocalConnectionSettingsPanel();
        this.myPServerSettingsEditor = new PServerSettingsPanel();
        this.myConnectionSettingsPanel.add((Component)this.myExtConnectionSettingsEditor.getPanel(), CvsMethod.EXT_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add((Component)this.myPServerSettingsEditor.getPanel(), CvsMethod.PSERVER_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add((Component)this.mySshConnectionSettingsEditor.getPanel(), CvsMethod.SSH_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add(this.myLocalConnectionSettingsPanel.getPanel(), CvsMethod.LOCAL_METHOD.getDisplayName());
        this.myConnectionSettingsPanel.add((Component)new JPanel(), EMPTY);
        this.myDateOrRevisionOrTagSettingsPanel.setLayout(new BorderLayout(4, 2));
        this.myDateOrRevisionOrTagSettingsPanel.add((Component)this.myDateOrRevisionOrTagSettings.getPanel(), "Center");
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Cvs2SettingsEditPanel.this.myPanel.isEnabled()) {
                    return;
                }
                Cvs2SettingsEditPanel.this.testConfiguration();
            }
        });
        this.addCvsRootChangeListener(new CvsRootChangeListener(){

            @Override
            public void onCvsRootChanged() {
                Cvs2SettingsEditPanel.this.setExtPanelEnabling();
            }
        });
        this.myProxySettingsPanel.setLayout(new CardLayout());
        this.myProxySettingsNonEmptyPanel = new ProxySettingsPanel();
        this.myProxySettingsPanel.add(this.myProxySettingsNonEmptyPanel.getPanel(), NON_EMPTY_PROXY_SETTINGS);
        this.myProxySettingsPanel.add((Component)new JPanel(), EMPTY);
    }

    public void addCvsRootChangeListener(CvsRootChangeListener cvsRootChangeListener) {
        this.myCvsRootConfigurationPanelView.addCvsRootChangeListener(cvsRootChangeListener);
    }

    private void testConfiguration() {
        this.testConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFrom(CvsRootConfiguration configuration) {
        this.setEnabled(true);
        this.myIsInUpdating.setValue(true);
        try {
            this.myCvsRootConfigurationPanelView.updateFrom(configuration);
            this.myExtConnectionSettingsEditor.updateFrom(configuration.EXT_CONFIGURATION, configuration.SSH_FOR_EXT_CONFIGURATION);
            this.mySshConnectionSettingsEditor.updateFrom(configuration.SSH_CONFIGURATION);
            this.myDateOrRevisionOrTagSettings.updateFrom(configuration.DATE_OR_REVISION_SETTINGS);
            this.myLocalConnectionSettingsPanel.updateFrom(configuration.LOCAL_CONFIGURATION);
            this.myProxySettingsNonEmptyPanel.updateFrom(configuration.PROXY_SETTINGS);
            this.myPServerSettingsEditor.updateFrom(CvsApplicationLevelConfiguration.getInstance());
        }
        finally {
            this.myIsInUpdating.setValue(false);
        }
        this.setExtPanelEnabling();
    }

    public boolean saveTo(CvsRootConfiguration configuration, boolean checkParameters) {
        try {
            this.myCvsRootConfigurationPanelView.saveTo(configuration, checkParameters);
            CvsApplicationLevelConfiguration globalCvsSettings = CvsApplicationLevelConfiguration.getInstance();
            if (!this.myExtConnectionSettingsEditor.equalsTo(configuration.EXT_CONFIGURATION, configuration.SSH_FOR_EXT_CONFIGURATION)) {
                this.myExtConnectionSettingsEditor.saveTo(configuration.EXT_CONFIGURATION, configuration.SSH_FOR_EXT_CONFIGURATION);
                this.myExtConnectionSettingsEditor.saveTo(globalCvsSettings.EXT_CONFIGURATION, globalCvsSettings.SSH_FOR_EXT_CONFIGURATION);
            }
            if (!this.mySshConnectionSettingsEditor.equalsTo(configuration.SSH_CONFIGURATION)) {
                this.mySshConnectionSettingsEditor.saveTo(configuration.SSH_CONFIGURATION);
                this.mySshConnectionSettingsEditor.saveTo(globalCvsSettings.SSH_CONFIGURATION);
            }
            if (!this.myLocalConnectionSettingsPanel.equalsTo(configuration.LOCAL_CONFIGURATION)) {
                this.myLocalConnectionSettingsPanel.saveTo(configuration.LOCAL_CONFIGURATION);
                this.myLocalConnectionSettingsPanel.saveTo(globalCvsSettings.LOCAL_CONFIGURATION);
            }
            if (!this.myProxySettingsNonEmptyPanel.equalsTo(configuration.PROXY_SETTINGS)) {
                this.myProxySettingsNonEmptyPanel.saveTo(configuration.PROXY_SETTINGS);
                this.myProxySettingsNonEmptyPanel.saveTo(globalCvsSettings.PROXY_SETTINGS);
            }
            this.myDateOrRevisionOrTagSettings.saveTo(configuration.DATE_OR_REVISION_SETTINGS);
            this.myPServerSettingsEditor.saveTo(globalCvsSettings);
            return true;
        }
        catch (InputException ex) {
            ex.show();
            return false;
        }
    }

    public void testConnection() {
        CvsRootConfiguration newConfiguration = this.createConfigurationWithCurrentSettings();
        if (newConfiguration == null) {
            return;
        }
        Cvs2SettingsEditPanel.testConnection(newConfiguration, this.myPanel, this.myProject);
        this.updateFrom(newConfiguration);
    }

    private CvsRootConfiguration createConfigurationWithCurrentSettings() {
        CvsRootConfiguration newConfiguration = CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance());
        if (!this.saveTo(newConfiguration, true)) {
            return null;
        }
        return newConfiguration;
    }

    public static void testConnection(CvsRootConfiguration configuration, Component component, Project project) {
        try {
            ModalityContextImpl executor = new ModalityContextImpl(true);
            CvsLoginWorker loginWorker = configuration.getLoginWorker(executor, project);
            ThreeState checkResult = LoginPerformer.checkLoginWorker(loginWorker, executor, project, true);
            if (ThreeState.NO.equals((Object)checkResult)) {
                Messages.showMessageDialog((Component)component, (String)CvsBundle.message((String)"test.connection.login.failed.text", (Object[])new Object[0]), (String)CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return;
            }
            if (ThreeState.UNSURE.equals((Object)checkResult)) {
                Messages.showMessageDialog((Component)component, (String)"Authentication canceled", (String)CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return;
            }
            configuration.testConnection();
            Cvs2SettingsEditPanel.showSuccessfulConnectionMessage(component);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Exception e) {
            Cvs2SettingsEditPanel.showConnectionFailedMessage(e, component);
        }
    }

    private static void showConnectionFailedMessage(Exception ex, Component component) {
        Messages.showMessageDialog((Component)component, (String)ex.getLocalizedMessage(), (String)CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    private static void showSuccessfulConnectionMessage(Component component) {
        Messages.showMessageDialog((Component)component, (String)CvsBundle.message((String)"operation.status.connection.successful", (Object[])new Object[0]), (String)CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private void setEnabled(boolean enabled) {
        this.setEnabled(this.myPanel, enabled);
        this.setExtPanelEnabling();
    }

    private void setExtPanelEnabling() {
        try {
            CvsRootData currentRootData = CvsRootDataBuilder.createSettingsOn(this.myCvsRootConfigurationPanelView.getCvsRoot(), true);
            String settingsPanelName = this.getSettingsPanelName(currentRootData);
            ((CardLayout)this.myConnectionSettingsPanel.getLayout()).show(this.myConnectionSettingsPanel, settingsPanelName);
            ((CardLayout)this.myProxySettingsPanel.getLayout()).show(this.myProxySettingsPanel, this.getProxyPanelName(currentRootData));
            if (currentRootData.CONTAINS_PROXY_INFO) {
                this.myProxySettingsNonEmptyPanel.updateFrom(currentRootData);
                this.myProxySettingsNonEmptyPanel.disablePanel();
            } else {
                this.myProxySettingsNonEmptyPanel.enablePanel();
            }
        }
        catch (Throwable ignored) {
            ((CardLayout)this.myConnectionSettingsPanel.getLayout()).show(this.myConnectionSettingsPanel, EMPTY);
            ((CardLayout)this.myProxySettingsPanel.getLayout()).show(this.myProxySettingsPanel, EMPTY);
        }
    }

    private String getProxyPanelName(CvsRootData cvsRootData) {
        if (cvsRootData.METHOD == null) {
            return EMPTY;
        }
        return cvsRootData.METHOD.supportsProxyConnection() ? NON_EMPTY_PROXY_SETTINGS : EMPTY;
    }

    private String getSettingsPanelName(CvsRootData cvsRootData) {
        CvsMethod method = cvsRootData.METHOD;
        if (method == null) {
            return EMPTY;
        }
        return method.getDisplayName();
    }

    private void setEnabled(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.setEnabled(container.getComponent(i), enabled);
            }
        }
    }

    public void disable() {
        this.clearAllTextFields();
        this.setEnabled(false);
    }

    private void clearAllTextFields() {
        this.clearAllTextFieldsIn(this.myPanel);
    }

    private void clearAllTextFieldsIn(Component component) {
        if (component instanceof JTextField) {
            ((JTextField)component).setText("");
            return;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.clearAllTextFieldsIn(container.getComponent(i));
            }
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCvsRootConfigurationPanelView.getPreferredFocusedComponent();
    }

    public void setReadOnly() {
        this.myCvsRootConfigurationPanelView.setReadOnly();
        this.setEnabled(this.myDateOrRevisionOrTagSettingsPanel, false);
    }

    @Override
    public String getCurrentRoot() {
        return this.myCvsRootConfigurationPanelView.getCvsRoot();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCvsRootConfigurationPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDateOrRevisionOrTagSettingsPanel = jPanel3 = new JPanel();
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConnectionSettingsPanel = jPanel2 = new JPanel();
        jPanel5.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProxySettingsPanel = jPanel = new JPanel();
        jPanel5.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTestButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("button.text.test.connection"));
        jButton.setMargin(new Insets(2, 14, 2, 14));
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

