/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.command.checkout.ExpandedModules;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class ExportCommand
extends AbstractCommand {
    @NonNls
    public static final String EXAM_DIR = "server: Updating ";
    private final List modules = new ArrayList();
    private String updateByDate;
    private String updateByRevisionOrTag;
    private String alternativeCheckoutDirectory;
    private KeywordSubstitution keywordSubstitution;

    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ExpandedModules expandedModules = new ExpandedModules();
        if (!this.expandModules(expandedModules, listenerRegistry, requestProcessor, clientEnvironment)) {
            return false;
        }
        return this.checkout(expandedModules, requestProcessor, listenerRegistry, clientEnvironment);
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setUpdateByDate(null);
        this.setUpdateByRevisionOrTag(null);
        this.setKeywordSubstitution(null);
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("export ");
        cvsCommandLine.append(this.getCvsArguments());
        for (String module : this.modules) {
            cvsCommandLine.append(module);
            cvsCommandLine.append(' ');
        }
        return cvsCommandLine.toString();
    }

    public void addModule(String module) {
        this.modules.add(module);
    }

    public void clearModules() {
        this.modules.clear();
    }

    private String getAlternativeCheckoutDirectory() {
        return this.alternativeCheckoutDirectory;
    }

    public void setAlternativeCheckoutDirectory(String alternativeCheckoutDirectory) {
        this.alternativeCheckoutDirectory = alternativeCheckoutDirectory;
    }

    private String getUpdateByDate() {
        return this.updateByDate;
    }

    public void setUpdateByDate(String updateByDate) {
        this.updateByDate = updateByDate;
    }

    private String getUpdateByRevisionOrTag() {
        return this.updateByRevisionOrTag;
    }

    public void setUpdateByRevisionOrTag(String updateByRevisionOrTag) {
        this.updateByRevisionOrTag = updateByRevisionOrTag;
    }

    private KeywordSubstitution getKeywordSubstitution() {
        return this.keywordSubstitution;
    }

    public void setKeywordSubstitution(KeywordSubstitution keywordSubstitution) {
        this.keywordSubstitution = keywordSubstitution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expandModules(ExpandedModules expandedModules, ICvsListenerRegistry listenerRegistry, IRequestProcessor requestProcessor, IClientEnvironment clientEnvironment) throws CommandException, AuthenticationException {
        Requests requests = new Requests(new ExpandModulesRequest(), clientEnvironment);
        this.addModuleArguments(requests);
        requests.addLocalPathDirectoryRequest();
        expandedModules.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
            return bl;
        }
        finally {
            expandedModules.unregisterListeners(listenerRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkout(ExpandedModules expandedModules, IRequestProcessor requestProcessor, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment) throws CommandException, AuthenticationException {
        this.processExistingModules(expandedModules, clientEnvironment);
        Requests requests = new Requests(CommandRequest.EXPORT, clientEnvironment);
        if (this.getAlternativeCheckoutDirectory() != null) {
            requests.addArgumentRequest("-d");
            requests.addArgumentRequest(this.getAlternativeCheckoutDirectory());
        }
        requests.addArgumentRequest(!this.isRecursive(), "-l");
        requests.addArgumentRequest(this.getUpdateByDate(), "-D");
        requests.addArgumentRequest(this.getUpdateByRevisionOrTag(), "-r");
        requests.addArgumentRequest(this.getKeywordSubstitution(), "-k");
        this.addModuleArguments(requests);
        requests.addLocalPathDirectoryRequest();
        boolean bl = requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
        return bl;
    }

    private void addModuleArguments(Requests requests) {
        for (String module : this.modules) {
            requests.addArgumentRequest(module);
        }
    }

    private void processExistingModules(ExpandedModules expandedModules, IClientEnvironment clientEnvironment) {
        ICvsFileSystem cvsFileSystem = clientEnvironment.getCvsFileSystem();
        for (String moduleName : expandedModules.getModules()) {
            DirectoryObject directoryObject;
            AbstractFileObject abstractFileObject;
            if (moduleName.equals(".")) {
                this.getFileObjects().addFileObject(DirectoryObject.getRoot());
                break;
            }
            File moduleFile = cvsFileSystem.getLocalFileSystem().getFile(moduleName);
            if (moduleFile.isFile()) {
                abstractFileObject = cvsFileSystem.getLocalFileSystem().getFileObject(moduleFile);
                directoryObject = abstractFileObject.getParent();
            } else {
                directoryObject = cvsFileSystem.getLocalFileSystem().getDirectoryObject(moduleFile);
                abstractFileObject = directoryObject;
            }
            if (!clientEnvironment.getAdminReader().hasCvsDirectory(directoryObject, cvsFileSystem)) continue;
            this.getFileObjects().addFileObject(abstractFileObject);
        }
    }

    private String getCvsArguments() {
        StringBuffer cvsArguments = new StringBuffer();
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        if (this.getKeywordSubstitution() != null) {
            cvsArguments.append("-k");
            cvsArguments.append(this.getKeywordSubstitution());
            cvsArguments.append(' ');
        }
        if (this.getUpdateByRevisionOrTag() != null && this.getUpdateByRevisionOrTag().length() > 0) {
            cvsArguments.append("-r ");
            cvsArguments.append(this.getUpdateByRevisionOrTag());
            cvsArguments.append(' ');
        }
        if (this.getUpdateByDate() != null && this.getUpdateByDate().length() > 0) {
            cvsArguments.append("-D ");
            cvsArguments.append(this.getUpdateByDate());
            cvsArguments.append(' ');
        }
        return cvsArguments.toString();
    }
}

