/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.filter.FilterHelper;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class IvyInstall
extends IvyTask {
    private String _organisation;
    private String _module;
    private String _revision;
    private File _cache;
    private boolean _overwrite = false;
    private String _from;
    private String _to;
    private boolean _transitive;
    private String _type;
    private String _matcher = "exact";

    public void execute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy publish task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null && "exact".equals(this._matcher)) {
            throw new BuildException("no module name provided for ivy publish task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this._module == null && !"exact".equals(this._matcher)) {
            this._module = "*";
        }
        if (this._revision == null && "exact".equals(this._matcher)) {
            throw new BuildException("no module revision provided for ivy publish task: It can either be set explicitely via the attribute 'revision' or via 'ivy.revision' property or a prior call to <resolve/>");
        }
        if (this._revision == null && !"exact".equals(this._matcher)) {
            this._revision = "*";
        }
        if (this._from == null) {
            throw new BuildException("no from resolver name: please provide it through parameter 'from'");
        }
        if (this._to == null) {
            throw new BuildException("no to resolver name: please provide it through parameter 'to'");
        }
        ModuleRevisionId mrid = ModuleRevisionId.newInstance(this._organisation, this._module, this._revision);
        try {
            ivy.install(mrid, this._from, this._to, this._transitive, this.doValidate(ivy), this._overwrite, FilterHelper.getArtifactTypeFilter(this._type), this._cache, this._matcher);
        }
        catch (Exception e) {
            throw new BuildException("impossible to install " + mrid + ": " + e, (Throwable)e);
        }
    }

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this._overwrite = overwrite;
    }

    public String getFrom() {
        return this._from;
    }

    public void setFrom(String from) {
        this._from = from;
    }

    public String getTo() {
        return this._to;
    }

    public void setTo(String to) {
        this._to = to;
    }

    public boolean isTransitive() {
        return this._transitive;
    }

    public void setTransitive(boolean transitive) {
        this._transitive = transitive;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getMatcher() {
        return this._matcher;
    }

    public void setMatcher(String matcher) {
        this._matcher = matcher;
    }
}

