/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import fr.jayasoft.ivy.repository.ssh.RemoteScpException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Scp {
    Session session;

    public Scp(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.session = session;
    }

    private void readResponse(InputStream is) throws IOException, RemoteScpException {
        int c = is.read();
        if (c == 0) {
            return;
        }
        if (c == -1) {
            throw new RemoteScpException("Remote scp terminated unexpectedly.");
        }
        if (c != 1 && c != 2) {
            throw new RemoteScpException("Remote scp sent illegal error code.");
        }
        if (c == 2) {
            throw new RemoteScpException("Remote scp terminated with error.");
        }
        String err = this.receiveLine(is);
        throw new RemoteScpException("Remote scp terminated with error (" + err + ").");
    }

    private String receiveLine(InputStream is) throws IOException, RemoteScpException {
        StringBuffer sb = new StringBuffer(30);
        while (true) {
            if (sb.length() > 8192) {
                throw new RemoteScpException("Remote scp sent a too long line");
            }
            int c = is.read();
            if (c < 0) {
                throw new RemoteScpException("Remote scp terminated unexpectedly.");
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    private void parseCLine(String line, FileInfo fileInfo) throws RemoteScpException {
        long len;
        if (line.length() < 8) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (line.charAt(4) != ' ' || line.charAt(5) == ' ') {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        int length_name_sep = line.indexOf(32, 5);
        if (length_name_sep == -1) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        String length_substring = line.substring(5, length_name_sep);
        String name_substring = line.substring(length_name_sep + 1);
        if (length_substring.length() <= 0 || name_substring.length() <= 0) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + length_substring.length() + name_substring.length() != line.length()) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        try {
            len = Long.parseLong(length_substring);
        }
        catch (NumberFormatException e) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (len < 0L) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        fileInfo.setLength(len);
        fileInfo.setFilename(name_substring);
    }

    private void parseTLine(String line, FileInfo fileInfo) throws RemoteScpException {
        long second_msec;
        long atime;
        long first_msec;
        long modtime;
        if (line.length() < 8) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line too short.");
        }
        int first_msec_begin = line.indexOf(" ") + 1;
        if (first_msec_begin == 0 || first_msec_begin >= line.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        int atime_begin = line.indexOf(" ", first_msec_begin + 1) + 1;
        if (atime_begin == 0 || atime_begin >= line.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        int second_msec_begin = line.indexOf(" ", atime_begin + 1) + 1;
        if (second_msec_begin == 0 || second_msec_begin >= line.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        try {
            modtime = Long.parseLong(line.substring(0, first_msec_begin - 1));
            first_msec = Long.parseLong(line.substring(first_msec_begin, atime_begin - 1));
            atime = Long.parseLong(line.substring(atime_begin, second_msec_begin - 1));
            second_msec = Long.parseLong(line.substring(second_msec_begin));
        }
        catch (NumberFormatException e) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (modtime < 0L || first_msec < 0L || atime < 0L || second_msec < 0L) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        fileInfo.setLastModified(modtime);
    }

    private void sendBytes(Channel channel, byte[] data, String fileName, String mode) throws IOException, RemoteScpException {
        OutputStream os = channel.getOutputStream();
        BufferedInputStream is = new BufferedInputStream(channel.getInputStream(), 512);
        try {
            if (channel.isConnected()) {
                channel.start();
            } else {
                channel.connect();
            }
        }
        catch (JSchException e1) {
            throw (IOException)new IOException("Channel connection problems").initCause(e1);
        }
        this.readResponse(is);
        String cline = "C" + mode + " " + data.length + " " + fileName + "\n";
        os.write(cline.getBytes());
        os.flush();
        this.readResponse(is);
        os.write(data, 0, data.length);
        os.write(0);
        os.flush();
        this.readResponse(is);
        os.write("E\n".getBytes());
        os.flush();
    }

    private void sendFile(Channel channel, String localFile, String remoteName, String mode) throws IOException, RemoteScpException {
        long remain;
        byte[] buffer = new byte[8192];
        BufferedOutputStream os = new BufferedOutputStream(channel.getOutputStream(), 40000);
        BufferedInputStream is = new BufferedInputStream(channel.getInputStream(), 512);
        try {
            if (channel.isConnected()) {
                channel.start();
            } else {
                channel.connect();
            }
        }
        catch (JSchException e1) {
            throw (IOException)new IOException("Channel connection problems").initCause(e1);
        }
        this.readResponse(is);
        File f = new File(localFile);
        String cline = "C" + mode + " " + remain + " " + remoteName + "\n";
        ((OutputStream)os).write(cline.getBytes());
        ((OutputStream)os).flush();
        this.readResponse(is);
        FileInputStream fis = null;
        try {
            int trans;
            fis = new FileInputStream(f);
            for (remain = f.length(); remain > 0L; remain -= (long)trans) {
                trans = remain > (long)buffer.length ? buffer.length : (int)remain;
                if (fis.read(buffer, 0, trans) != trans) {
                    throw new IOException("Cannot read enough from local file " + localFile);
                }
                ((OutputStream)os).write(buffer, 0, trans);
            }
            fis.close();
        }
        catch (IOException e) {
            if (fis != null) {
                fis.close();
            }
            throw e;
        }
        ((OutputStream)os).write(0);
        ((OutputStream)os).flush();
        this.readResponse(is);
        ((OutputStream)os).write("E\n".getBytes());
        ((OutputStream)os).flush();
    }

    private FileInfo receiveStream(Channel channel, String file, OutputStream targetStream) throws IOException, RemoteScpException {
        String line;
        int c;
        byte[] buffer = new byte[8192];
        OutputStream os = channel.getOutputStream();
        InputStream is = channel.getInputStream();
        try {
            if (channel.isConnected()) {
                channel.start();
            } else {
                channel.connect();
            }
        }
        catch (JSchException e1) {
            throw (IOException)new IOException("Channel connection problems").initCause(e1);
        }
        os.write(0);
        os.flush();
        FileInfo fileInfo = new FileInfo();
        while (true) {
            if ((c = is.read()) < 0) {
                throw new RemoteScpException("Remote scp terminated unexpectedly.");
            }
            line = this.receiveLine(is);
            if (c != 84) break;
            this.parseTLine(line, fileInfo);
            os.write(0);
            os.flush();
        }
        if (c == 1 || c == 2) {
            throw new RemoteScpException("Remote SCP error: " + line);
        }
        if (c != 67) {
            throw new RemoteScpException("Remote SCP error: " + (char)c + line);
        }
        this.parseCLine(line, fileInfo);
        if (targetStream != null) {
            os.write(0);
            os.flush();
            try {
                int this_time_received;
                for (long remain = fileInfo.getLength(); remain > 0L; remain -= (long)this_time_received) {
                    int trans = remain > (long)buffer.length ? buffer.length : (int)remain;
                    this_time_received = is.read(buffer, 0, trans);
                    if (this_time_received < 0) {
                        throw new IOException("Remote scp terminated connection unexpectedly");
                    }
                    targetStream.write(buffer, 0, this_time_received);
                }
                targetStream.close();
            }
            catch (IOException e) {
                if (targetStream != null) {
                    targetStream.close();
                }
                throw e;
            }
            this.readResponse(is);
            os.write(0);
            os.flush();
        }
        return fileInfo;
    }

    public void put(String localFile, String remoteTargetDirectory, String remoteName) throws IOException, RemoteScpException {
        this.put(localFile, remoteTargetDirectory, remoteName, "0600");
    }

    public void put(byte[] data, String remoteFileName, String remoteTargetDirectory) throws IOException, RemoteScpException {
        this.put(data, remoteFileName, remoteTargetDirectory, "0600");
    }

    public void put(byte[] data, String remoteFileName, String remoteTargetDirectory, String mode) throws IOException, RemoteScpException {
        ChannelExec channel = null;
        if (remoteFileName == null || mode == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (mode.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i = 0; i < mode.length(); ++i) {
            if (Character.isDigit(mode.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        String cmd = "scp -t ";
        if (remoteTargetDirectory != null && remoteTargetDirectory.length() > 0) {
            cmd = cmd + "-d " + remoteTargetDirectory;
        }
        try {
            channel = this.getExecChannel();
            channel.setCommand(cmd);
            this.sendBytes((Channel)channel, data, remoteFileName, mode);
        }
        catch (JSchException e) {
            if (channel != null) {
                channel.disconnect();
            }
            throw (IOException)new IOException("Error during SCP transfer." + e.getMessage()).initCause(e);
        }
    }

    private ChannelExec getExecChannel() throws JSchException {
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        return channel;
    }

    public void put(String localFile, String remoteTargetDir, String remoteTargetName, String mode) throws IOException, RemoteScpException {
        ChannelExec channel = null;
        if (localFile == null || remoteTargetName == null || mode == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (mode.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i = 0; i < mode.length(); ++i) {
            if (Character.isDigit(mode.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        String cmd = "scp -t ";
        if (remoteTargetDir != null && remoteTargetDir.length() > 0) {
            cmd = cmd + "-d " + remoteTargetDir;
        }
        try {
            channel = this.getExecChannel();
            channel.setCommand(cmd);
            this.sendFile((Channel)channel, localFile, remoteTargetName, mode);
            channel.disconnect();
        }
        catch (JSchException e) {
            if (channel != null) {
                channel.disconnect();
            }
            throw (IOException)new IOException("Error during SCP transfer." + e.getMessage()).initCause(e);
        }
    }

    public void get(String remoteFile, String localTarget) throws IOException, RemoteScpException {
        File f = new File(localTarget);
        FileOutputStream fop = new FileOutputStream(f);
        this.get(remoteFile, fop);
    }

    public void get(String remoteFile, OutputStream localTarget) throws IOException, RemoteScpException {
        ChannelExec channel = null;
        if (remoteFile == null || localTarget == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        String cmd = "scp -p -f " + remoteFile;
        try {
            channel = this.getExecChannel();
            channel.setCommand(cmd);
            this.receiveStream((Channel)channel, remoteFile, localTarget);
            channel.disconnect();
        }
        catch (JSchException e) {
            if (channel != null) {
                channel.disconnect();
            }
            throw (IOException)new IOException("Error during SCP transfer." + e.getMessage()).initCause(e);
        }
    }

    public FileInfo getFileinfo(String remoteFile) throws IOException, RemoteScpException {
        ChannelExec channel = null;
        FileInfo fileInfo = null;
        if (remoteFile == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        String cmd = "scp -p -f \"" + remoteFile + "\"";
        try {
            channel = this.getExecChannel();
            channel.setCommand(cmd);
            fileInfo = this.receiveStream((Channel)channel, remoteFile, null);
            channel.disconnect();
        }
        catch (JSchException e) {
            throw (IOException)new IOException("Error during SCP transfer." + e.getMessage()).initCause(e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return fileInfo;
    }

    public class FileInfo {
        private String filename;
        private long length;
        private long lastModified;

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

