/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import java.io.IOException;
import java.net.Proxy;
import java.net.SecureCacheResponse;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.https.HttpsClient;

public abstract class AbstractDelegateHttpsURLConnection
extends HttpURLConnection {
    protected AbstractDelegateHttpsURLConnection(URL uRL, Handler handler) throws IOException {
        this(uRL, null, handler);
    }

    protected AbstractDelegateHttpsURLConnection(URL uRL, Proxy proxy, Handler handler) throws IOException {
        super(uRL, proxy, handler);
    }

    protected abstract SSLSocketFactory getSSLSocketFactory();

    protected abstract HostnameVerifier getHostnameVerifier();

    @Override
    public void setNewClient(URL uRL) throws IOException {
        this.setNewClient(uRL, false);
    }

    @Override
    public void setNewClient(URL uRL, boolean bl) throws IOException {
        this.http = HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), bl);
        ((HttpsClient)this.http).afterConnect();
    }

    @Override
    public void setProxiedClient(URL uRL, String string, int n) throws IOException {
        this.setProxiedClient(uRL, string, n, false);
    }

    @Override
    public void setProxiedClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxiedConnect(uRL, string, n, bl);
        if (!this.http.isCachedConnection()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    @Override
    protected void proxiedConnect(URL uRL, String string, int n, boolean bl) throws IOException {
        if (this.connected) {
            return;
        }
        this.http = HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), string, n, bl);
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.plainConnect();
        if (this.cachedResponse != null) {
            return;
        }
        if (!this.http.isCachedConnection() && this.http.needsTunneling()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    @Override
    protected HttpClient getNewHttpClient(URL uRL, Proxy proxy, int n) throws IOException {
        return HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), proxy, true, n);
    }

    @Override
    protected HttpClient getNewHttpClient(URL uRL, Proxy proxy, int n, boolean bl) throws IOException {
        return HttpsClient.New(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), proxy, bl, n);
    }

    public String getCipherSuite() {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getCipherSuite();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (this.cachedResponse != null) {
            List<Certificate> list = ((SecureCacheResponse)this.cachedResponse).getLocalCertificateChain();
            if (list == null) {
                return null;
            }
            return (Certificate[])list.toArray();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            List<Certificate> list = ((SecureCacheResponse)this.cachedResponse).getServerCertificateChain();
            if (list == null) {
                return null;
            }
            return (Certificate[])list.toArray();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getServerCertificates();
    }

    public X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            throw new UnsupportedOperationException("this method is not supported when using cache");
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getServerCertificateChain();
    }

    Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getPeerPrincipal();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getPeerPrincipal();
    }

    Principal getLocalPrincipal() {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getLocalPrincipal();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalPrincipal();
    }
}

