/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import sun.jvm.hotspot.CommandProcessor;
import sun.jvm.hotspot.ui.EditableAtEndDocument;
import sun.jvm.hotspot.ui.GraphicsUtilities;

public class CommandProcessorPanel
extends JPanel {
    private CommandProcessor commands;
    private JTextArea editor;
    private boolean updating;
    private int mark;
    private String curText;
    private static final boolean DEBUGGING = false;
    ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);

    public CommandProcessorPanel(CommandProcessor cp) {
        this.commands = cp;
        this.setLayout(new BorderLayout());
        this.editor = new JTextArea();
        this.editor.setDocument(new EditableAtEndDocument());
        this.editor.setFont(GraphicsUtilities.lookupFont("Courier"));
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.editor);
        this.add((Component)scroller, "Center");
        PrintStream o = new PrintStream(this.baos, true);
        cp.setOutput(o);
        cp.setErr(o);
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (CommandProcessorPanel.this.updating) {
                    return;
                }
                CommandProcessorPanel.this.beginUpdate();
                CommandProcessorPanel.this.editor.setCaretPosition(CommandProcessorPanel.this.editor.getDocument().getLength());
                if (CommandProcessorPanel.this.insertContains(e, '\n')) {
                    String cmd = CommandProcessorPanel.this.getMarkedText();
                    if (cmd.length() == 0 || cmd.charAt(cmd.length() - 1) != '\\') {
                        final String ln = CommandProcessorPanel.this.trimContinuations(cmd);
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                CommandProcessorPanel.this.beginUpdate();
                                try {
                                    CommandProcessorPanel.this.commands.executeCommand(ln);
                                    CommandProcessorPanel.this.commands.printPrompt();
                                    Document d = CommandProcessorPanel.this.editor.getDocument();
                                    try {
                                        d.insertString(d.getLength(), CommandProcessorPanel.this.baos.toString(), null);
                                    }
                                    catch (BadLocationException ble) {
                                        ble.printStackTrace();
                                    }
                                    CommandProcessorPanel.this.baos.reset();
                                    CommandProcessorPanel.this.editor.setCaretPosition(CommandProcessorPanel.this.editor.getDocument().getLength());
                                    CommandProcessorPanel.this.setMark();
                                }
                                finally {
                                    CommandProcessorPanel.this.endUpdate();
                                }
                            }
                        });
                    }
                } else {
                    CommandProcessorPanel.this.endUpdate();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int len = CommandProcessorPanel.this.editor.getDocument().getLength();
                if (e.getDot() > len) {
                    CommandProcessorPanel.this.editor.setCaretPosition(len);
                }
            }
        });
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createGlue());
        JButton button = new JButton("Clear Saved Text");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandProcessorPanel.this.clear();
            }
        });
        hbox.add(button);
        hbox.add(Box.createGlue());
        this.add((Component)hbox, "South");
        this.clear();
    }

    @Override
    public void requestFocus() {
        this.editor.requestFocus();
    }

    public void clear() {
        EditableAtEndDocument d = (EditableAtEndDocument)this.editor.getDocument();
        d.clear();
        this.commands.executeCommand("");
        this.setMark();
        this.editor.requestFocus();
    }

    public void setMark() {
        ((EditableAtEndDocument)this.editor.getDocument()).setMark();
    }

    public String getMarkedText() {
        try {
            int i;
            String s = ((EditableAtEndDocument)this.editor.getDocument()).getMarkedText();
            for (i = s.length(); i > 0 && s.charAt(i - 1) == '\n'; --i) {
            }
            return s.substring(0, i);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void beginUpdate() {
        this.updating = true;
    }

    private void endUpdate() {
        this.updating = false;
    }

    private boolean insertContains(DocumentEvent e, char c) {
        String s = null;
        try {
            s = this.editor.getText(e.getOffset(), e.getLength());
            for (int i = 0; i < e.getLength(); ++i) {
                if (s.charAt(i) != c) continue;
                return true;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private String trimContinuations(String text) {
        int i;
        while ((i = text.indexOf("\\\n")) >= 0) {
            text = text.substring(0, i) + text.substring(i + 2, text.length());
        }
        return text;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        CommandProcessorPanel panel = new CommandProcessorPanel(null);
        frame.getContentPane().add((Component)panel, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(500, 500);
        frame.setVisible(true);
        panel.requestFocus();
    }
}

