/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthParameters {
    public static final String DEFAULT_JOSM_CONSUMER_KEY = "AdCRxTpvnbmfV8aPqrTLyA";
    public static final String DEFAULT_JOSM_CONSUMER_SECRET = "XmYOiGY9hApytcBC3xCec3e28QBqOWz5g6DSb5UpE";
    public static final String DEFAULT_REQUEST_TOKEN_URL = "http://www.openstreetmap.org/oauth/request_token";
    public static final String DEFAULT_ACCESS_TOKEN_URL = "http://www.openstreetmap.org/oauth/access_token";
    public static final String DEFAULT_AUTHORISE_URL = "http://www.openstreetmap.org/oauth/authorize";
    private String consumerKey;
    private String consumerSecret;
    private String requestTokenUrl;
    private String accessTokenUrl;
    private String authoriseUrl;

    public static OAuthParameters createDefault() {
        OAuthParameters parameters = new OAuthParameters();
        parameters.setConsumerKey(DEFAULT_JOSM_CONSUMER_KEY);
        parameters.setConsumerSecret(DEFAULT_JOSM_CONSUMER_SECRET);
        parameters.setRequestTokenUrl(DEFAULT_REQUEST_TOKEN_URL);
        parameters.setAccessTokenUrl(DEFAULT_ACCESS_TOKEN_URL);
        parameters.setAuthoriseUrl(DEFAULT_AUTHORISE_URL);
        return parameters;
    }

    public static OAuthParameters createFromPreferences(Preferences pref) {
        boolean useDefault = pref.getBoolean("oauth.settings.use-default", true);
        if (useDefault) {
            return OAuthParameters.createDefault();
        }
        OAuthParameters parameters = new OAuthParameters();
        parameters.setConsumerKey(pref.get("oauth.settings.consumer-key", ""));
        parameters.setConsumerSecret(pref.get("oauth.settings.consumer-secret", ""));
        parameters.setRequestTokenUrl(pref.get("oauth.settings.request-token-url", ""));
        parameters.setAccessTokenUrl(pref.get("oauth.settings.access-token-url", ""));
        parameters.setAuthoriseUrl(pref.get("oauth.settings.authorise-url", ""));
        return parameters;
    }

    public static void clearPreferences(Preferences pref) {
        pref.put("oauth.settings.consumer-key", null);
        pref.put("oauth.settings.consumer-secret", null);
        pref.put("oauth.settings.request-token-url", null);
        pref.put("oauth.settings.access-token-url", null);
        pref.put("oauth.settings.authorise-url", null);
    }

    public OAuthParameters() {
    }

    public OAuthParameters(OAuthParameters other) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.consumerKey = other.consumerKey;
        this.consumerSecret = other.consumerSecret;
        this.accessTokenUrl = other.accessTokenUrl;
        this.requestTokenUrl = other.requestTokenUrl;
        this.authoriseUrl = other.authoriseUrl;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public void setRequestTokenUrl(String requestTokenUrl) {
        this.requestTokenUrl = requestTokenUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getAuthoriseUrl() {
        return this.authoriseUrl;
    }

    public void setAuthoriseUrl(String authoriseUrl) {
        this.authoriseUrl = authoriseUrl;
    }

    public OAuthConsumer buildConsumer() {
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.consumerKey, this.consumerSecret);
        return consumer;
    }

    public OAuthProvider buildProvider(OAuthConsumer consumer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(consumer, "consumer");
        return new DefaultOAuthProvider(this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl);
    }

    public void saveToPreferences(Preferences pref) {
        if (this.equals(OAuthParameters.createDefault())) {
            pref.put("oauth.settings.use-default", true);
            OAuthParameters.clearPreferences(pref);
            return;
        }
        pref.put("oauth.settings.use-default", false);
        pref.put("oauth.settings.consumer-key", this.consumerKey);
        pref.put("oauth.settings.consumer-secret", this.consumerSecret);
        pref.put("oauth.settings.request-token-url", this.requestTokenUrl);
        pref.put("oauth.settings.access-token-url", this.accessTokenUrl);
        pref.put("oauth.settings.authorise-url", this.authoriseUrl);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessTokenUrl == null ? 0 : this.accessTokenUrl.hashCode());
        result = 31 * result + (this.authoriseUrl == null ? 0 : this.authoriseUrl.hashCode());
        result = 31 * result + (this.consumerKey == null ? 0 : this.consumerKey.hashCode());
        result = 31 * result + (this.consumerSecret == null ? 0 : this.consumerSecret.hashCode());
        result = 31 * result + (this.requestTokenUrl == null ? 0 : this.requestTokenUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthParameters other = (OAuthParameters)obj;
        if (this.accessTokenUrl == null ? other.accessTokenUrl != null : !this.accessTokenUrl.equals(other.accessTokenUrl)) {
            return false;
        }
        if (this.authoriseUrl == null ? other.authoriseUrl != null : !this.authoriseUrl.equals(other.authoriseUrl)) {
            return false;
        }
        if (this.consumerKey == null ? other.consumerKey != null : !this.consumerKey.equals(other.consumerKey)) {
            return false;
        }
        if (this.consumerSecret == null ? other.consumerSecret != null : !this.consumerSecret.equals(other.consumerSecret)) {
            return false;
        }
        return !(this.requestTokenUrl == null ? other.requestTokenUrl != null : !this.requestTokenUrl.equals(other.requestTokenUrl));
    }
}

