/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetCacheTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public ChangesetCacheTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.setFont(UIManager.getFont("Table.font"));
        this.setToolTipText("");
    }

    protected void renderColors(boolean isSelected) {
        if (isSelected) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
    }

    protected void renderId(Changeset cs) {
        this.setText(Integer.toString(cs.getId()));
        this.setToolTipText("");
    }

    protected void renderUploadComment(Changeset cs) {
        String comment = cs.get("comment");
        if (comment == null || comment.trim().equals("")) {
            this.setText(I18n.trc("changeset.upload-comment", "empty"));
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
        } else {
            this.setText(comment);
            this.setToolTipText(comment);
            this.setFont(UIManager.getFont("Table.font"));
        }
    }

    protected void renderOpen(Changeset cs) {
        if (cs.isOpen()) {
            this.setText(I18n.trc("changeset.state", "Open"));
        } else {
            this.setText(I18n.trc("changeset.state", "Closed"));
        }
        this.setToolTipText("");
    }

    protected void renderUser(Changeset cs) {
        User user = cs.getUser();
        if (user == null || user.getName().trim().equals("")) {
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
            this.setText(I18n.tr("anonymous"));
        } else {
            this.setFont(UIManager.getFont("Table.font"));
            this.setText(user.getName());
            this.setToolTipText(user.getName());
        }
    }

    protected void renderDate(Date d) {
        if (d == null) {
            this.setText("");
        } else {
            this.setText(new SimpleDateFormat().format(d));
        }
        this.setToolTipText("");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.reset();
        this.renderColors(isSelected);
        Changeset cs = (Changeset)value;
        switch (column) {
            case 0: {
                this.renderId(cs);
                break;
            }
            case 1: {
                this.renderUploadComment(cs);
                break;
            }
            case 2: {
                this.renderOpen(cs);
                break;
            }
            case 3: {
                this.renderUser(cs);
                break;
            }
            case 4: {
                this.renderDate(cs.getCreatedAt());
                break;
            }
            case 5: {
                this.renderDate(cs.getClosedAt());
            }
        }
        return this;
    }
}

