/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlaceSelection
implements DownloadSelection {
    private static final String HISTORY_KEY = "download.places.history";
    private HistoryComboBox cbSearchExpression;
    private JButton btnSearch;
    private NamedResultTableModel model;
    private NamedResultTableColumnModel columnmodel;
    private JTable tblSearchResults;
    private DownloadDialog parent;
    private static final Server[] servers = new Server[]{new Server("Nominatim", "http://nominatim.openstreetmap.org/search?format=xml&q=", I18n.tr("Class Type"), I18n.tr("Bounds")), new Server("Namefinder", "http://gazetteer.openstreetmap.org/namefinder/search.xml?find=", I18n.tr("Near"), I18n.trc("placeselection", "Zoom"))};
    private final JComboBox server = new JComboBox<Server>(servers);

    protected JPanel buildSearchPanel() {
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new GridLayout(2, 2));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        lpanel.add(new JLabel(I18n.tr("Choose the server for searching:")));
        lpanel.add(this.server);
        String s = Main.pref.get("namefinder.server", PlaceSelection.servers[0].name);
        for (int i = 0; i < servers.length; ++i) {
            if (!PlaceSelection.servers[i].name.equals(s)) continue;
            this.server.setSelectedIndex(i);
        }
        lpanel.add(new JLabel(I18n.tr("Enter a place name to search for:")));
        this.cbSearchExpression = new HistoryComboBox();
        this.cbSearchExpression.setToolTipText(I18n.tr("Enter a place name to search for"));
        LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        this.cbSearchExpression.setPossibleItems(cmtHistory);
        lpanel.add(this.cbSearchExpression);
        panel.add((Component)lpanel, GBC.std().fill(2).insets(5, 5, 0, 5));
        SearchAction searchAction = new SearchAction();
        this.btnSearch = new JButton(searchAction);
        ((JTextField)this.cbSearchExpression.getEditor().getEditorComponent()).getDocument().addDocumentListener(searchAction);
        ((JTextField)this.cbSearchExpression.getEditor().getEditorComponent()).addActionListener(searchAction);
        panel.add((Component)this.btnSearch, GBC.eol().insets(5, 5, 0, 5));
        return panel;
    }

    public void addGui(DownloadDialog gui) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildSearchPanel(), "North");
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new NamedResultTableModel(selectionModel);
        this.columnmodel = new NamedResultTableColumnModel();
        this.tblSearchResults = new JTable(this.model, this.columnmodel);
        this.tblSearchResults.setSelectionModel(selectionModel);
        JScrollPane scrollPane = new JScrollPane(this.tblSearchResults);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        panel.add((Component)scrollPane, "Center");
        gui.addDownloadAreaSelector(panel, I18n.tr("Areas around places"));
        scrollPane.setPreferredSize(scrollPane.getPreferredSize());
        this.tblSearchResults.getSelectionModel().setSelectionMode(0);
        this.tblSearchResults.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        this.tblSearchResults.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    SearchResult sr = PlaceSelection.this.model.getSelectedSearchResult();
                    if (sr == null) {
                        return;
                    }
                    PlaceSelection.this.parent.startDownload(sr.getDownloadArea());
                }
            }
        });
        this.parent = gui;
    }

    public void setDownloadArea(Bounds area) {
        this.tblSearchResults.clearSelection();
    }

    static class NamedResultCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public NamedResultCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        protected void reset() {
            this.setText("");
            this.setIcon(null);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            }
        }

        protected String lineWrapDescription(String description) {
            StringBuffer ret = new StringBuffer();
            StringBuffer line = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(description, " ");
            while (tok.hasMoreElements()) {
                String t = tok.nextToken();
                if (line.length() == 0) {
                    line.append(t);
                    continue;
                }
                if (line.length() < 80) {
                    line.append(" ").append(t);
                    continue;
                }
                line.append(" ").append(t).append("<br>");
                ret.append(line);
                line = new StringBuffer();
            }
            ret.insert(0, "<html>");
            ret.append("</html>");
            return ret.toString();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.reset();
            this.renderColor(isSelected);
            if (value == null) {
                return this;
            }
            SearchResult sr = (SearchResult)value;
            switch (column) {
                case 0: {
                    this.setText(sr.name);
                    break;
                }
                case 1: {
                    this.setText(sr.info);
                    break;
                }
                case 2: {
                    this.setText(sr.nearestPlace);
                    break;
                }
                case 3: {
                    if (sr.bounds != null) {
                        this.setText(sr.bounds.toShortString(new DecimalFormat("0.000")));
                        break;
                    }
                    this.setText(sr.zoom != 0 ? Integer.toString(sr.zoom) : I18n.tr("unknown"));
                }
            }
            this.setToolTipText(this.lineWrapDescription(sr.description));
            return this;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent lse) {
            SearchResult r = PlaceSelection.this.model.getSelectedSearchResult();
            if (r != null) {
                PlaceSelection.this.parent.boundingBoxChanged(r.getDownloadArea(), PlaceSelection.this);
            }
        }
    }

    static class NamedResultTableColumnModel
    extends DefaultTableColumnModel {
        TableColumn col3 = null;
        TableColumn col4 = null;

        protected void createColumns() {
            TableColumn col = null;
            NamedResultCellRenderer renderer = new NamedResultCellRenderer();
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Name"));
            col.setResizable(true);
            col.setPreferredWidth(200);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("Type"));
            col.setResizable(true);
            col.setPreferredWidth(100);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            this.col3 = new TableColumn(2);
            this.col3.setHeaderValue(servers[0].thirdcol);
            this.col3.setResizable(true);
            this.col3.setPreferredWidth(100);
            this.col3.setCellRenderer(renderer);
            this.addColumn(this.col3);
            this.col4 = new TableColumn(3);
            this.col4.setHeaderValue(servers[0].fourthcol);
            this.col4.setResizable(true);
            this.col4.setPreferredWidth(50);
            this.col4.setCellRenderer(renderer);
            this.addColumn(this.col4);
        }

        public void setHeadlines(String third, String fourth) {
            this.col3.setHeaderValue(third);
            this.col4.setHeaderValue(fourth);
            this.fireColumnMarginChanged();
        }

        public NamedResultTableColumnModel() {
            this.createColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamedResultTableModel
    extends DefaultTableModel {
        private ArrayList<SearchResult> data = new ArrayList();
        private ListSelectionModel selectionModel;

        public NamedResultTableModel(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(row);
        }

        public void setData(List<SearchResult> data) {
            if (data == null) {
                this.data.clear();
            } else {
                this.data = new ArrayList<SearchResult>(data);
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public SearchResult getSelectedSearchResult() {
            if (this.selectionModel.getMinSelectionIndex() < 0) {
                return null;
            }
            return this.data.get(this.selectionModel.getMinSelectionIndex());
        }
    }

    class NameQueryTask
    extends PleaseWaitRunnable {
        private String searchExpression;
        private HttpURLConnection connection;
        private List<SearchResult> data;
        private boolean canceled;
        private Server useserver;
        private Exception lastException;

        public NameQueryTask(String searchExpression) {
            super(I18n.tr("Querying name server"), false);
            this.canceled = false;
            this.searchExpression = searchExpression;
            this.useserver = (Server)PlaceSelection.this.server.getSelectedItem();
            Main.pref.put("namefinder.server", this.useserver.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancel() {
            this.canceled = true;
            NameQueryTask nameQueryTask = this;
            synchronized (nameQueryTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
        }

        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            PlaceSelection.this.columnmodel.setHeadlines(this.useserver.thirdcol, this.useserver.fourthcol);
            PlaceSelection.this.model.setData(this.data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            String urlString = this.useserver.url + URLEncoder.encode(this.searchExpression, "UTF-8");
            try {
                this.getProgressMonitor().indeterminateSubTask(I18n.tr("Querying name server ..."));
                URL url = new URL(urlString);
                NameQueryTask nameQueryTask = this;
                synchronized (nameQueryTask) {
                    this.connection = (HttpURLConnection)url.openConnection();
                }
                this.connection.setConnectTimeout(15000);
                InputStream inputStream = this.connection.getInputStream();
                InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
                NameFinderResultParser parser = new NameFinderResultParser();
                SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)parser);
                this.data = parser.getResult();
            }
            catch (Exception e) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException ex = new OsmTransferException(e);
                ex.setUrl(urlString);
                this.lastException = ex;
            }
        }
    }

    class SearchAction
    extends AbstractAction
    implements DocumentListener {
        public SearchAction() {
            this.putValue("Name", I18n.tr("Search ..."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.putValue("ShortDescription", I18n.tr("Click to start searching for places"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled() || PlaceSelection.this.cbSearchExpression.getText().trim().length() == 0) {
                return;
            }
            PlaceSelection.this.cbSearchExpression.addCurrentItemToHistory();
            Main.pref.putCollection(PlaceSelection.HISTORY_KEY, PlaceSelection.this.cbSearchExpression.getHistory());
            NameQueryTask task = new NameQueryTask(PlaceSelection.this.cbSearchExpression.getText());
            Main.worker.submit(task);
        }

        protected void updateEnabledState() {
            this.setEnabled(PlaceSelection.this.cbSearchExpression.getText().trim().length() > 0);
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameFinderResultParser
    extends DefaultHandler {
        private SearchResult currentResult = null;
        private StringBuffer description = null;
        private int depth = 0;
        private List<SearchResult> data = new LinkedList<SearchResult>();

        private NameFinderResultParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ++this.depth;
            try {
                if (!qName.equals("searchresults")) {
                    if (qName.equals("named") && this.depth == 2) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = atts.getValue("name");
                        this.currentResult.info = atts.getValue("info");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info);
                        }
                        this.currentResult.lat = Double.parseDouble(atts.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(atts.getValue("lon"));
                        this.currentResult.zoom = Integer.parseInt(atts.getValue("zoom"));
                        this.data.add(this.currentResult);
                    } else if (qName.equals("description") && this.depth == 3) {
                        this.description = new StringBuffer();
                    } else if (qName.equals("named") && this.depth == 4) {
                        String info = atts.getValue("info");
                        if ("city".equals(info) || "town".equals(info) || "village".equals(info)) {
                            this.currentResult.nearestPlace = atts.getValue("name");
                        }
                    } else if (qName.equals("place") && atts.getValue("lat") != null) {
                        this.currentResult = new SearchResult();
                        this.currentResult.description = this.currentResult.name = atts.getValue("display_name");
                        this.currentResult.info = atts.getValue("class");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info);
                        }
                        this.currentResult.nearestPlace = I18n.tr(atts.getValue("type"));
                        this.currentResult.lat = Double.parseDouble(atts.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(atts.getValue("lon"));
                        String[] bbox = atts.getValue("boundingbox").split(",");
                        this.currentResult.bounds = new Bounds(new LatLon(Double.parseDouble(bbox[0]), Double.parseDouble(bbox[2])), new LatLon(Double.parseDouble(bbox[1]), Double.parseDouble(bbox[3])));
                        this.data.add(this.currentResult);
                    }
                }
            }
            catch (NumberFormatException x) {
                x.printStackTrace();
                throw new SAXException(x.getMessage(), x);
            }
            catch (NullPointerException x) {
                x.printStackTrace();
                throw new SAXException(I18n.tr("Null pointer exception, possibly some missing tags."), x);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (!qName.equals("searchresults") && qName.equals("description") && this.description != null) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        @Override
        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.description != null) {
                this.description.append(data, start, length);
            }
        }

        public List<SearchResult> getResult() {
            return this.data;
        }
    }

    private static class SearchResult {
        public String name;
        public String info;
        public String nearestPlace;
        public String description;
        public double lat;
        public double lon;
        public int zoom = 0;
        public Bounds bounds = null;

        private SearchResult() {
        }

        public Bounds getDownloadArea() {
            return this.bounds != null ? this.bounds : OsmUrlToBounds.positionToBounds(this.lat, this.lon, this.zoom);
        }
    }

    private static class Server {
        public String name;
        public String url;
        public String thirdcol;
        public String fourthcol;

        public String toString() {
            return this.name;
        }

        public Server(String n, String u, String t, String f) {
            this.name = n;
            this.url = u;
            this.thirdcol = t;
            this.fourthcol = f;
        }
    }
}

