/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSourceEditor
extends JPanel {
    private JTable tblActiveStyles;
    private ActiveStylesModel activeStylesModel;
    private JList lstAvailableStyles;
    private AvailableStylesListModel availableStylesModel;
    private JTable tblIconPaths = null;
    private IconPathTableModel iconPathsModel;
    private String pref;
    private String iconpref;
    private boolean stylesInitiallyLoaded;
    private String availableStylesUrl;

    public StyleSourceEditor(String stylesPreferencesKey, String iconsPreferenceKey, String availableStylesUrl) {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.activeStylesModel = new ActiveStylesModel(selectionModel);
        this.tblActiveStyles = new JTable(this.activeStylesModel);
        this.tblActiveStyles.putClientProperty("terminateEditOnFocusLost", true);
        this.tblActiveStyles.setSelectionModel(selectionModel);
        this.tblActiveStyles.setSelectionMode(2);
        this.tblActiveStyles.setTableHeader(null);
        this.tblActiveStyles.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(true));
        this.tblActiveStyles.setRowHeight(20);
        this.activeStylesModel.setActiveStyles(Main.pref.getCollection(stylesPreferencesKey, null));
        selectionModel = new DefaultListSelectionModel();
        this.availableStylesModel = new AvailableStylesListModel(selectionModel);
        this.lstAvailableStyles = new JList(this.availableStylesModel);
        this.lstAvailableStyles.setSelectionModel(selectionModel);
        this.lstAvailableStyles.setCellRenderer(new StyleSourceCellRenderer());
        this.availableStylesUrl = availableStylesUrl;
        this.pref = stylesPreferencesKey;
        this.iconpref = iconsPreferenceKey;
        JButton iconadd = null;
        JButton iconedit = null;
        JButton icondelete = null;
        if (iconsPreferenceKey != null) {
            selectionModel = new DefaultListSelectionModel();
            this.iconPathsModel = new IconPathTableModel(selectionModel);
            this.tblIconPaths = new JTable(this.iconPathsModel);
            this.tblIconPaths.setSelectionModel(selectionModel);
            this.tblIconPaths.setSelectionMode(2);
            this.tblIconPaths.setTableHeader(null);
            this.tblIconPaths.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(false));
            this.tblIconPaths.setRowHeight(20);
            this.iconPathsModel.setIconPaths(Main.pref.getCollection(iconsPreferenceKey, null));
            iconadd = new JButton(new NewIconPathAction());
            EditIconPathAction editIconPathAction = new EditIconPathAction();
            this.tblIconPaths.getSelectionModel().addListSelectionListener(editIconPathAction);
            iconedit = new JButton(editIconPathAction);
            RemoveIconPathAction removeIconPathAction = new RemoveIconPathAction();
            this.tblIconPaths.getSelectionModel().addListSelectionListener(removeIconPathAction);
            icondelete = new JButton(removeIconPathAction);
            this.tblIconPaths.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
            this.tblIconPaths.getActionMap().put("delete", removeIconPathAction);
        }
        JButton add = new JButton(new NewActiveStyleAction());
        EditActiveStyleAction editActiveStyleAction = new EditActiveStyleAction();
        this.tblActiveStyles.getSelectionModel().addListSelectionListener(editActiveStyleAction);
        JButton edit = new JButton(editActiveStyleAction);
        RemoveActiveStylesAction removeActiveStylesAction = new RemoveActiveStylesAction();
        this.tblActiveStyles.getSelectionModel().addListSelectionListener(removeActiveStylesAction);
        this.tblActiveStyles.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblActiveStyles.getActionMap().put("delete", removeActiveStylesAction);
        JButton delete = new JButton(removeActiveStylesAction);
        ActivateStylesAction activateStylesAction = new ActivateStylesAction();
        this.lstAvailableStyles.addListSelectionListener(activateStylesAction);
        JButton copy = new JButton(activateStylesAction);
        JButton update = new JButton(new ReloadStylesAction(availableStylesUrl));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(I18n.tr("Active styles")), GBC.eol().insets(5, 5, 5, 0));
        JScrollPane sp = new JScrollPane(this.tblActiveStyles);
        this.add((Component)sp, GBC.eol().insets(5, 0, 5, 0).fill(1));
        sp.setColumnHeaderView(null);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        this.add((Component)buttonPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)edit, GBC.std().insets(5, 5, 5, 0));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)copy, GBC.std().insets(0, 5, 5, 0));
        this.add((Component)new JLabel(I18n.tr("Available styles (from {0})", availableStylesUrl)), GBC.eol().insets(5, 5, 5, 0));
        this.add((Component)new JScrollPane(this.lstAvailableStyles), GBC.eol().insets(5, 0, 5, 0).fill(1));
        buttonPanel = new JPanel(new FlowLayout(0));
        this.add((Component)buttonPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
        buttonPanel.add((Component)update, GBC.std().insets(0, 5, 0, 0));
        if (this.tblIconPaths != null) {
            this.add((Component)new JLabel(I18n.tr("Icon paths")), GBC.eol().insets(5, -5, 5, 0));
            sp = new JScrollPane(this.tblIconPaths);
            this.add((Component)sp, GBC.eol().insets(5, 0, 5, 0).fill(1));
            sp.setColumnHeaderView(null);
            buttonPanel = new JPanel(new FlowLayout(0));
            this.add((Component)buttonPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
            buttonPanel.add(iconadd);
            buttonPanel.add(iconedit);
            buttonPanel.add(icondelete);
        }
    }

    public boolean hasActiveStylesChanged() {
        return !((Object)this.activeStylesModel.getStyles()).equals(Main.pref.getCollection(this.pref, Collections.<String>emptyList()));
    }

    public Collection<String> getActiveStyles() {
        return this.activeStylesModel.getStyles();
    }

    public void removeSource(String source) {
        this.activeStylesModel.remove(source);
    }

    public boolean finish() {
        boolean changed = false;
        List<String> activeStyles = this.activeStylesModel.getStyles();
        if (activeStyles.size() > 0) {
            if (Main.pref.putCollection(this.pref, activeStyles)) {
                changed = true;
            }
        } else if (Main.pref.putCollection(this.pref, null)) {
            changed = true;
        }
        if (this.tblIconPaths != null) {
            List<String> iconPaths = this.iconPathsModel.getIconPaths();
            if (!iconPaths.isEmpty()) {
                if (Main.pref.putCollection(this.iconpref, iconPaths)) {
                    changed = true;
                }
            } else if (Main.pref.putCollection(this.iconpref, null)) {
                changed = true;
            }
        }
        return changed;
    }

    protected void reloadAvailableStyles(String url) {
        Main.worker.submit(new StyleSourceLoader(url));
    }

    public void initiallyLoadAvailableStyles() {
        if (!this.stylesInitiallyLoaded) {
            this.reloadAvailableStyles(this.availableStylesUrl);
        }
        this.stylesInitiallyLoaded = true;
    }

    class FileOrUrlCellEditor
    extends JPanel
    implements TableCellEditor {
        private JTextField tfFileName;
        private CopyOnWriteArrayList<CellEditorListener> listeners;
        private String value;
        private JFileChooser fileChooser;
        private boolean isFile;

        protected JFileChooser getFileChooser() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                if (!this.isFile) {
                    this.fileChooser.setFileSelectionMode(1);
                }
            }
            return this.fileChooser;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.tfFileName = new JTextField();
            this.add((Component)this.tfFileName, gc);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
            this.add(new JButton(new LaunchFileChooserAction()));
            this.tfFileName.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    FileOrUrlCellEditor.this.tfFileName.selectAll();
                }
            });
        }

        public FileOrUrlCellEditor(boolean isFile) {
            this.isFile = isFile;
            this.listeners = new CopyOnWriteArrayList();
            this.build();
        }

        public void addCellEditorListener(CellEditorListener l) {
            if (l != null) {
                this.listeners.addIfAbsent(l);
            }
        }

        protected void fireEditingCanceled() {
            for (CellEditorListener l : this.listeners) {
                l.editingCanceled(new ChangeEvent(this));
            }
        }

        protected void fireEditingStopped() {
            for (CellEditorListener l : this.listeners) {
                l.editingStopped(new ChangeEvent(this));
            }
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            this.value = this.tfFileName.getText();
            this.fireEditingStopped();
            return true;
        }

        public void setInitialValue(String initialValue) {
            this.value = initialValue;
            if (initialValue == null) {
                this.tfFileName.setText("");
            } else {
                this.tfFileName.setText(initialValue);
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setInitialValue((String)value);
            this.tfFileName.selectAll();
            return this;
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            public LaunchFileChooserAction() {
                this.putValue("Name", "...");
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file"));
            }

            protected void prepareFileChooser(String url, JFileChooser fc) {
                if (url == null || url.trim().length() == 0) {
                    return;
                }
                URL sourceUrl = null;
                try {
                    sourceUrl = new URL(url);
                }
                catch (MalformedURLException e) {
                    File f = new File(url);
                    if (f.isFile()) {
                        f = f.getParentFile();
                    }
                    if (f != null) {
                        fc.setCurrentDirectory(f);
                    }
                    return;
                }
                if (sourceUrl.getProtocol().startsWith("file")) {
                    File f = new File(sourceUrl.getPath());
                    if (f.isFile()) {
                        f = f.getParentFile();
                    }
                    if (f != null) {
                        fc.setCurrentDirectory(f);
                    }
                }
            }

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = FileOrUrlCellEditor.this.getFileChooser();
                this.prepareFileChooser(FileOrUrlCellEditor.this.tfFileName.getText(), fc);
                int ret = fc.showOpenDialog(JOptionPane.getFrameForComponent(StyleSourceEditor.this));
                if (ret != 0) {
                    return;
                }
                FileOrUrlCellEditor.this.tfFileName.setText(fc.getSelectedFile().toString());
            }
        }
    }

    class StyleSourceLoader
    extends PleaseWaitRunnable {
        private String url;
        private BufferedReader reader;
        private boolean canceled;

        public StyleSourceLoader(String url) {
            super(I18n.tr("Loading style sources from ''{0}''", url));
            this.url = url;
        }

        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected void finish() {
        }

        protected void warn(Exception e) {
            String emsg = e.getMessage() != null ? e.getMessage() : e.toString();
            emsg = emsg.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            String msg = I18n.tr("<html>Failed to load the list of style sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>", this.url, emsg);
            HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Error"), 0, HelpUtil.ht("Preferences/Styles#FailedToLoadStyleSources"));
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            LinkedList<StyleSourceInfo> styles = new LinkedList<StyleSourceInfo>();
            String lang = LanguageInfo.getLanguageCodeXML();
            try {
                String line;
                InputStreamReader r;
                StyleSourceInfo i = new StyleSourceInfo("elemstyles.xml", "resource://data/elemstyles.xml");
                i.shortdescription = I18n.tr("Internal style");
                i.description = I18n.tr("Internal style to be used as base for runtime switchable overlay styles");
                styles.add(i);
                MirroredInputStream stream = new MirroredInputStream(this.url);
                try {
                    r = new InputStreamReader((InputStream)stream, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    r = new InputStreamReader(stream);
                }
                this.reader = new BufferedReader(r);
                StyleSourceInfo last = null;
                while ((line = this.reader.readLine()) != null && !this.canceled) {
                    Matcher m;
                    if (line.trim().equals("")) continue;
                    if (line.startsWith("\t")) {
                        m = Pattern.compile("^\t([^:]+): *(.+)$").matcher(line);
                        if (!m.matches()) {
                            System.err.println(I18n.tr("Warning: illegal format of entry in style list ''{0}''. Got ''{1}''", this.url, line));
                            continue;
                        }
                        if (last == null) continue;
                        String key = m.group(1);
                        String value = m.group(2);
                        if ("author".equals(key) && last.author == null) {
                            last.author = value;
                            continue;
                        }
                        if ("version".equals(key)) {
                            last.version = value;
                            continue;
                        }
                        if ("link".equals(key) && last.link == null) {
                            last.link = value;
                            continue;
                        }
                        if ("description".equals(key) && last.description == null) {
                            last.description = value;
                            continue;
                        }
                        if ("shortdescription".equals(key) && last.shortdescription == null) {
                            last.shortdescription = value;
                            continue;
                        }
                        if ((lang + "author").equals(key)) {
                            last.author = value;
                            continue;
                        }
                        if ((lang + "link").equals(key)) {
                            last.link = value;
                            continue;
                        }
                        if ((lang + "description").equals(key)) {
                            last.description = value;
                            continue;
                        }
                        if (!(lang + "shortdescription").equals(key)) continue;
                        last.shortdescription = value;
                        continue;
                    }
                    last = null;
                    m = Pattern.compile("^(.+);(.+)$").matcher(line);
                    if (m.matches()) {
                        last = new StyleSourceInfo(m.group(1), m.group(2));
                        styles.add(last);
                        continue;
                    }
                    System.err.println(I18n.tr("Warning: illegal format of entry in style list ''{0}''. Got ''{1}''", this.url, line));
                }
            }
            catch (Exception e) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException ex = new OsmTransferException(e);
                ex.setUrl(this.url);
                this.warn(ex);
                return;
            }
            StyleSourceEditor.this.availableStylesModel.setStyleSources(styles);
        }
    }

    static class StyleSourceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        StyleSourceCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setToolTipText(((StyleSourceInfo)value).getTooltip());
            return this;
        }
    }

    class EditIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditIconPathAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the selected icon path"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblIconPaths.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            int row = StyleSourceEditor.this.tblIconPaths.getSelectedRow();
            StyleSourceEditor.this.tblIconPaths.editCellAt(row, 0);
        }
    }

    class RemoveIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveIconPathAction() {
            this.putValue("Name", I18n.tr("Remove"));
            this.putValue("ShortDescription", I18n.tr("Remove the selected icon paths"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblIconPaths.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            StyleSourceEditor.this.iconPathsModel.removeSelected();
        }
    }

    class NewIconPathAction
    extends AbstractAction {
        public NewIconPathAction() {
            this.putValue("Name", I18n.tr("New"));
            this.putValue("ShortDescription", I18n.tr("Add a new icon path"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent e) {
            StyleSourceEditor.this.iconPathsModel.addPath("");
            StyleSourceEditor.this.tblIconPaths.editCellAt(StyleSourceEditor.this.iconPathsModel.getRowCount() - 1, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IconPathTableModel
    extends AbstractTableModel {
        private ArrayList<String> data;
        private DefaultListSelectionModel selectionModel;

        public IconPathTableModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.data = new ArrayList();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.updatePath(rowIndex, (String)aValue);
        }

        public void setIconPaths(Collection<String> styles) {
            this.data.clear();
            if (styles != null) {
                this.data.addAll(styles);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addPath(String path) {
            if (path == null) {
                return;
            }
            this.data.add(path);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(path);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void updatePath(int pos, String path) {
            if (path == null) {
                return;
            }
            if (pos < 0 || pos >= this.getRowCount()) {
                return;
            }
            this.data.set(pos, path);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(path);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void removeSelected() {
            Iterator<String> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.equals("") && o2.equals("")) {
                        return 0;
                    }
                    if (o1.equals("")) {
                        return 1;
                    }
                    if (o2.equals("")) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }

        public List<String> getIconPaths() {
            return new ArrayList<String>(this.data);
        }
    }

    class ReloadStylesAction
    extends AbstractAction {
        private String url;

        public ReloadStylesAction(String url) {
            this.putValue("Name", I18n.tr("Reload"));
            this.putValue("ShortDescription", I18n.tr("Reloads the list of available styles from ''{0}''", url));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.url = url;
        }

        public void actionPerformed(ActionEvent e) {
            MirroredInputStream.cleanup(this.url);
            StyleSourceEditor.this.reloadAvailableStyles(this.url);
        }
    }

    class ActivateStylesAction
    extends AbstractAction
    implements ListSelectionListener {
        public ActivateStylesAction() {
            this.putValue("Name", I18n.tr("Activate"));
            this.putValue("ShortDescription", I18n.tr("Add the selected available styles to the list of active styles"));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "activatestyle"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.lstAvailableStyles.getSelectedIndices().length > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            List<StyleSourceInfo> styleSources = StyleSourceEditor.this.availableStylesModel.getSelected();
            StyleSourceEditor.this.activeStylesModel.addStylesFromSources(styleSources);
        }
    }

    class EditActiveStyleAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditActiveStyleAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the filename or URL for the selected active style"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblActiveStyles.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            int pos = StyleSourceEditor.this.tblActiveStyles.getSelectedRow();
            StyleSourceEditor.this.tblActiveStyles.editCellAt(pos, 0);
        }
    }

    class RemoveActiveStylesAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveActiveStylesAction() {
            this.putValue("Name", I18n.tr("Remove"));
            this.putValue("ShortDescription", I18n.tr("Remove the selected styles from the list of active styles"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblActiveStyles.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            StyleSourceEditor.this.activeStylesModel.removeSelected();
        }
    }

    class NewActiveStyleAction
    extends AbstractAction {
        public NewActiveStyleAction() {
            this.putValue("Name", I18n.tr("New"));
            this.putValue("ShortDescription", I18n.tr("Add a filename or an URL of an active style"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent e) {
            StyleSourceEditor.this.activeStylesModel.addStyle("");
            StyleSourceEditor.this.tblActiveStyles.requestFocusInWindow();
            StyleSourceEditor.this.tblActiveStyles.editCellAt(StyleSourceEditor.this.activeStylesModel.getRowCount() - 1, 0);
        }
    }

    public static class StyleSourceInfo {
        String version;
        String name;
        String url;
        String author;
        String link;
        String description;
        String shortdescription;

        public StyleSourceInfo(String name, String url) {
            this.name = name;
            this.url = url;
            this.shortdescription = null;
            this.description = null;
            this.link = null;
            this.author = null;
            this.version = null;
        }

        public String getName() {
            return this.shortdescription == null ? this.name : this.shortdescription;
        }

        public String getTooltip() {
            String s = I18n.tr("Short Description: {0}", this.getName()) + "<br>" + I18n.tr("URL: {0}", this.url);
            if (this.author != null) {
                s = s + "<br>" + I18n.tr("Author: {0}", this.author);
            }
            if (this.link != null) {
                s = s + "<br>" + I18n.tr("Webpage: {0}", this.link);
            }
            if (this.description != null) {
                s = s + "<br>" + I18n.tr("Description: {0}", this.description);
            }
            if (this.version != null) {
                s = s + "<br>" + I18n.tr("Version: {0}", this.version);
            }
            return "<html>" + s + "</html>";
        }

        public String toString() {
            return this.getName() + " (" + this.url + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActiveStylesModel
    extends AbstractTableModel {
        private ArrayList<String> data;
        private DefaultListSelectionModel selectionModel;

        public ActiveStylesModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.data = new ArrayList();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.updateStyle(rowIndex, (String)aValue);
        }

        public void setActiveStyles(Collection<String> styles) {
            this.data.clear();
            if (styles != null) {
                this.data.addAll(styles);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addStyle(String style) {
            if (style == null) {
                return;
            }
            this.data.add(style);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(style);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void updateStyle(int pos, String style) {
            if (style == null) {
                return;
            }
            if (pos < 0 || pos >= this.getRowCount()) {
                return;
            }
            this.data.set(pos, style);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(style);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void removeSelected() {
            Iterator<String> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireTableDataChanged();
        }

        public void remove(String source) {
            this.data.remove(source);
            this.fireTableDataChanged();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.equals("") && o2.equals("")) {
                        return 0;
                    }
                    if (o1.equals("")) {
                        return 1;
                    }
                    if (o2.equals("")) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }

        public void addStylesFromSources(List<StyleSourceInfo> sources) {
            if (sources == null) {
                return;
            }
            for (StyleSourceInfo info : sources) {
                this.data.add(info.url);
            }
            this.sort();
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (StyleSourceInfo info : sources) {
                int pos = this.data.indexOf(info.url);
                if (pos < 0) continue;
                this.selectionModel.addSelectionInterval(pos, pos);
            }
        }

        public List<String> getStyles() {
            return new ArrayList<String>(this.data);
        }

        public String getStyle(int pos) {
            return this.data.get(pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AvailableStylesListModel
    extends DefaultListModel {
        private ArrayList<StyleSourceInfo> data = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public AvailableStylesListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public void setStyleSources(List<StyleSourceInfo> styleSources) {
            this.data.clear();
            if (styleSources != null) {
                this.data.addAll(styleSources);
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        @Override
        public Object getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public void deleteSelected() {
            Iterator<StyleSourceInfo> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        public List<StyleSourceInfo> getSelected() {
            ArrayList<StyleSourceInfo> ret = new ArrayList<StyleSourceInfo>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ret.add(this.data.get(i));
            }
            return ret;
        }
    }
}

