/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.NamedObject;
import com.sun.jmx.mbeanserver.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

public class Repository {
    private final Map<String, Map<String, NamedObject>> domainTb;
    private volatile int nbElements = 0;
    private final String domain;
    private final ReentrantReadWriteLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllMatching(Map<String, NamedObject> map, Set<NamedObject> set, ObjectNamePattern objectNamePattern) {
        Map<String, NamedObject> map2 = map;
        synchronized (map2) {
            for (NamedObject namedObject : map.values()) {
                ObjectName objectName = namedObject.getName();
                if (!objectNamePattern.matchKeys(objectName)) continue;
                set.add(namedObject);
            }
        }
    }

    private void addNewDomMoi(DynamicMBean dynamicMBean, String string, ObjectName objectName, RegistrationContext registrationContext) {
        HashMap<String, NamedObject> hashMap = new HashMap<String, NamedObject>();
        String string2 = objectName.getCanonicalKeyPropertyListString();
        this.addMoiToTb(dynamicMBean, objectName, string2, hashMap, registrationContext);
        this.domainTb.put(string, hashMap);
        ++this.nbElements;
    }

    private void registering(RegistrationContext registrationContext) {
        if (registrationContext == null) {
            return;
        }
        try {
            registrationContext.registering();
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw runtimeOperationsException;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeOperationsException(runtimeException);
        }
    }

    private void unregistering(RegistrationContext registrationContext, ObjectName objectName) {
        if (registrationContext == null) {
            return;
        }
        try {
            registrationContext.unregistered();
        }
        catch (Exception exception) {
            JmxProperties.MBEANSERVER_LOGGER.log(Level.FINE, "Unexpected exception while unregistering " + objectName, exception);
        }
    }

    private void addMoiToTb(DynamicMBean dynamicMBean, ObjectName objectName, String string, Map<String, NamedObject> map, RegistrationContext registrationContext) {
        this.registering(registrationContext);
        map.put(string, new NamedObject(objectName, dynamicMBean));
    }

    private NamedObject retrieveNamedObject(ObjectName objectName) {
        Map<String, NamedObject> map;
        if (objectName.isPattern()) {
            return null;
        }
        String string = objectName.getDomain().intern();
        if (string.length() == 0) {
            string = this.domain;
        }
        if ((map = this.domainTb.get(string)) == null) {
            return null;
        }
        return map.get(objectName.getCanonicalKeyPropertyListString());
    }

    public Repository(String string) {
        this(string, true);
    }

    public Repository(String string, boolean bl) {
        this.lock = new ReentrantReadWriteLock(bl);
        this.domainTb = new HashMap<String, Map<String, NamedObject>>(5);
        this.domain = string != null && string.length() != 0 ? string.intern() : "DefaultDomain";
        this.domainTb.put(this.domain, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        ArrayList<String> arrayList;
        this.lock.readLock().lock();
        try {
            arrayList = new ArrayList<String>(this.domainTb.size());
            for (Map.Entry<String, Map<String, NamedObject>> entry : this.domainTb.entrySet()) {
                Map<String, NamedObject> map = entry.getValue();
                if (map == null || map.size() == 0) continue;
                arrayList.add(entry.getKey());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMBean(DynamicMBean dynamicMBean, ObjectName objectName, RegistrationContext registrationContext) throws InstanceAlreadyExistsException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "addMBean", "name = " + objectName);
        }
        String string = objectName.getDomain().intern();
        boolean bl = false;
        if (string.length() == 0) {
            objectName = Util.newObjectName(this.domain + objectName.toString());
        }
        if (string == this.domain) {
            bl = true;
            string = this.domain;
        } else {
            bl = false;
        }
        if (objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: cannot add mbean for pattern name " + objectName.toString()));
        }
        this.lock.writeLock().lock();
        try {
            if (!bl && string.equals("JMImplementation") && this.domainTb.containsKey("JMImplementation")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Repository: domain name cannot be JMImplementation"));
            }
            Map<String, NamedObject> map = this.domainTb.get(string);
            if (map == null) {
                this.addNewDomMoi(dynamicMBean, string, objectName, registrationContext);
                return;
            }
            String string2 = objectName.getCanonicalKeyPropertyListString();
            NamedObject namedObject = map.get(string2);
            if (namedObject != null) {
                throw new InstanceAlreadyExistsException(objectName.toString());
            }
            ++this.nbElements;
            this.addMoiToTb(dynamicMBean, objectName, string2, map, registrationContext);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ObjectName objectName) {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "contains", " name = " + objectName);
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.retrieveNamedObject(objectName) != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicMBean retrieve(ObjectName objectName) {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "retrieve", "name = " + objectName);
        }
        this.lock.readLock().lock();
        try {
            NamedObject namedObject = this.retrieveNamedObject(objectName);
            if (namedObject == null) {
                DynamicMBean dynamicMBean = null;
                return dynamicMBean;
            }
            DynamicMBean dynamicMBean = namedObject.getObject();
            return dynamicMBean;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObject> query(ObjectName objectName, QueryExp queryExp) {
        HashSet<NamedObject> hashSet = new HashSet<NamedObject>();
        ObjectName objectName2 = objectName == null || objectName.getCanonicalName().length() == 0 || objectName.equals(ObjectName.WILDCARD) ? ObjectName.WILDCARD : objectName;
        this.lock.readLock().lock();
        try {
            ObjectNamePattern objectNamePattern;
            if (!objectName2.isPattern()) {
                NamedObject namedObject = this.retrieveNamedObject(objectName2);
                if (namedObject != null) {
                    hashSet.add(namedObject);
                }
                HashSet<NamedObject> hashSet2 = hashSet;
                return hashSet2;
            }
            if (objectName2 == ObjectName.WILDCARD) {
                for (Map<String, NamedObject> map : this.domainTb.values()) {
                    hashSet.addAll(map.values());
                }
                HashSet<NamedObject> hashSet3 = hashSet;
                return hashSet3;
            }
            String string = objectName2.getCanonicalKeyPropertyListString();
            boolean bl = string.length() == 0;
            ObjectNamePattern objectNamePattern2 = objectNamePattern = bl ? null : new ObjectNamePattern(objectName2);
            if (objectName2.getDomain().length() == 0) {
                Map<String, NamedObject> map = this.domainTb.get(this.domain);
                if (bl) {
                    hashSet.addAll(map.values());
                } else {
                    this.addAllMatching(map, hashSet, objectNamePattern);
                }
                HashSet<NamedObject> hashSet4 = hashSet;
                return hashSet4;
            }
            if (!objectName2.isDomainPattern()) {
                Map<String, NamedObject> map = this.domainTb.get(objectName2.getDomain());
                if (map == null) {
                    Set<NamedObject> set = Collections.emptySet();
                    return set;
                }
                if (bl) {
                    hashSet.addAll(map.values());
                } else {
                    this.addAllMatching(map, hashSet, objectNamePattern);
                }
                HashSet<NamedObject> hashSet5 = hashSet;
                return hashSet5;
            }
            String string2 = objectName2.getDomain();
            for (String string3 : this.domainTb.keySet()) {
                if (!Util.wildmatch(string3, string2)) continue;
                Map<String, NamedObject> map = this.domainTb.get(string3);
                if (bl) {
                    hashSet.addAll(map.values());
                    continue;
                }
                this.addAllMatching(map, hashSet, objectNamePattern);
            }
            HashSet<NamedObject> hashSet6 = hashSet;
            return hashSet6;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ObjectName objectName, RegistrationContext registrationContext) throws InstanceNotFoundException {
        String string;
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, Repository.class.getName(), "remove", "name = " + objectName);
        }
        if ((string = objectName.getDomain().intern()).length() == 0) {
            string = this.domain;
        }
        this.lock.writeLock().lock();
        try {
            Map<String, NamedObject> map = this.domainTb.get(string);
            if (map == null) {
                throw new InstanceNotFoundException(objectName.toString());
            }
            if (map.remove(objectName.getCanonicalKeyPropertyListString()) == null) {
                throw new InstanceNotFoundException(objectName.toString());
            }
            --this.nbElements;
            if (map.isEmpty()) {
                this.domainTb.remove(string);
                if (string == this.domain) {
                    this.domainTb.put(this.domain, new HashMap());
                }
            }
            this.unregistering(registrationContext, objectName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Integer getCount() {
        return this.nbElements;
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    private static final class ObjectNamePattern {
        private final String[] keys;
        private final String[] values;
        private final String properties;
        private final boolean isPropertyListPattern;
        private final boolean isPropertyValuePattern;
        public final ObjectName pattern;

        public ObjectNamePattern(ObjectName objectName) {
            this(objectName.isPropertyListPattern(), objectName.isPropertyValuePattern(), objectName.getCanonicalKeyPropertyListString(), objectName.getKeyPropertyList(), objectName);
        }

        ObjectNamePattern(boolean bl, boolean bl2, String string, Map<String, String> map, ObjectName objectName) {
            this.isPropertyListPattern = bl;
            this.isPropertyValuePattern = bl2;
            this.properties = string;
            int n = map.size();
            this.keys = new String[n];
            this.values = new String[n];
            int n2 = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.keys[n2] = entry.getKey();
                this.values[n2] = entry.getValue();
                ++n2;
            }
            this.pattern = objectName;
        }

        public boolean matchKeys(ObjectName objectName) {
            if (this.isPropertyValuePattern && !this.isPropertyListPattern && objectName.getKeyPropertyList().size() != this.keys.length) {
                return false;
            }
            if (this.isPropertyValuePattern || this.isPropertyListPattern) {
                for (int i = this.keys.length - 1; i >= 0; --i) {
                    String string = objectName.getKeyProperty(this.keys[i]);
                    if (string == null) {
                        return false;
                    }
                    if (this.isPropertyValuePattern && this.pattern.isPropertyValuePattern(this.keys[i])) {
                        if (Util.wildmatch(string, this.values[i])) continue;
                        return false;
                    }
                    if (string.equals(this.values[i])) continue;
                    return false;
                }
                return true;
            }
            String string = objectName.getCanonicalKeyPropertyListString();
            String string2 = this.properties;
            return string.equals(string2);
        }
    }

    public static interface RegistrationContext {
        public void registering();

        public void unregistered();
    }
}

