/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

class AdapterMethodHandle
extends BoundMethodHandle {
    private final int conversion;
    static final int MAX_ARG_ROTATION = 1;

    private AdapterMethodHandle(MethodHandle methodHandle, MethodType methodType, long l, Object object) {
        super(methodType, object, methodType.parameterSlotDepth(1 + AdapterMethodHandle.convArgPos(l)));
        this.conversion = AdapterMethodHandle.convCode(l);
        MethodHandleNatives.init(this, methodHandle, AdapterMethodHandle.convArgPos(l));
    }

    private AdapterMethodHandle(MethodHandle methodHandle, MethodType methodType, long l) {
        this(methodHandle, methodType, l, (Object)null);
    }

    int getConversion() {
        return this.conversion;
    }

    static boolean canPairwiseConvert(MethodType methodType, MethodType methodType2, int n) {
        int n2 = methodType.parameterCount();
        if (n2 != methodType2.parameterCount()) {
            return false;
        }
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = methodType2.returnType();
        if (!VerifyType.isNullConversion(clazz2, clazz)) {
            if (!AdapterMethodHandle.convOpSupported(10)) {
                return false;
            }
            if (!AdapterMethodHandle.canConvertArgument(clazz2, clazz, n)) {
                return false;
            }
        }
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz3;
            Class<?> clazz4 = methodType.parameterType(i);
            if (AdapterMethodHandle.canConvertArgument(clazz4, clazz3 = methodType2.parameterType(i), n)) continue;
            return false;
        }
        return true;
    }

    static boolean canConvertArgument(Class<?> clazz, Class<?> clazz2, int n) {
        if (VerifyType.isNullConversion(clazz, clazz2)) {
            return true;
        }
        if (AdapterMethodHandle.convOpSupported(10)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz2.isPrimitive()) {
                return AdapterMethodHandle.canPrimCast(clazz, clazz2);
            }
            return AdapterMethodHandle.canBoxArgument(clazz, clazz2);
        }
        if (clazz2.isPrimitive()) {
            return AdapterMethodHandle.canUnboxArgument(clazz, clazz2, n);
        }
        return true;
    }

    static MethodHandle makePairwiseConvert(MethodType methodType, MethodHandle methodHandle, int n) {
        MethodHandle methodHandle2;
        Class<?> clazz;
        Class<?> clazz2;
        int n2;
        MethodType methodType2 = methodHandle.type();
        if (methodType == methodType2) {
            return methodHandle;
        }
        if (!AdapterMethodHandle.canPairwiseConvert(methodType, methodType2, n)) {
            return null;
        }
        for (n2 = methodType.parameterCount() - 1; n2 >= 0 && AdapterMethodHandle.isTrivialConversion(clazz2 = methodType.parameterType(n2), clazz = methodType2.parameterType(n2), n); --n2) {
        }
        clazz2 = methodType.returnType();
        clazz = methodType2.returnType();
        boolean bl = !AdapterMethodHandle.isTrivialConversion(clazz, clazz2, n);
        MethodHandle methodHandle3 = methodHandle;
        MethodType methodType3 = methodType2;
        for (int i = 0; i <= n2; ++i) {
            Class<?> clazz3;
            Class<?> clazz4 = methodType.parameterType(i);
            if (AdapterMethodHandle.isTrivialConversion(clazz4, clazz3 = methodType3.parameterType(i), n)) continue;
            methodType3 = methodType3.changeParameterType(i, clazz4);
            if (i == n2) {
                MethodType methodType4 = methodType;
                if (bl) {
                    methodType4 = methodType4.changeReturnType(clazz);
                }
                assert (VerifyType.isNullConversion(methodType4, methodType3));
                methodType3 = methodType4;
            }
            methodHandle2 = clazz4.isPrimitive() ? (clazz3.isPrimitive() ? AdapterMethodHandle.makePrimCast(methodType3, methodHandle3, i, clazz3) : AdapterMethodHandle.makeBoxArgument(methodType3, methodHandle3, i, clazz4)) : (clazz3.isPrimitive() ? AdapterMethodHandle.makeUnboxArgument(methodType3, methodHandle3, i, clazz3, n) : AdapterMethodHandle.makeCheckCast(methodType3, methodHandle3, i, clazz3));
            assert (methodHandle2 != null) : Arrays.asList(clazz4, clazz3, methodType3, methodHandle3, i, methodHandle, methodType);
            assert (methodHandle2.type() == methodType3);
            methodHandle3 = methodHandle2;
        }
        if (bl) {
            methodHandle2 = AdapterMethodHandle.makeReturnConversion(methodHandle3, clazz, clazz2);
            assert (methodHandle2 != null);
            methodHandle3 = methodHandle2;
        }
        if (methodHandle3.type() != methodType) {
            methodHandle2 = AdapterMethodHandle.makeRetypeOnly(methodType, methodHandle3);
            assert (methodHandle2 != null);
            methodHandle3 = methodHandle2;
            assert (n2 == -1 || bl);
        }
        assert (methodHandle3.type() == methodType);
        return methodHandle3;
    }

    private static boolean isTrivialConversion(Class<?> clazz, Class<?> clazz2, int n) {
        boolean bl;
        if (clazz == clazz2 || clazz2 == Void.TYPE) {
            return true;
        }
        if (!VerifyType.isNullConversion(clazz, clazz2)) {
            return false;
        }
        if (n > 1) {
            return true;
        }
        boolean bl2 = clazz.isPrimitive();
        if (bl2 != (bl = clazz2.isPrimitive())) {
            return false;
        }
        if (bl2) {
            return Wrapper.forPrimitiveType(clazz2).isConvertibleFrom(Wrapper.forPrimitiveType(clazz));
        }
        return clazz2.isAssignableFrom(clazz);
    }

    private static MethodHandle makeReturnConversion(MethodHandle methodHandle, Class<?> clazz, Class<?> clazz2) {
        MethodHandle methodHandle2;
        if (clazz == Void.TYPE) {
            Object object = Wrapper.forBasicType(clazz2).zero();
            methodHandle2 = MethodHandles.constant(clazz2, object);
        } else {
            MethodType methodType = MethodType.methodType(clazz2, clazz);
            methodHandle2 = MethodHandles.identity(clazz2).asType(methodType);
        }
        if (!AdapterMethodHandle.canCollectArguments(methodHandle2.type(), methodHandle.type(), 0, false)) {
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            throw new InternalError("NYI");
        }
        return AdapterMethodHandle.makeCollectArguments(methodHandle2, methodHandle, 0, false);
    }

    static MethodHandle makePermutation(MethodType methodType, MethodHandle methodHandle, int[] nArray) {
        MethodType methodType2 = methodHandle.type();
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n != i) {
                bl = false;
            }
            if (n >= 0 && n < methodType.parameterCount()) continue;
            nArray = new int[]{};
            break;
        }
        if (nArray.length != methodType2.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("bad permutation: " + Arrays.toString(nArray));
        }
        if (bl) {
            MethodHandle methodHandle2 = AdapterMethodHandle.makePairwiseConvert(methodType, methodHandle, 0);
            if (methodHandle2 == null) {
                throw MethodHandleStatics.newIllegalArgumentException("cannot convert pairwise: " + methodType);
            }
            return methodHandle2;
        }
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = methodType2.returnType();
        if (!VerifyType.isNullConversion(clazz2, clazz)) {
            throw MethodHandleStatics.newIllegalArgumentException("bad return conversion for " + methodType);
        }
        for (int i = 0; i < nArray.length; ++i) {
            Class<?> clazz3;
            int n = nArray[i];
            Class<?> clazz4 = methodType.parameterType(n);
            if (VerifyType.isNullConversion(clazz4, clazz3 = methodType2.parameterType(i))) continue;
            throw MethodHandleStatics.newIllegalArgumentException("bad argument #" + n + " conversion for " + methodType);
        }
        throw new UnsupportedOperationException("NYI");
    }

    private static byte basicType(Class<?> clazz) {
        if (clazz == null) {
            return 14;
        }
        switch (Wrapper.forBasicType(clazz)) {
            case BOOLEAN: {
                return 4;
            }
            case CHAR: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BYTE: {
                return 8;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case OBJECT: {
                return 12;
            }
            case VOID: {
                return 14;
            }
        }
        return 99;
    }

    private static int type2size(int n) {
        assert (n >= 4 && n <= 12);
        return n == 11 || n == 7 ? 2 : 1;
    }

    private static int type2size(Class<?> clazz) {
        return AdapterMethodHandle.type2size(AdapterMethodHandle.basicType(clazz));
    }

    private static long insertStackMove(int n) {
        long l = n * MethodHandleNatives.JVM_STACK_MOVE_UNIT;
        return (l & 0xFFFL) << 20;
    }

    static int extractStackMove(int n) {
        int n2 = n >> 20;
        return n2 / MethodHandleNatives.JVM_STACK_MOVE_UNIT;
    }

    static int extractStackMove(MethodHandle methodHandle) {
        if (methodHandle instanceof AdapterMethodHandle) {
            AdapterMethodHandle adapterMethodHandle = (AdapterMethodHandle)methodHandle;
            return AdapterMethodHandle.extractStackMove(adapterMethodHandle.getConversion());
        }
        return 0;
    }

    private static long makeConv(int n, int n2, int n3, int n4) {
        assert (n3 == (n3 & 0xF));
        assert (n4 == (n4 & 0xF));
        assert (n >= 2 && n <= 5 || n == 10);
        int n5 = AdapterMethodHandle.type2size(n4) - AdapterMethodHandle.type2size(n3);
        return (long)n2 << 32 | (long)n << 8 | (long)(n3 << 16) | (long)(n4 << 12) | AdapterMethodHandle.insertStackMove(n5);
    }

    private static long makeDupConv(int n, int n2, int n3) {
        assert (n == 8 || n == 9);
        int n4 = 0;
        int n5 = 0;
        return (long)n2 << 32 | (long)n << 8 | (long)(n4 << 16) | (long)(n5 << 12) | AdapterMethodHandle.insertStackMove(n3);
    }

    private static long makeSwapConv(int n, int n2, byte by, int n3, byte by2) {
        assert (n == 6 || n == 7);
        return (long)n2 << 32 | (long)n << 8 | (long)(by << 16) | (long)(by2 << 12) | (long)(n3 << 0);
    }

    private static long makeSpreadConv(int n, int n2, int n3, int n4, int n5) {
        assert (n == 11 || n == 10 || n == 12);
        return (long)n2 << 32 | (long)n << 8 | (long)(n3 << 16) | (long)(n4 << 12) | AdapterMethodHandle.insertStackMove(n5);
    }

    private static long makeConv(int n) {
        assert (n == 0 || n == 1);
        return 0xFFFFFFFF00000000L | (long)(n << 8);
    }

    private static int convCode(long l) {
        return (int)l;
    }

    private static int convArgPos(long l) {
        return (int)(l >>> 32);
    }

    private static boolean convOpSupported(int n) {
        assert (n >= 0 && n <= 14);
        return (1 << n & MethodHandleNatives.CONV_OP_IMPLEMENTED_MASK) != 0;
    }

    int conversionOp() {
        return (this.conversion & 0xF00) >> 8;
    }

    private static int diffTypes(MethodType methodType, MethodType methodType2, boolean bl) {
        int n = AdapterMethodHandle.diffReturnTypes(methodType, methodType2, bl);
        if (n != 0) {
            return n;
        }
        int n2 = methodType.parameterCount();
        if (n2 != methodType2.parameterCount()) {
            return -1;
        }
        n = AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n2, bl);
        return n;
    }

    private static int diffReturnTypes(MethodType methodType, MethodType methodType2, boolean bl) {
        Class<?> clazz = methodType2.returnType();
        Class<?> clazz2 = methodType.returnType();
        if ((!bl ? VerifyType.canPassUnchecked(clazz, clazz2) : VerifyType.canPassRaw(clazz, clazz2)) > 0) {
            return 0;
        }
        if (bl && !clazz.isPrimitive() && !clazz2.isPrimitive()) {
            return 0;
        }
        return -1;
    }

    private static int diffParamTypes(MethodType methodType, int n, MethodType methodType2, int n2, int n3, boolean bl) {
        assert (n3 >= 0);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Class<?> clazz = methodType.parameterType(n + i);
            Class<?> clazz2 = methodType2.parameterType(n2 + i);
            if ((!bl ? VerifyType.canPassUnchecked(clazz, clazz2) : VerifyType.canPassRaw(clazz, clazz2)) > 0) continue;
            if (n4 != 0) {
                return -1 - n4;
            }
            n4 = 1 + i;
        }
        return n4;
    }

    static boolean canRetypeOnly(MethodType methodType, MethodType methodType2) {
        return AdapterMethodHandle.canRetype(methodType, methodType2, false);
    }

    static boolean canRetypeRaw(MethodType methodType, MethodType methodType2) {
        return AdapterMethodHandle.canRetype(methodType, methodType2, true);
    }

    static boolean canRetype(MethodType methodType, MethodType methodType2, boolean bl) {
        if (!AdapterMethodHandle.convOpSupported(bl ? 1 : 0)) {
            return false;
        }
        int n = AdapterMethodHandle.diffTypes(methodType, methodType2, bl);
        assert (bl || n == 0 == VerifyType.isNullConversion(methodType, methodType2));
        return n == 0;
    }

    static MethodHandle makeRetypeOnly(MethodType methodType, MethodHandle methodHandle) {
        return AdapterMethodHandle.makeRetype(methodType, methodHandle, false);
    }

    static MethodHandle makeRetypeRaw(MethodType methodType, MethodHandle methodHandle) {
        return AdapterMethodHandle.makeRetype(methodType, methodHandle, true);
    }

    static MethodHandle makeRetype(MethodType methodType, MethodHandle methodHandle, boolean bl) {
        MethodType methodType2 = methodHandle.type();
        if (methodType2 == methodType) {
            return methodHandle;
        }
        if (!AdapterMethodHandle.canRetype(methodType, methodType2, bl)) {
            return null;
        }
        return new AdapterMethodHandle(methodHandle, methodType, AdapterMethodHandle.makeConv(bl ? 1 : 0));
    }

    static MethodHandle makeVarargsCollector(MethodHandle methodHandle, Class<?> clazz) {
        int n;
        MethodType methodType = methodHandle.type();
        if (methodType.parameterType(n = methodType.parameterCount() - 1) != clazz) {
            methodHandle = methodHandle.asType(methodType.changeParameterType(n, clazz));
        }
        methodHandle = methodHandle.asFixedArity();
        return new AsVarargsCollector(methodHandle, clazz);
    }

    static boolean canCheckCast(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(2)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        if (!AdapterMethodHandle.canCheckCast(clazz2, clazz) || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1 || n2 == 0;
    }

    static boolean canCheckCast(Class<?> clazz, Class<?> clazz2) {
        return !clazz.isPrimitive() && !clazz2.isPrimitive();
    }

    static MethodHandle makeCheckCast(MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.canCheckCast(methodType, methodHandle.type(), n, clazz)) {
            return null;
        }
        long l = AdapterMethodHandle.makeConv(2, n, 12, 12);
        return new AdapterMethodHandle(methodHandle, methodType, l, clazz);
    }

    static boolean canPrimCast(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(3)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        if (!AdapterMethodHandle.canPrimCast(clazz2, clazz) || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    static boolean canPrimCast(Class<?> clazz, Class<?> clazz2) {
        boolean bl;
        if (clazz == clazz2 || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            return false;
        }
        boolean bl2 = Wrapper.forPrimitiveType(clazz).isFloating();
        return !(bl2 | (bl = Wrapper.forPrimitiveType(clazz2).isFloating()));
    }

    static MethodHandle makePrimCast(MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        boolean bl;
        Class<?> clazz2 = methodType.parameterType(n);
        if (AdapterMethodHandle.canPrimCast(clazz2, clazz)) {
            return AdapterMethodHandle.makePrimCastOnly(methodType, methodHandle, n, clazz);
        }
        Class<?> clazz3 = clazz;
        boolean bl2 = Wrapper.forPrimitiveType(clazz2).isFloating();
        if (bl2 | (bl = Wrapper.forPrimitiveType(clazz3).isFloating())) {
            MethodHandle methodHandle2 = bl2 ? (clazz2 == Double.TYPE ? ValueConversions.convertFromDouble(clazz3) : ValueConversions.convertFromFloat(clazz3)) : (clazz3 == Double.TYPE ? ValueConversions.convertToDouble(clazz2) : ValueConversions.convertToFloat(clazz2));
            long l = AdapterMethodHandle.makeConv(10, n, AdapterMethodHandle.basicType(clazz2), AdapterMethodHandle.basicType(clazz3));
            return new AdapterMethodHandle(methodHandle, methodType, l, methodHandle2);
        }
        throw new InternalError("makePrimCast");
    }

    static MethodHandle makePrimCastOnly(MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        MethodType methodType2 = methodHandle.type();
        if (!AdapterMethodHandle.canPrimCast(methodType, methodType2, n, clazz)) {
            return null;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        long l = AdapterMethodHandle.makeConv(3, n, AdapterMethodHandle.basicType(clazz2), AdapterMethodHandle.basicType(clazz));
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    static boolean canUnboxArgument(MethodType methodType, MethodType methodType2, int n, Class<?> clazz, int n2) {
        if (!AdapterMethodHandle.convOpSupported(4)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        clazz = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canCheckCast(clazz2, clazz4) || clazz4 == clazz || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n3 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n3 == n + 1;
    }

    static boolean canUnboxArgument(Class<?> clazz, Class<?> clazz2, int n) {
        assert (clazz2.isPrimitive());
        if (AdapterMethodHandle.convOpSupported(5)) {
            return true;
        }
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
        if (n == 0) {
            return !clazz.isPrimitive();
        }
        assert (n >= 0 && n <= 2);
        return wrapper.wrapperType() == clazz;
    }

    static MethodHandle makeUnboxArgument(MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz, int n2) {
        MethodType methodType2 = methodHandle.type();
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        Class<?> clazz5 = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canUnboxArgument(methodType, methodType2, n, clazz, n2)) {
            return null;
        }
        MethodType methodType3 = methodType;
        if (!VerifyType.isNullConversion(clazz2, clazz4)) {
            if (n2 != 0) {
                if (clazz2 == Object.class || !Wrapper.isWrapperType(clazz2)) {
                    MethodHandle methodHandle2 = n2 == 1 ? ValueConversions.unbox(clazz3) : ValueConversions.unboxCast(clazz3);
                    long l = AdapterMethodHandle.makeConv(10, n, AdapterMethodHandle.basicType(clazz2), AdapterMethodHandle.basicType(clazz3));
                    return new AdapterMethodHandle(methodHandle, methodType, l, methodHandle2);
                }
                Class<?> clazz6 = Wrapper.forWrapperType(clazz2).primitiveType();
                MethodType methodType4 = methodType.changeParameterType(n, clazz6);
                MethodHandle methodHandle3 = AdapterMethodHandle.canPrimCast(methodType4, methodType2, n, clazz3) ? AdapterMethodHandle.makePrimCast(methodType4, methodHandle, n, clazz3) : methodHandle;
                return AdapterMethodHandle.makeUnboxArgument(methodType, methodHandle3, n, clazz6, 0);
            }
            methodType3 = methodType.changeParameterType(n, clazz4);
        }
        long l = AdapterMethodHandle.makeConv(4, n, 12, AdapterMethodHandle.basicType(clazz5));
        AdapterMethodHandle adapterMethodHandle = new AdapterMethodHandle(methodHandle, methodType3, l, clazz4);
        if (methodType3 == methodType) {
            return adapterMethodHandle;
        }
        return AdapterMethodHandle.makeCheckCast(methodType, adapterMethodHandle, n, clazz4);
    }

    static boolean canBoxArgument(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(5)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        clazz = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canCheckCast(clazz4, clazz3) || clazz4 == clazz || !VerifyType.isNullConversion(clazz2, clazz)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    static boolean canBoxArgument(Class<?> clazz, Class<?> clazz2) {
        if (!AdapterMethodHandle.convOpSupported(5)) {
            return false;
        }
        return clazz.isPrimitive() && !clazz2.isPrimitive();
    }

    static MethodHandle makeBoxArgument(MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        MethodType methodType2 = methodHandle.type();
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        Class<?> clazz5 = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canBoxArgument(methodType, methodType2, n, clazz)) {
            return null;
        }
        if (!VerifyType.isNullConversion(clazz4, clazz3)) {
            methodHandle = AdapterMethodHandle.makeCheckCast(methodType2.changeParameterType(n, clazz4), methodHandle, n, clazz3);
        }
        MethodHandle methodHandle2 = ValueConversions.box(Wrapper.forPrimitiveType(clazz5));
        long l = AdapterMethodHandle.makeConv(5, n, AdapterMethodHandle.basicType(clazz5), 12);
        return new AdapterMethodHandle(methodHandle, methodType, l, methodHandle2);
    }

    static boolean canDropArguments(MethodType methodType, MethodType methodType2, int n, int n2) {
        if (n2 == 0) {
            return AdapterMethodHandle.canRetypeOnly(methodType, methodType2);
        }
        if (!AdapterMethodHandle.convOpSupported(9)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n != 0 && AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n4 = n + n2;
        int n5 = n3 - n4;
        if (n < 0 || n >= n3 || n2 < 1 || n4 > n3 || methodType2.parameterCount() != n3 - n2) {
            return false;
        }
        return n5 == 0 || AdapterMethodHandle.diffParamTypes(methodType, n4, methodType2, n, n5, false) == 0;
    }

    static MethodHandle makeDropArguments(MethodType methodType, MethodHandle methodHandle, int n, int n2) {
        if (n2 == 0) {
            return AdapterMethodHandle.makeRetypeOnly(methodType, methodHandle);
        }
        if (!AdapterMethodHandle.canDropArguments(methodType, methodHandle.type(), n, n2)) {
            return null;
        }
        int n3 = n + n2;
        int n4 = methodType.parameterSlotDepth(n3);
        int n5 = methodType.parameterSlotDepth(n);
        int n6 = n5 - n4;
        assert (n6 >= n2);
        assert (methodHandle.type().parameterSlotCount() + n6 == methodType.parameterSlotCount());
        long l = AdapterMethodHandle.makeDupConv(9, n + n2 - 1, -n6);
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    static boolean canDupArguments(MethodType methodType, MethodType methodType2, int n, int n2) {
        if (!AdapterMethodHandle.convOpSupported(8)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n2 < 0 || n + n2 > n3) {
            return false;
        }
        if (methodType2.parameterCount() != n3 + n2) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n3, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(methodType, n, methodType2, n3, n2, false) == 0;
    }

    static MethodHandle makeDupArguments(MethodType methodType, MethodHandle methodHandle, int n, int n2) {
        if (!AdapterMethodHandle.canDupArguments(methodType, methodHandle.type(), n, n2)) {
            return null;
        }
        if (n2 == 0) {
            return methodHandle;
        }
        int n3 = n + n2;
        int n4 = methodType.parameterSlotDepth(n3);
        int n5 = methodType.parameterSlotDepth(n);
        int n6 = n5 - n4;
        assert (methodHandle.type().parameterSlotCount() - n6 == methodType.parameterSlotCount());
        long l = AdapterMethodHandle.makeDupConv(8, n + n2 - 1, n6);
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    static boolean canSwapArguments(MethodType methodType, MethodType methodType2, int n, int n2) {
        if (!AdapterMethodHandle.convOpSupported(6)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        if (n >= n2) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (methodType2.parameterCount() != n3) {
            return false;
        }
        if (n < 0 || n2 >= n3) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, n, methodType2, n2, 1, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, n + 1, methodType2, n + 1, n2 - n - 1, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, n2, methodType2, n, 1, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(methodType, n2 + 1, methodType2, n2 + 1, n3 - n2 - 1, false) == 0;
    }

    static MethodHandle makeSwapArguments(MethodType methodType, MethodHandle methodHandle, int n, int n2) {
        int n3;
        if (n == n2) {
            return methodHandle;
        }
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        if (AdapterMethodHandle.type2size(methodType.parameterType(n)) != AdapterMethodHandle.type2size(methodType.parameterType(n2))) {
            n3 = n2 - n + 1;
            ArrayList arrayList = new ArrayList(methodHandle.type().parameterList());
            Collections.rotate(arrayList.subList(n, n + n3), -1);
            MethodType methodType2 = MethodType.methodType(methodHandle.type().returnType(), arrayList);
            MethodHandle methodHandle2 = AdapterMethodHandle.makeRotateArguments(methodType2, methodHandle, n, n3, 1);
            assert (methodHandle2 != null);
            if (n3 == 2) {
                return methodHandle2;
            }
            MethodHandle methodHandle3 = AdapterMethodHandle.makeRotateArguments(methodType, methodHandle2, n, n3 - 1, -1);
            assert (methodHandle3 != null);
            return methodHandle3;
        }
        if (!AdapterMethodHandle.canSwapArguments(methodType, methodHandle.type(), n, n2)) {
            return null;
        }
        Class<?> clazz = methodType.parameterType(n);
        Class<?> clazz2 = methodType.parameterType(n2);
        int n4 = methodType.parameterSlotDepth(n2 + 1);
        long l = AdapterMethodHandle.makeSwapConv(6, n, AdapterMethodHandle.basicType(clazz), n4, AdapterMethodHandle.basicType(clazz2));
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    static int positiveRotation(int n, int n2) {
        assert (n > 0);
        if (n2 >= 0) {
            if (n2 < n) {
                return n2;
            }
            return n2 % n;
        }
        if (n2 >= -n) {
            return n2 + n;
        }
        return -1 - (-1 - n2) % n + n;
    }

    static boolean canRotateArguments(MethodType methodType, MethodType methodType2, int n, int n2, int n3) {
        if (!AdapterMethodHandle.convOpSupported(7)) {
            return false;
        }
        if ((n3 = AdapterMethodHandle.positiveRotation(n2, n3)) == 0) {
            return false;
        }
        if (n3 > 1 && n3 < n2 - 1) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n4 = methodType.parameterCount();
        if (methodType2.parameterCount() != n4) {
            return false;
        }
        if (n < 0 || n >= n4) {
            return false;
        }
        int n5 = n + n2;
        if (n5 > n4) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n6 = n2 - n3;
        int n7 = n3;
        if (AdapterMethodHandle.diffParamTypes(methodType, n, methodType2, n5 - n6, n6, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(methodType, n + n6, methodType2, n, n7, false) == 0;
    }

    static MethodHandle makeRotateArguments(MethodType methodType, MethodHandle methodHandle, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        n3 = AdapterMethodHandle.positiveRotation(n2, n3);
        if (!AdapterMethodHandle.canRotateArguments(methodType, methodHandle.type(), n, n2, n3)) {
            return null;
        }
        int n8 = n + n2;
        int n9 = methodType.parameterSlotDepth(n);
        int n10 = methodType.parameterSlotDepth(n8 - n3);
        int n11 = methodType.parameterSlotDepth(n8);
        int n12 = n9 - n10;
        assert (n12 > 0);
        int n13 = n10 - n11;
        assert (n13 > 0);
        if (n3 == 1) {
            n7 = n8 - 1;
            n6 = n;
            n5 = n9 + MethodHandleNatives.OP_ROT_ARGS_DOWN_LIMIT_BIAS;
            n4 = n13;
        } else {
            n7 = n;
            n6 = n8 - 1;
            n5 = n11;
            n4 = n12;
        }
        byte by = AdapterMethodHandle.basicType(methodType.parameterType(n7));
        byte by2 = AdapterMethodHandle.basicType(methodType.parameterType(n6));
        assert (n4 == AdapterMethodHandle.type2size(by));
        long l = AdapterMethodHandle.makeSwapConv(7, n7, by, n5, by2);
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    static boolean canSpreadArguments(MethodType methodType, MethodType methodType2, Class<?> clazz, int n, int n2) {
        if (!AdapterMethodHandle.convOpSupported(11)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n != 0 && AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n4 = n + n2;
        int n5 = n3 - (n + 1);
        if (n < 0 || n >= n3 || n2 < 0 || methodType2.parameterCount() != n4 + n5) {
            return false;
        }
        if (n5 != 0 && AdapterMethodHandle.diffParamTypes(methodType, n + 1, methodType2, n4, n5, false) != 0) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        if (clazz2 != clazz && !AdapterMethodHandle.canCheckCast(clazz2, clazz)) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz3 = VerifyType.spreadArgElementType(clazz, i);
            Class<?> clazz4 = methodType2.parameterType(n + i);
            if (clazz3 != null && AdapterMethodHandle.canConvertArgument(clazz3, clazz4, 1)) continue;
            return false;
        }
        return true;
    }

    static MethodHandle makeSpreadArguments(MethodType methodType, MethodHandle methodHandle, Class<?> clazz, int n, int n2) {
        int n3;
        int n4;
        MethodType methodType2 = methodHandle.type();
        assert (AdapterMethodHandle.canSpreadArguments(methodType, methodType2, clazz, n, n2)) : "[newType, targetType, spreadArgType, spreadArgPos, spreadArgCount] = " + Arrays.asList(methodType, methodType2, clazz, n, n2);
        int n5 = 14;
        for (n4 = 0; n4 < n2; ++n4) {
            Class<Object> clazz2 = VerifyType.spreadArgElementType(clazz, n4);
            if (clazz2 == null) {
                clazz2 = Object.class;
            }
            n3 = AdapterMethodHandle.basicType(clazz2);
            if (n5 == 14) {
                n5 = n3;
            } else if (n5 != n3) {
                n5 = 14;
            }
            if (n5 == 14) break;
            methodType2 = methodType2.changeParameterType(n + n4, clazz2);
        }
        methodHandle = methodHandle.asType(methodType2);
        n4 = 1;
        int n6 = n + n2;
        n3 = methodType2.parameterSlotDepth(n);
        int n7 = methodType2.parameterSlotDepth(n6);
        assert (n7 == methodType.parameterSlotDepth(n + n4));
        int n8 = n3 - n7;
        assert (n8 >= n2);
        int n9 = -n4 + n8;
        long l = AdapterMethodHandle.makeSpreadConv(11, n, 12, n5, n9);
        AdapterMethodHandle adapterMethodHandle = new AdapterMethodHandle(methodHandle, methodType, l, clazz);
        assert (adapterMethodHandle.type().parameterType(n) == clazz);
        return adapterMethodHandle;
    }

    static boolean canCollectArguments(MethodType methodType, MethodType methodType2, int n, boolean bl) {
        if (!AdapterMethodHandle.convOpSupported(bl ? 12 : 10)) {
            return false;
        }
        int n2 = methodType2.parameterCount();
        Class<?> clazz = methodType2.returnType();
        assert (clazz == Void.TYPE || methodType.parameterType(n) == clazz) : Arrays.asList(methodType, methodType2, n, n2);
        return true;
    }

    static MethodHandle makeCollectArguments(MethodHandle methodHandle, MethodHandle methodHandle2, int n, boolean bl) {
        int n2;
        int n3;
        assert (AdapterMethodHandle.canCollectArguments(methodHandle.type(), methodHandle2.type(), n, bl));
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        int n4 = methodType2.parameterCount();
        Class<?> clazz = methodType2.returnType();
        int n5 = clazz == Void.TYPE ? 0 : 1;
        int n6 = methodType2.returnSlotCount();
        MethodType methodType3 = methodType.dropParameterTypes(n, n + n5);
        if (!bl) {
            methodType3 = methodType3.insertParameterTypes(n, methodType2.parameterList());
        } else assert (AdapterMethodHandle.diffParamTypes(methodType3, n, methodType, n5, n4, false) == 0) : Arrays.asList(methodHandle, methodHandle2, n, bl);
        int n7 = n + n4;
        int n8 = methodType3.parameterSlotDepth(n);
        int n9 = methodType3.parameterSlotDepth(n7);
        int n10 = n8 - n9;
        assert (n10 >= n4);
        assert (n9 == methodType.parameterSlotDepth(n + n5 + (bl ? n4 : 0)));
        byte by = AdapterMethodHandle.basicType(clazz);
        int n11 = 14;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = AdapterMethodHandle.basicType(methodType2.parameterType(n3));
            if (n11 == 14) {
                n11 = n2;
            } else if (n11 != n2) {
                n11 = 14;
            }
            if (n11 == 14) break;
        }
        n3 = n6;
        if (!bl) {
            n3 -= n10;
        }
        n2 = n7 - 1;
        long l = AdapterMethodHandle.makeSpreadConv(bl ? 12 : 10, n2, n11, by, n3);
        AdapterMethodHandle adapterMethodHandle = new AdapterMethodHandle(methodHandle, methodType3, l, methodHandle2);
        assert (adapterMethodHandle.type().parameterList().subList(n, n + n4).equals(methodHandle2.type().parameterList()));
        return adapterMethodHandle;
    }

    @Override
    String debugString() {
        return MethodHandleStatics.getNameString(AdapterMethodHandle.nonAdapter((MethodHandle)this.vmtarget), this);
    }

    private static MethodHandle nonAdapter(MethodHandle methodHandle) {
        while (methodHandle instanceof AdapterMethodHandle) {
            methodHandle = (MethodHandle)methodHandle.vmtarget;
        }
        return methodHandle;
    }

    static class AsVarargsCollector
    extends AdapterMethodHandle {
        final MethodHandle target;
        final Class<?> arrayType;
        MethodHandle cache;

        AsVarargsCollector(MethodHandle methodHandle, Class<?> clazz) {
            super(methodHandle, methodHandle.type(), AdapterMethodHandle.makeConv(0));
            this.target = methodHandle;
            this.arrayType = clazz;
            this.cache = methodHandle.asCollector(clazz, 0);
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        public MethodHandle asType(MethodType methodType) {
            MethodHandle methodHandle;
            MethodType methodType2 = this.type();
            int n = methodType2.parameterCount() - 1;
            int n2 = methodType.parameterCount();
            if (n2 == n + 1 && methodType2.parameterType(n).isAssignableFrom(methodType.parameterType(n))) {
                return super.asType(methodType);
            }
            if (this.cache.type().parameterCount() == n2) {
                return this.cache.asType(methodType);
            }
            int n3 = n2 - n;
            try {
                methodHandle = this.target.asCollector(this.arrayType, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new WrongMethodTypeException("cannot build collector");
            }
            this.cache = methodHandle;
            return methodHandle.asType(methodType);
        }
    }
}

