/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstDeclNode
extends AssignableNode
implements INameNode {
    private final String name;
    private final INameNode constNode;

    public ConstDeclNode(ISourcePosition position, String name2, INameNode constNode, Node valueNode) {
        super(position, valueNode);
        this.name = name2;
        this.constNode = constNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CONSTDECLNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitConstDeclNode(this);
    }

    @Override
    public String getName() {
        return this.name == null ? this.constNode.getName() : this.name;
    }

    public Node getConstNode() {
        return (Node)((Object)this.constNode);
    }

    @Override
    public List<Node> childNodes() {
        return ConstDeclNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result2 = this.getValueNode().interpret(runtime2, context, self, aBlock);
        if (this.constNode == null) {
            return context.setConstantInCurrent(this.name, result2);
        }
        if (((Node)((Object)this.constNode)).getNodeType() == NodeType.COLON2NODE) {
            Node leftNode = ((Colon2Node)this.constNode).getLeftNode();
            assert (leftNode != null) : "leftNode is not null";
            IRubyObject obj = leftNode.interpret(runtime2, context, self, aBlock);
            return context.setConstantInModule(this.constNode.getName(), obj, result2);
        }
        return context.setConstantInObject(this.constNode.getName(), result2);
    }

    @Override
    public IRubyObject assign(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        IRubyObject module;
        if (this.constNode == null) {
            module = context.getCurrentScope().getStaticScope().getModule();
            if (module == null) {
                throw runtime2.newTypeError("no class/module to define constant");
            }
        } else {
            Node leftNode;
            module = this.constNode instanceof Colon2Node ? ((leftNode = ((Colon2Node)this.constNode).getLeftNode()) == null ? runtime2.getNil() : leftNode.interpret(runtime2, context, self, block)) : runtime2.getObject();
        }
        module.fastSetConstant(this.getName(), value2);
        return runtime2.getNil();
    }
}

