/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.Comparator;
import org.h2.api.DatabaseEventListener;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.result.SearchRow;
import org.h2.util.ObjectArray;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

public class MetaRecord {
    private static final Comparator META_RECORD_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            int n;
            MetaRecord metaRecord = (MetaRecord)object;
            MetaRecord metaRecord2 = (MetaRecord)object2;
            int n2 = DbObjectBase.getCreateOrder(metaRecord.getObjectType());
            if (n2 != (n = DbObjectBase.getCreateOrder(metaRecord2.getObjectType()))) {
                return n2 - n;
            }
            return metaRecord.getId() - metaRecord2.getId();
        }
    };
    private int id;
    private int objectType;
    private int headPos;
    private String sql;

    public MetaRecord(SearchRow searchRow) throws SQLException {
        this.id = searchRow.getValue(0).getInt();
        this.headPos = searchRow.getValue(1).getInt();
        this.objectType = searchRow.getValue(2).getInt();
        this.sql = searchRow.getValue(3).getString();
    }

    MetaRecord(DbObject dbObject) {
        this.id = dbObject.getId();
        this.objectType = dbObject.getType();
        this.headPos = dbObject.getHeadPos();
        this.sql = dbObject.getCreateSQL();
    }

    public static void sort(ObjectArray objectArray) {
        objectArray.sort(META_RECORD_COMPARATOR);
    }

    void setRecord(SearchRow searchRow) {
        searchRow.setValue(0, ValueInt.get(this.id));
        searchRow.setValue(1, ValueInt.get(this.headPos));
        searchRow.setValue(2, ValueInt.get(this.objectType));
        searchRow.setValue(3, ValueString.get(this.sql));
    }

    void execute(Database database, Session session, DatabaseEventListener databaseEventListener) throws SQLException {
        try {
            Prepared prepared = session.prepare(this.sql);
            prepared.setObjectId(this.id);
            prepared.setHeadPos(this.headPos);
            prepared.update();
        }
        catch (Exception exception) {
            SQLException sQLException = Message.addSQL(Message.convert(exception), this.sql);
            database.getTrace("database").error(this.sql, sQLException);
            if (databaseEventListener != null) {
                databaseEventListener.exceptionThrown(sQLException, this.sql);
            }
            throw sQLException;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String getSQL() {
        return this.sql;
    }
}

