/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class CountBlankFunction
implements Function {
    public String getCanonicalName() {
        return "COUNTBLANK";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int count = 0;
        Object value = parameters.getValue(0);
        Type type = parameters.getType(0);
        LValue raw = parameters.getRaw(0);
        if (raw instanceof ContextLookup && value != null) {
            try {
                Sequence sequence = context.getTypeRegistry().convertToSequence(type, value);
                while (sequence.hasNext()) {
                    Object o = sequence.next();
                    if (o != null) continue;
                    ++count;
                }
            }
            catch (EvaluationException e) {
                // empty catch block
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(count));
    }
}

