/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.name;

import hidden.org.apache.jackrabbit.name.MalformedPathException;
import hidden.org.apache.jackrabbit.name.NameFormat;
import hidden.org.apache.jackrabbit.name.NamespaceResolver;
import hidden.org.apache.jackrabbit.name.NoPrefixDeclaredException;
import hidden.org.apache.jackrabbit.name.PathFormat;
import hidden.org.apache.jackrabbit.name.QName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.jcr.PathNotFoundException;

public final class Path
implements Serializable {
    static final long serialVersionUID = 7272485577196962560L;
    public static final PathElement ROOT_ELEMENT = new RootElement();
    public static final PathElement CURRENT_ELEMENT = new CurrentElement();
    public static final PathElement PARENT_ELEMENT = new ParentElement();
    public static final Path ROOT = new Path(new PathElement[]{ROOT_ELEMENT}, true);
    public static final int INDEX_UNDEFINED = 0;
    public static final int INDEX_DEFAULT = 1;
    public static final int ROOT_DEPTH = 0;
    private final PathElement[] elements;
    private final boolean normalized;
    private final boolean absolute;
    private transient int hash = 0;
    private transient String string;

    private Path(PathElement[] elements, boolean isNormalized) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("Empty paths are not allowed");
        }
        this.elements = elements;
        this.absolute = elements[0].denotesRoot();
        this.normalized = isNormalized;
    }

    public static Path create(String jcrPath, NamespaceResolver resolver, boolean normalize) throws MalformedPathException {
        Path path = PathFormat.parse(jcrPath, resolver);
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(Path parent, String relJCRPath, NamespaceResolver resolver, boolean canonicalize) throws MalformedPathException {
        Path path = PathFormat.parse(parent, relJCRPath, resolver);
        if (canonicalize) {
            return path.getCanonicalPath();
        }
        return path;
    }

    public static Path create(Path parent, Path relPath, boolean normalize) throws MalformedPathException {
        if (relPath.isAbsolute()) {
            throw new MalformedPathException("relPath is not a relative path");
        }
        PathBuilder pb = new PathBuilder(parent);
        pb.addAll(relPath.getElements());
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(Path parent, QName name, boolean normalize) throws MalformedPathException {
        PathBuilder pb = new PathBuilder(parent);
        pb.addLast(name);
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(Path parent, QName name, int index, boolean normalize) throws MalformedPathException {
        PathBuilder pb = new PathBuilder(parent);
        pb.addLast(name, index);
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(QName name, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("index must not be negative: " + index);
        }
        PathElement elem = index < 1 ? PathElement.create(name) : PathElement.create(name, index);
        return new Path(new PathElement[]{elem}, !elem.denotesCurrent());
    }

    public static void checkFormat(String jcrPath) throws MalformedPathException {
        PathFormat.checkFormat(jcrPath);
    }

    public boolean denotesRoot() {
        return this.absolute && this.elements.length == 1;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isCanonical() {
        return this.absolute && this.normalized;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public Path getNormalizedPath() throws MalformedPathException {
        if (this.isNormalized()) {
            return this;
        }
        LinkedList<PathElement> queue = new LinkedList<PathElement>();
        PathElement last = PARENT_ELEMENT;
        for (int i = 0; i < this.elements.length; ++i) {
            PathElement elem = this.elements[i];
            if (elem.denotesParent() && !last.denotesParent()) {
                if (last.denotesRoot()) {
                    throw new MalformedPathException("Path can not be canonicalized: unresolvable '..' element");
                }
                queue.removeLast();
                if (queue.isEmpty()) {
                    last = PARENT_ELEMENT;
                    continue;
                }
                last = (PathElement)queue.getLast();
                continue;
            }
            if (elem.denotesCurrent()) continue;
            last = elem;
            queue.add(last);
        }
        if (queue.isEmpty()) {
            throw new MalformedPathException("Path can not be normalized: would result in an empty path.");
        }
        return new Path(queue.toArray(new PathElement[queue.size()]), true);
    }

    public Path getCanonicalPath() throws MalformedPathException {
        if (this.isCanonical()) {
            return this;
        }
        if (!this.isAbsolute()) {
            throw new MalformedPathException("only an absolute path can be canonicalized.");
        }
        return this.getNormalizedPath();
    }

    public Path computeRelativePath(Path other) throws MalformedPathException {
        Path p1;
        if (other == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (!this.isAbsolute() || !other.isAbsolute()) {
            throw new MalformedPathException("not an absolute path");
        }
        Path p0 = this.getCanonicalPath();
        if (p0.equals(p1 = other.getCanonicalPath())) {
            PathBuilder pb = new PathBuilder();
            pb.addLast(CURRENT_ELEMENT);
            return pb.getPath();
        }
        int lengthCommon = 0;
        for (int i = 0; i < p0.getElements().length && i < p1.getElements().length && p0.getElement(i).equals(p1.getElement(i)); ++i) {
            ++lengthCommon;
        }
        PathBuilder pb = new PathBuilder();
        if (lengthCommon < p0.getElements().length) {
            int tmp = p0.getElements().length - lengthCommon;
            while (tmp-- > 0) {
                pb.addFirst(PARENT_ELEMENT);
            }
        }
        for (int i = lengthCommon; i < p1.getElements().length; ++i) {
            pb.addLast(p1.getElement(i));
        }
        return pb.getPath();
    }

    public Path getAncestor(int degree) throws IllegalArgumentException, PathNotFoundException {
        if (degree < 0) {
            throw new IllegalArgumentException("degree must be >= 0");
        }
        if (degree == 0) {
            return this;
        }
        int length = this.elements.length - degree;
        if (length < 1) {
            throw new PathNotFoundException("no such ancestor path of degree " + degree);
        }
        PathElement[] elements = new PathElement[length];
        System.arraycopy(this.elements, 0, elements, 0, length);
        return new Path(elements, this.normalized);
    }

    public int getAncestorCount() {
        return this.getDepth() - 1;
    }

    public int getLength() {
        return this.elements.length;
    }

    public int getDepth() {
        int depth = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].denotesParent()) {
                --depth;
                continue;
            }
            if (this.elements[i].denotesCurrent()) continue;
            ++depth;
        }
        return depth;
    }

    public boolean isAncestorOf(Path other) throws MalformedPathException {
        Path p1;
        if (other == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new MalformedPathException("cannot compare a relative path with an absolute path");
        }
        Path p0 = this.getNormalizedPath();
        if (p0.equals(p1 = other.getNormalizedPath())) {
            return false;
        }
        if (p0.getDepth() >= p1.getDepth()) {
            return false;
        }
        for (int i = 0; i < p0.getElements().length; ++i) {
            if (p0.getElement(i).equals(p1.getElement(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendantOf(Path other) throws MalformedPathException {
        if (other == null) {
            throw new IllegalArgumentException("null argument");
        }
        return other.isAncestorOf(this);
    }

    public PathElement getNameElement() {
        return this.elements[this.elements.length - 1];
    }

    public PathElement[] getElements() {
        return this.elements;
    }

    public PathElement getElement(int i) {
        return this.elements[i];
    }

    public String toJCRPath(NamespaceResolver resolver) throws NoPrefixDeclaredException {
        return PathFormat.format(this, resolver);
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.elements.length; ++i) {
                if (i > 0) {
                    sb.append('\t');
                }
                PathElement element = this.elements[i];
                String elem = element.toString();
                sb.append(elem);
            }
            this.string = sb.toString();
        }
        return this.string;
    }

    public static Path valueOf(String s) throws IllegalArgumentException {
        if ("".equals(s) || s == null) {
            throw new IllegalArgumentException("invalid Path literal");
        }
        int delim = 9;
        int lastPos = 0;
        int pos = s.indexOf(9);
        ArrayList<PathElement> list = new ArrayList<PathElement>();
        boolean isNormalized = true;
        boolean leadingParent = true;
        while (lastPos >= 0) {
            PathElement elem;
            if (pos >= 0) {
                elem = PathElement.fromString(s.substring(lastPos, pos));
                lastPos = pos + 1;
                pos = s.indexOf(9, lastPos);
            } else {
                elem = PathElement.fromString(s.substring(lastPos));
                lastPos = -1;
            }
            list.add(elem);
            isNormalized &= !elem.denotesCurrent() && ((leadingParent &= elem.denotesParent()) || !elem.denotesParent());
        }
        return new Path(list.toArray(new PathElement[list.size()]), isNormalized);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 17;
            for (int i = 0; i < this.elements.length; ++i) {
                h = 37 * h + this.elements[i].hashCode();
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            return Arrays.equals(this.elements, other.getElements());
        }
        return false;
    }

    public static final class NameElement
    extends PathElement {
        private NameElement(QName name, int index) {
            super(name, index);
        }

        public boolean denotesName() {
            return true;
        }

        public boolean denotesRoot() {
            return false;
        }

        public boolean denotesParent() {
            return false;
        }

        public boolean denotesCurrent() {
            return false;
        }
    }

    public static final class ParentElement
    extends PathElement {
        static final String LITERAL = "..";

        private ParentElement() {
            super(new QName("", LITERAL), 0);
        }

        public boolean denotesName() {
            return false;
        }

        public boolean denotesRoot() {
            return false;
        }

        public boolean denotesParent() {
            return true;
        }

        public boolean denotesCurrent() {
            return false;
        }

        public String toJCRName(NamespaceResolver resolver) {
            return LITERAL;
        }

        public void toJCRName(NamespaceResolver resolver, StringBuffer buf) {
            buf.append(LITERAL);
        }

        public String toString() {
            return LITERAL;
        }
    }

    public static final class CurrentElement
    extends PathElement {
        static final String LITERAL = ".";

        private CurrentElement() {
            super(new QName("", LITERAL), 0);
        }

        public boolean denotesName() {
            return false;
        }

        public boolean denotesRoot() {
            return false;
        }

        public boolean denotesParent() {
            return false;
        }

        public boolean denotesCurrent() {
            return true;
        }

        public String toJCRName(NamespaceResolver resolver) {
            return LITERAL;
        }

        public void toJCRName(NamespaceResolver resolver, StringBuffer buf) {
            buf.append(LITERAL);
        }

        public String toString() {
            return LITERAL;
        }
    }

    public static final class RootElement
    extends PathElement {
        static final String LITERAL = "*";

        private RootElement() {
            super(QName.ROOT, 0);
        }

        public boolean denotesName() {
            return false;
        }

        public boolean denotesRoot() {
            return true;
        }

        public boolean denotesParent() {
            return false;
        }

        public boolean denotesCurrent() {
            return false;
        }

        public String toJCRName(NamespaceResolver resolver) {
            return "";
        }

        public void toJCRName(NamespaceResolver resolver, StringBuffer buf) {
        }

        public String toString() {
            return LITERAL;
        }
    }

    public static abstract class PathElement
    implements Serializable {
        private final QName name;
        private final int index;

        private PathElement(QName name, int index) {
            this.index = index;
            this.name = name;
        }

        public static PathElement create(QName name) {
            if (name == null) {
                throw new IllegalArgumentException("name must not be null");
            }
            if (name.equals(PARENT_ELEMENT.getName())) {
                return PARENT_ELEMENT;
            }
            if (name.equals(CURRENT_ELEMENT.getName())) {
                return CURRENT_ELEMENT;
            }
            if (name.equals(ROOT_ELEMENT.getName())) {
                return ROOT_ELEMENT;
            }
            return new NameElement(name, 0);
        }

        public static PathElement create(QName name, int index) {
            if (index < 1) {
                throw new IllegalArgumentException("index is 1-based.");
            }
            if (name == null) {
                throw new IllegalArgumentException("name must not be null");
            }
            if (name.equals(PARENT_ELEMENT.getName()) || name.equals(CURRENT_ELEMENT.getName()) || name.equals(ROOT_ELEMENT.getName())) {
                throw new IllegalArgumentException("special path elements (root, '.' and '..') can not have an explicit index");
            }
            return new NameElement(name, index);
        }

        public QName getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public int getNormalizedIndex() {
            if (this.index == 0) {
                return 1;
            }
            return this.index;
        }

        public String toJCRName(NamespaceResolver resolver) throws NoPrefixDeclaredException {
            StringBuffer sb = new StringBuffer();
            this.toJCRName(resolver, sb);
            return sb.toString();
        }

        public void toJCRName(NamespaceResolver resolver, StringBuffer buf) throws NoPrefixDeclaredException {
            NameFormat.format(this.name, resolver, buf);
            int index = this.getIndex();
            if (index > 1) {
                buf.append('[');
                buf.append(index);
                buf.append(']');
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name.toString());
            int index = this.getIndex();
            if (index > 0) {
                sb.append('[');
                sb.append(index);
                sb.append(']');
            }
            return sb.toString();
        }

        public static PathElement fromString(String s) throws IllegalArgumentException {
            if (s == null) {
                throw new IllegalArgumentException("null PathElement literal");
            }
            if (s.equals("*")) {
                return ROOT_ELEMENT;
            }
            if (s.equals(".")) {
                return CURRENT_ELEMENT;
            }
            if (s.equals("..")) {
                return PARENT_ELEMENT;
            }
            int pos = s.indexOf(91);
            if (pos == -1) {
                QName name = QName.valueOf(s);
                return new NameElement(name, 0);
            }
            QName name = QName.valueOf(s.substring(0, pos));
            int pos1 = s.indexOf(93);
            if (pos1 == -1) {
                throw new IllegalArgumentException("invalid PathElement literal: " + s + " (missing ']')");
            }
            try {
                int index = Integer.valueOf(s.substring(pos + 1, pos1));
                if (index < 1) {
                    throw new IllegalArgumentException("invalid PathElement literal: " + s + " (index is 1-based)");
                }
                return new NameElement(name, index);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("invalid PathElement literal: " + s + " (" + t.getMessage() + ")");
            }
        }

        public int hashCode() {
            int h = 17;
            h = 37 * h + this.normalizeIndex(this.index);
            h = 37 * h + this.name.hashCode();
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PathElement) {
                PathElement other = (PathElement)obj;
                return this.name.equals(other.name) && this.normalizeIndex(this.index) == this.normalizeIndex(other.index);
            }
            return false;
        }

        private int normalizeIndex(int index) {
            return index == 0 ? 1 : index;
        }

        public abstract boolean denotesRoot();

        public abstract boolean denotesParent();

        public abstract boolean denotesCurrent();

        public abstract boolean denotesName();
    }

    public static final class PathBuilder
    implements Cloneable {
        private final LinkedList queue = new LinkedList();
        boolean isNormalized = true;
        boolean leadingParent = true;

        public PathBuilder() {
        }

        public PathBuilder(PathElement[] elements) {
            this();
            this.addAll(elements);
        }

        public PathBuilder(Path parent) {
            this();
            this.addAll(parent.getElements());
        }

        public void addRoot() {
            this.addFirst(ROOT_ELEMENT);
        }

        public void addAll(PathElement[] elements) {
            for (int i = 0; i < elements.length; ++i) {
                this.addLast(elements[i]);
            }
        }

        public void addFirst(PathElement elem) {
            if (this.queue.isEmpty()) {
                this.isNormalized &= !elem.denotesCurrent();
                this.leadingParent = elem.denotesParent();
            } else {
                this.isNormalized &= !elem.denotesCurrent() && (!this.leadingParent || elem.denotesParent());
                this.leadingParent |= elem.denotesParent();
            }
            this.queue.addFirst(elem);
        }

        public void addFirst(QName name) {
            this.addFirst(PathElement.create(name));
        }

        public void addFirst(QName name, int index) {
            this.addFirst(PathElement.create(name, index));
        }

        public void addLast(PathElement elem) {
            this.queue.addLast(elem);
            this.leadingParent &= elem.denotesParent();
            this.isNormalized &= !elem.denotesCurrent() && (this.leadingParent || !elem.denotesParent());
        }

        public void addLast(QName name) {
            this.addLast(PathElement.create(name));
        }

        public void addLast(QName name, int index) {
            this.addLast(PathElement.create(name, index));
        }

        public Path getPath() throws MalformedPathException {
            PathElement[] elements = this.queue.toArray(new PathElement[this.queue.size()]);
            if (elements.length == 0) {
                throw new MalformedPathException("empty path");
            }
            return new Path(elements, this.isNormalized);
        }
    }
}

