# Moovida - Home multimedia server
# Copyright (C) 2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from twisted.trial.unittest import TestCase
from elisa.core.utils import i18n

import os
import locale

class TestI18n(TestCase):

    def patch_getenv(self, mock):
        self._old_getenv = os.getenv
        os.getenv = mock

    def unpatch_getenv(self):
        os.getenv = self._old_getenv

    def patch_locale(self, mock):
        self._old_locale = locale.getdefaultlocale
        locale.getdefaultlocale = mock

    def unpatch_locale(self):
        locale.getdefaultlocale = self._old_locale

    def test_get_current_locale_C(self):

        def getenv_mock(variable_name):
            if variable_name == 'LANG':
                return 'C'

        def locale_mock():
            return (None, None)

        self.patch_getenv(getenv_mock)
        self.patch_locale(locale_mock)
        self.assertEquals(i18n.get_current_locale(), 'C')
        self.unpatch_getenv()
        self.unpatch_locale()

    def test_get_current_locale_fr(self):

        def getenv_mock(variable_name):
            if variable_name == 'LANG':
                return 'fr_FR'

        def locale_mock():
            return ('fr_FR', None)

        self.patch_getenv(getenv_mock)
        self.patch_locale(locale_mock)
        self.assertEquals(i18n.get_current_locale(), 'fr_FR')
        self.unpatch_getenv()
        self.unpatch_locale()
