/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.parsing.api.Snapshot;

public class LexerUtils {
    public static TokenSequence<CssTokenId> getCssTokenSequence(Document doc, int offset) {
        TokenHierarchy hi = TokenHierarchy.get((Document)doc);
        TokenSequence<CssTokenId> ts = LexerUtils.tokenSequenceList(hi, offset, false);
        if (ts == null) {
            ts = LexerUtils.tokenSequenceList(hi, offset, true);
        }
        if (ts == null) {
            return null;
        }
        ts.moveStart();
        if (ts.moveNext() && ts.offset() > offset) {
            return null;
        }
        ts.moveEnd();
        if (ts.movePrevious() && ts.offset() + ts.token().length() < offset) {
            return null;
        }
        return ts;
    }

    private static TokenSequence<CssTokenId> tokenSequenceList(TokenHierarchy hi, int offset, boolean backwardBias) {
        List tsl = hi.embeddedTokenSequences(offset, backwardBias);
        if (tsl.size() > 0) {
            TokenSequence ts = (TokenSequence)tsl.get(tsl.size() - 1);
            if (ts.language() != CssTokenId.language()) {
                return null;
            }
            return ts;
        }
        return null;
    }

    public static TokenSequence<CssTokenId> getJoinedTokenSequence(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        ts.move(offset);
        while (ts.moveNext() || ts.movePrevious()) {
            if (ts.language() == CssTokenId.language()) {
                return ts;
            }
            if ((ts = ts.embeddedJoined()) == null) break;
            ts.move(offset);
        }
        return null;
    }

    public static int findNearestMappableSourcePosition(Snapshot snapshot, int position, boolean forward, int limit) {
        if (forward) {
            int boundary = Math.max(snapshot.getText().length(), position + limit);
            for (int i = position; i < boundary; ++i) {
                int original = snapshot.getOriginalOffset(i);
                if (original == -1) continue;
                return original;
            }
        } else {
            int boundary = Math.min(0, position - limit);
            for (int i = position; i >= boundary; --i) {
                int original = snapshot.getOriginalOffset(i);
                if (original == -1) continue;
                return original;
            }
        }
        return -1;
    }
}

