/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.jaxws.ServerType;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWsStackProvider;
import org.openide.util.Lookup;

public class WSStackUtils {
    public static final String DEVNULL = "DEV-NULL";
    private Project project;
    private J2eePlatform j2eePlatform;

    public WSStackUtils(Project project) {
        this.project = project;
        this.j2eePlatform = this.getJ2eePlatform(project);
    }

    private J2eePlatform getJ2eePlatform(Project project) {
        String string;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (string = j2eeModuleProvider.getServerInstanceID()) != null && !string.equals(DEVNULL)) {
            try {
                return Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform", instanceRemovedException);
            }
        }
        return null;
    }

    public boolean isWsitSupported() {
        if (this.j2eePlatform != null) {
            WSStack wSStack = JaxWsStackProvider.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wSStack != null && wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT);
        }
        return false;
    }

    public boolean isJsr109Supported() {
        if (this.j2eePlatform != null) {
            WSStack wSStack = JaxWsStackProvider.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wSStack != null && wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
        }
        return true;
    }

    public boolean isJsr109OldSupported() {
        return this.j2eePlatform != null && WSStackUtils.getServerType(this.project) == ServerType.GLASSFISH;
    }

    public static ServerType getServerType(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null || j2eeModuleProvider.getServerInstanceID() == null || DEVNULL.equals(j2eeModuleProvider.getServerInstanceID())) {
            return ServerType.NOT_SPECIFIED;
        }
        String string = j2eeModuleProvider.getServerID();
        if (string.startsWith("Tomcat")) {
            return ServerType.TOMCAT;
        }
        if (string.equals("J2EE")) {
            return ServerType.GLASSFISH;
        }
        if (string.startsWith("gfv3")) {
            return ServerType.GLASSFISH_V3;
        }
        if (string.equals("GlassFish")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("APPSERVER")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("JavaEE")) {
            return ServerType.GLASSFISH;
        }
        if (string.startsWith("JBoss")) {
            return ServerType.JBOSS;
        }
        if (string.startsWith("WebLogic")) {
            return ServerType.WEBLOGIC;
        }
        if (string.startsWith("WebSphere")) {
            return ServerType.WEBSPHERE;
        }
        return ServerType.UNKNOWN;
    }

    public ServerType getServerType() {
        return WSStackUtils.getServerType(this.project);
    }

    public <T> WSStack<T> getWsStack(Class<T> clazz) {
        if (this.j2eePlatform != null) {
            return WSStack.findWSStack((Lookup)this.j2eePlatform.getLookup(), clazz);
        }
        return null;
    }
}

