/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;

public class CommandBuffer {
    private static final int WAIT_TIME = 30000;
    private static final boolean timerOn = Boolean.getBoolean("gdb.proxy.timer");
    private final StringBuilder buf = new StringBuilder();
    private final int token;
    private String err = null;
    private State state = State.NONE;
    private final Object lock = new Object();
    protected static final Logger log = Logger.getLogger("gdb.logger.cb");
    private final GdbProxy gdb;

    public CommandBuffer(GdbProxy gdb, int token) {
        assert (gdb != null);
        this.gdb = gdb;
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String waitForCompletion() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        Object object = this.lock;
        synchronized (object) {
            String string;
            if (this.state == State.NONE) {
                this.state = State.WAITING;
            }
            try {
                long tstart;
                long tend = tstart = System.currentTimeMillis();
                while (this.state == State.WAITING) {
                    this.lock.wait(30000L);
                    tend = System.currentTimeMillis();
                    if (tend - tstart <= 30000L) continue;
                    if (this.state == State.OK) {
                        log.finest("CB.postAndWait[" + this.token + "]: Timed out after Done [" + this.getResponse() + "]");
                        continue;
                    }
                    this.state = State.TIMEOUT;
                }
                if (this.state == State.TIMEOUT) {
                    log.warning("CB.postAndWait[" + this.token + "]: Timeout at " + tend + " on " + GdbUtils.threadId());
                } else if (log.isLoggable(Level.FINE)) {
                    if (this.state == State.ERROR && !Thread.currentThread().getName().equals("ToolTip-Evaluator")) {
                        log.fine("CB.postAndWait[" + this.token + "]: Error wait of " + (tend - tstart) + " ms on " + GdbUtils.threadId());
                    } else if (this.state == State.OK) {
                        log.fine("CB.postAndWait[" + this.token + "]: OK wait of " + (tend - tstart) + " ms on " + GdbUtils.threadId());
                    }
                }
                string = this.getResponse();
                this.gdb.removeCB(this.token);
            }
            catch (InterruptedException ex) {
                String string2;
                try {
                    string2 = "";
                    this.gdb.removeCB(this.token);
                }
                catch (Throwable throwable) {
                    this.gdb.removeCB(this.token);
                    throw throwable;
                }
                return string2;
            }
            return string;
        }
    }

    public int getID() {
        return this.token;
    }

    public void append(String line) {
        this.buf.append(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object object = this.lock;
        synchronized (object) {
            this.state = State.OK;
            log.finest("CB.done[" + CommandBuffer.addTimePrefix(timerOn && log.isLoggable(Level.FINEST), this.token) + "]: Released lock on " + GdbUtils.threadId());
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msg) {
        Object object = this.lock;
        synchronized (object) {
            this.err = msg;
            this.state = State.ERROR;
            log.finest("CB.error[" + CommandBuffer.addTimePrefix(timerOn && log.isLoggable(Level.FINEST), this.token) + "]: Releasing lock on " + GdbUtils.threadId());
            this.lock.notifyAll();
        }
    }

    public String getError() {
        if (this.state == State.ERROR && this.err != null) {
            return this.err;
        }
        return null;
    }

    public boolean isTimedOut() {
        return this.state == State.TIMEOUT;
    }

    public boolean isError() {
        return this.state == State.ERROR;
    }

    public boolean isOK() {
        return this.state == State.OK;
    }

    public String getResponse() {
        return this.buf.toString();
    }

    public String toString() {
        return "CommandBuffer(id=" + this.token + ", text=" + this.getResponse() + ", state=" + (Object)((Object)this.state) + ", error=" + this.err + ")";
    }

    public static String addTimePrefix(boolean show, Object msg) {
        if (show) {
            return Long.toString(System.currentTimeMillis()) + ':' + msg;
        }
        return msg.toString();
    }

    private static enum State {
        NONE,
        WAITING,
        TIMEOUT,
        OK,
        ERROR;

    }
}

