/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueStorage;

public class IssueCache<T> {
    public static final int ISSUE_STATUS_UNKNOWN = 0;
    public static final int ISSUE_STATUS_SEEN = 2;
    public static final int ISSUE_STATUS_NEW = 4;
    public static final int ISSUE_STATUS_MODIFIED = 8;
    public static final int ISSUE_STATUS_ALL = 14;
    public static final int ISSUE_STATUS_NOT_SEEN = 12;
    public static final String EVENT_ISSUE_SEEN_CHANGED = "issue.seen_changed";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache");
    private Map<String, IssueEntry> cache;
    private final Map<String, PropertyChangeSupport> supports = new HashMap<String, PropertyChangeSupport>();
    private Map<String, Map<String, String>> lastSeenAttributes;
    private String nameSpace;
    private final Object CACHE_LOCK = new Object();
    private long referenceTime;
    private final IssueAccessor<T> issueAccessor;

    public IssueCache(String nameSpace, IssueAccessor<T> issueAccessor) {
        assert (issueAccessor != null);
        this.nameSpace = nameSpace;
        this.issueAccessor = issueAccessor;
        try {
            this.referenceTime = IssueStorage.getInstance().getReferenceTime(nameSpace);
        }
        catch (IOException ex) {
            this.referenceTime = System.currentTimeMillis();
            LOG.log(Level.SEVERE, null, ex);
        }
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = IssueCache.this.CACHE_LOCK;
                synchronized (object) {
                    IssueCache.this.cleanup();
                }
            }
        });
    }

    protected void cleanup() {
        IssueStorage.getInstance().cleanup(this.nameSpace);
    }

    IssueAccessor<T> getIssueAccessor() {
        return this.issueAccessor;
    }

    public Issue setIssueData(String id, T issueData) throws IOException {
        assert (issueData != null);
        assert (id != null && !id.equals(""));
        return this.setIssueData(id, null, issueData);
    }

    public void setIssueData(Issue issue, T issueData) throws IOException {
        assert (issueData != null);
        assert (issue != null);
        String id = issue.getID() == null ? this.issueAccessor.getID(issueData) : issue.getID();
        assert (id != null && !id.equals(""));
        this.setIssueData(id, issue, issueData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Issue setIssueData(String id, Issue issue, T issueData) throws IOException {
        assert (issueData != null);
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry entry = this.getCache().get(id);
            if (entry == null) {
                entry = this.createNewEntry(id);
            }
            if (entry.issue == null) {
                if (issue != null) {
                    entry.issue = issue;
                    LOG.log(Level.FINE, "setting task data for issue {0} ", new Object[]{id});
                    this.issueAccessor.setIssueData(entry.issue, issueData);
                } else {
                    entry.issue = this.issueAccessor.createIssue(issueData);
                    LOG.log(Level.FINE, "created issue {0} ", new Object[]{id});
                    this.readIssue(entry);
                    Map<String, String> attr = entry.getSeenAttributes();
                    if (attr == null || attr.isEmpty()) {
                        if (this.referenceTime >= this.issueAccessor.getLastModified(entry.issue)) {
                            this.setSeen(id, true);
                        } else if (this.referenceTime >= this.issueAccessor.getCreated(entry.issue)) {
                            entry.seenAttributes = this.issueAccessor.getAttributes(entry.issue);
                            this.storeIssue(entry);
                        }
                    }
                }
            } else {
                LOG.log(Level.FINE, "setting task data for issue {0} ", new Object[]{id});
                this.issueAccessor.setIssueData(entry.issue, issueData);
            }
            if (entry.seenAttributes != null) {
                if (entry.wasSeen()) {
                    LOG.log(Level.FINE, " issue {0} was seen", new Object[]{id});
                    long lastModified = this.issueAccessor.getLastModified(entry.issue);
                    if (this.isChanged(entry.seenAttributes, this.issueAccessor.getAttributes(entry.issue)) || entry.lastSeenModified < lastModified) {
                        LOG.log(Level.FINE, " issue {0} is changed", new Object[]{id});
                        if (entry.lastSeenModified >= lastModified) {
                            LOG.log(Level.WARNING, " issue '{'0'}' changed, yet last known modify > last modify. [{0},{1}]", new Object[]{entry.lastSeenModified, lastModified});
                        }
                        this.storeIssue(entry);
                        entry.seen = false;
                        entry.status = 8;
                    } else {
                        LOG.log(Level.FINE, " issue {0} isn't changed", new Object[]{id});
                    }
                } else {
                    LOG.log(Level.FINE, " issue {0} wasn't seen yet", new Object[]{id});
                    if (this.isChanged(entry.seenAttributes, this.issueAccessor.getAttributes(entry.issue)) || this.referenceTime < this.issueAccessor.getLastModified(entry.issue)) {
                        LOG.log(Level.FINE, " issue {0} is changed", new Object[]{id});
                        entry.seen = false;
                        entry.status = 8;
                    } else {
                        LOG.log(Level.FINE, " issue {0} isn't changed", new Object[]{id});
                        entry.seenAttributes = null;
                        entry.seen = false;
                        entry.status = 4;
                    }
                }
            }
            return entry.issue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeen(String id, boolean seen) throws IOException {
        IssueEntry entry;
        boolean oldValue;
        if (id == null) {
            return;
        }
        LOG.log(Level.FINE, "setting seen {0} for issue {1}", new Object[]{seen, id});
        assert (!SwingUtilities.isEventDispatchThread());
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            oldValue = this.wasSeen(id);
            entry = this.getCache().get(id);
            assert (entry != null && entry.issue != null);
            if (seen) {
                this.getLastSeenAttributes().put(id, entry.seenAttributes);
                entry.seenAttributes = this.issueAccessor.getAttributes(entry.issue);
                entry.lastSeenModified = this.issueAccessor.getLastModified(entry.issue);
                entry.lastUnseenStatus = entry.status;
            } else {
                entry.seenAttributes = this.getLastSeenAttributes().get(id);
                if (entry.lastUnseenStatus != 0) {
                    entry.status = entry.lastUnseenStatus;
                    if (entry.seenAttributes == null) {
                        entry.seenAttributes = this.issueAccessor.getAttributes(entry.issue);
                    }
                }
            }
            entry.seen = seen;
            this.storeIssue(entry);
        }
        this.fireSeenChanged(entry.issue, oldValue, seen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSeen(String id) {
        IssueEntry entry;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            entry = this.getCache().get(id);
            if (entry == null) {
                entry = this.createNewEntry(id);
                this.readIssue(entry);
            }
        }
        boolean seen = entry != null ? entry.seen : false;
        LOG.log(Level.FINE, "returning seen {0} for issue {1}", new Object[]{seen, id});
        return seen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSeenAttributes(String id) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry entry = this.getCache().get(id);
            if (entry == null) {
                assert (!SwingUtilities.isEventDispatchThread());
                entry = this.createNewEntry(id);
                this.readIssue(entry);
            }
            return entry.seenAttributes != null ? entry.seenAttributes : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue getIssue(String id) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry entry = this.getCache().get(id);
            return entry == null ? null : entry.issue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(String id) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry entry = this.getCache().get(id);
            if (entry == null) {
                LOG.log(Level.FINE, "returning UKNOWN status for issue {0}", new Object[]{id});
                return 0;
            }
            if (entry.seen) {
                LOG.log(Level.FINE, "returning SEEN status for issue {0}", new Object[]{id});
                return 2;
            }
            LOG.log(Level.FINE, "returning status {0} for issue {1}", new Object[]{entry.status, id});
            return entry.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeQueryIssues(String name, String[] ids) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().storeQuery(this.nameSpace, name, ids);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public long getQueryTimestamp(String name) {
        return IssueStorage.getInstance().getQueryTimestamp(this.nameSpace, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readQueryIssues(String name) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                return IssueStorage.getInstance().readQuery(this.nameSpace, name);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
                return new ArrayList<String>(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeArchivedQueryIssues(String name, String[] ids) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().storeArchivedQueryIssues(this.nameSpace, name, ids);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readArchivedQueryIssues(String name) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                Map<String, Long> m = IssueStorage.getInstance().readArchivedQueryIssues(this.nameSpace, name);
                return new ArrayList<String>(m.keySet());
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
                return new ArrayList<String>(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String name) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().removeQuery(this.nameSpace, name);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    private IssueEntry createNewEntry(String id) {
        IssueEntry entry = new IssueEntry();
        entry.id = id;
        entry.status = 4;
        this.getCache().put(id, entry);
        return entry;
    }

    private Map<String, IssueEntry> getCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, IssueEntry>();
        }
        return this.cache;
    }

    private Map<String, Map<String, String>> getLastSeenAttributes() {
        if (this.lastSeenAttributes == null) {
            this.lastSeenAttributes = new HashMap<String, Map<String, String>>();
        }
        return this.lastSeenAttributes;
    }

    private synchronized void readIssue(IssueEntry entry) {
        try {
            IssueStorage.getInstance().readIssue(this.nameSpace, entry);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void storeIssue(IssueEntry entry) throws IOException {
        IssueStorage.getInstance().storeIssue(this.nameSpace, entry);
    }

    void addPropertyChangeListener(Issue issue, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport support = this.getChangeSupport(issue, true);
        support.addPropertyChangeListener(propertyChangeListener);
    }

    private PropertyChangeSupport getChangeSupport(Issue issue, boolean forceCreate) {
        PropertyChangeSupport support = this.supports.get(issue.getID());
        if (support == null && forceCreate) {
            support = new PropertyChangeSupport(issue);
            this.supports.put(issue.getID(), support);
        }
        return support;
    }

    void removePropertyChangeListener(Issue issue, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport support = this.getChangeSupport(issue, true);
        support.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireSeenChanged(Issue issue, boolean oldSeen, boolean newSeen) {
        PropertyChangeSupport support = this.getChangeSupport(issue, false);
        if (support != null) {
            support.firePropertyChange(EVENT_ISSUE_SEEN_CHANGED, oldSeen, newSeen);
        }
    }

    private boolean isChanged(Map<String, String> oldAttr, Map<String, String> newAttr) {
        if (oldAttr == null) {
            return false;
        }
        for (Map.Entry<String, String> e : oldAttr.entrySet()) {
            String newValue = newAttr.get(e.getKey());
            String oldValue = e.getValue();
            if (newValue == null && oldValue != null) continue;
        }
        return false;
    }

    static class IssueEntry {
        private Issue issue;
        private Map<String, String> seenAttributes;
        private int status;
        private boolean seen = false;
        private String id;
        private long lastSeenModified = -1L;
        private int lastUnseenStatus = 0;

        IssueEntry() {
        }

        IssueEntry(Issue issue, Map<String, String> seenAttributes, int status, int lastUnseenStatus, boolean seen, long lastKnownModified) {
            this.issue = issue;
            this.id = issue.getID();
            this.seenAttributes = seenAttributes;
            this.status = status;
            this.seen = seen;
            this.lastSeenModified = lastKnownModified;
            this.lastUnseenStatus = lastUnseenStatus;
        }

        public boolean wasSeen() {
            return this.seen;
        }

        public Map<String, String> getSeenAttributes() {
            return this.seenAttributes;
        }

        public int getStatus() {
            return this.status;
        }

        public void setSeen(boolean seen) {
            this.seen = seen;
        }

        public void setSeenAttributes(Map<String, String> seenAttributes) {
            this.seenAttributes = seenAttributes;
        }

        public String getId() {
            return this.id;
        }

        public long getLastSeenModified() {
            return this.lastSeenModified;
        }

        public void setLastSeenModified(long lastKnownModified) {
            this.lastSeenModified = lastKnownModified;
        }

        public int getLastUnseenStatus() {
            return this.lastUnseenStatus;
        }

        public void setLastUnseenStatus(int lastUnseenStatus) {
            this.lastUnseenStatus = lastUnseenStatus;
        }
    }

    public static interface IssueAccessor<T> {
        public String getID(T var1);

        public Issue createIssue(T var1);

        public void setIssueData(Issue var1, T var2);

        public Map<String, String> getAttributes(Issue var1);

        public String getRecentChanges(Issue var1);

        public long getLastModified(Issue var1);

        public long getCreated(Issue var1);
    }
}

